/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.methods;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.sourceclear.api.data.artifact.ArtifactComponent;
import com.sourceclear.api.data.artifact.LibraryArtifactApiModel;
import com.sourceclear.api.data.artifact.LibraryMatchWithArtifactsApiModel;
import com.sourceclear.api.data.artifact.VersionRange;
import com.sourceclear.api.data.evidence.CoordinateType;
import com.sourceclear.api.data.evidence.Coordinates;
import com.sourceclear.api.data.evidence.LanguageType;
import com.sourceclear.api.data.evidence.LibraryInstanceModel;
import com.sourceclear.api.data.evidence.LibraryModel;
import com.sourceclear.api.data.methods.CallChainModel;
import com.sourceclear.api.data.methods.InstanceVulnMethod;
import com.sourceclear.api.data.methods.MethodCallData;
import com.sourceclear.api.data.methods.MethodModel;
import com.sourceclear.engine.common.EnvironmentVariableUtils;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.methods.BaseMethodsEngine;
import com.sourceclear.engine.methods.ClassMethodsEngine;
import com.sourceclear.engine.methods.DotNetMethodsEngine;
import com.sourceclear.engine.methods.InstanceFrameworkMethod;
import com.sourceclear.engine.methods.JSMethodsEngine;
import com.sourceclear.engine.methods.MethodsEngine;
import com.sourceclear.engine.methods.PythonMethodsEngine;
import com.sourceclear.engine.methods.RubyMethodsEngine;
import com.sourceclear.engine.methods.VulnerableMethodsCollator;
import com.sourceclear.methods.CallGraph;
import com.sourceclear.methods.CallSite;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.methods.VulnMethodsConfig;
import com.veracode.security.logging.SecureLogger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class VulnerableMethodsCollatorImpl
implements VulnerableMethodsCollator {
    private static final SecureLogger LOGGER = SecureLogger.getLogger(VulnerableMethodsCollatorImpl.class);
    ImmutableMap<LanguageType, BaseMethodsEngine> engines = ImmutableMap.of((Object)LanguageType.JS, (Object)new JSMethodsEngine(), (Object)LanguageType.JAVA, (Object)new ClassMethodsEngine(), (Object)LanguageType.PYTHON, (Object)new PythonMethodsEngine(), (Object)LanguageType.RUBY, (Object)new RubyMethodsEngine(), (Object)LanguageType.CSHARP, (Object)new DotNetMethodsEngine());
    private final LogStream logStream;
    private final Collection<LibraryMatchWithArtifactsApiModel> components;
    private final ImmutableMap<String, Object> scanAttributes;
    private final Multimap<LanguageType, CallSite> dynamicEdges;

    public VulnerableMethodsCollatorImpl(@Nonnull Collection<LibraryMatchWithArtifactsApiModel> components, @Nonnull ImmutableMap<String, Object> scanAttributes, @Nonnull Multimap<LanguageType, CallSite> dynamicEdges, @Nonnull LogStream logStream) {
        this.components = components;
        this.scanAttributes = scanAttributes;
        this.dynamicEdges = dynamicEdges;
        this.logStream = logStream;
    }

    @Override
    public VulnerableMethodsCollator.Result scanPath(@Nonnull Path rootPath) {
        if (!Files.isDirectory(rootPath, new LinkOption[0])) {
            throw new IllegalArgumentException(rootPath + " is not a directory");
        }
        if (!Files.isReadable(rootPath)) {
            throw new IllegalArgumentException(rootPath + " is not readable");
        }
        HashMap<MethodModel, LibraryMatchWithArtifactsApiModel> artifactMethodMap = new HashMap<MethodModel, LibraryMatchWithArtifactsApiModel>();
        HashMap methodAffectedArtifactIdMap = new HashMap();
        ArrayList<MethodCallData> scanResults = new ArrayList<MethodCallData>();
        SetMultimap languageCallGraphs = MultimapBuilder.hashKeys().hashSetValues().build();
        HashMap<CallChainModel, CallSite> spanningEdges = new HashMap<CallChainModel, CallSite>();
        Set<LanguageType> applicableEngines = VulnerableMethodsCollatorImpl.determineApplicableEngines(this.components, (Set<LanguageType>)this.engines.keySet());
        for (LanguageType languageType : applicableEngines) {
            MethodsEngine engine = (MethodsEngine)this.engines.get((Object)languageType);
            if (engine == null) continue;
            HashSet<MethodCallData> scanMethods = new HashSet<MethodCallData>();
            HashSet<MethodInfo> publicMethodStubs = new HashSet<MethodInfo>();
            HashSet<InstanceFrameworkMethod> frameworkMethodsStubs = new HashSet<InstanceFrameworkMethod>();
            for (LibraryMatchWithArtifactsApiModel match : this.components) {
                Coordinates matchCoords;
                LibraryModel comp = match.getComponent();
                if (comp == null) continue;
                List<LibraryInstanceModel> instances = comp.getInstances();
                assert (instances.size() == 1);
                LibraryInstanceModel instance = instances.get(0);
                try {
                    matchCoords = new Coordinates.Builder().withCoordinateType(CoordinateType.toCoordType(comp.getCoordinateType())).withCoordinate1(comp.getCoordinate1()).withCoordinate2(comp.getCoordinate2()).withVersion(instance.getLibraryVersion()).build();
                }
                catch (Exception ex) {
                    LOGGER.debug("Couldn't convert evidence to coordinates, skipping", ex);
                    continue;
                }
                LanguageType componentLanguage = LanguageType.toLanguageType(comp.getLanguageType());
                if (languageType != componentLanguage) continue;
                for (MethodModel methodModel : instance.getPublicMethods()) {
                    publicMethodStubs.add(engine.toMethodInfo(methodModel, false));
                }
                frameworkMethodsStubs.add(new InstanceFrameworkMethod.Builder().libraryInstanceRef(instance.getCoordVersionHash()).addAllFrameworkMethods(instance.getFrameworkMethods()).build());
                String evidenceVersion = matchCoords.getVersion();
                for (LibraryArtifactApiModel artifact : match.getArtifacts()) {
                    List<ArtifactComponent> components = artifact.getArtifactComponents();
                    for (ArtifactComponent component : components) {
                        for (VersionRange versionRange : component.getVersionRanges()) {
                            Map<String, Collection<MethodCallData>> vulnerableMethods = versionRange.getVulnerableMethods();
                            Collection<MethodCallData> componentVersionMethods = vulnerableMethods.get(evidenceVersion);
                            if (componentVersionMethods == null) continue;
                            for (MethodCallData methodCallData : componentVersionMethods) {
                                MethodModel method = methodCallData.getMethod();
                                if (artifactMethodMap.put(method, match) == null) {
                                    scanMethods.add(methodCallData);
                                }
                                Set artifactIdsForMethod = methodAffectedArtifactIdMap.computeIfAbsent(method, k -> new HashSet());
                                artifactIdsForMethod.add(artifact.getId());
                            }
                        }
                    }
                }
            }
            MethodsEngine methodsEngine = engine.withPublicMethodStubs(publicMethodStubs).withDynamicEdges((Set)this.dynamicEdges.get((Object)languageType)).withFrameworkMethodStubs(frameworkMethodsStubs).withVulnMethodsConfig(this.configureVulnerableMethods(engine.defaultConfig()));
            MethodsEngine.Result result = methodsEngine.scanMethods(rootPath, scanMethods, this.logStream);
            scanResults.addAll(result.methodCallData);
            spanningEdges.putAll(result.spanningEdges);
            result.callGraph.forEach(arg_0 -> VulnerableMethodsCollatorImpl.lambda$scanPath$1((Multimap)languageCallGraphs, languageType, arg_0));
        }
        HashMap<String, InstanceVulnMethod.Builder> collator = new HashMap<String, InstanceVulnMethod.Builder>();
        for (MethodCallData scanResult : scanResults) {
            MethodModel method = scanResult.getMethod();
            LibraryMatchWithArtifactsApiModel match = (LibraryMatchWithArtifactsApiModel)artifactMethodMap.get(method);
            if (match == null) continue;
            LibraryModel libraryModel = match.getComponent();
            List<LibraryInstanceModel> instances = libraryModel.getInstances();
            assert (instances.size() == 1);
            LibraryInstanceModel instanceModel = instances.get(0);
            String libraryInstanceRef = instanceModel.getCoordVersionHash();
            InstanceVulnMethod.Builder builder2 = collator.computeIfAbsent(libraryInstanceRef, k -> new InstanceVulnMethod.Builder());
            builder2.setLibraryInstanceRef(libraryInstanceRef);
            Set artifactIds = methodAffectedArtifactIdMap.getOrDefault(method, Collections.emptySet());
            builder2.addAllArtifactIds((Iterable)artifactIds);
            builder2.addMethods(scanResult);
        }
        List<InstanceVulnMethod> list = collator.values().stream().map(builder -> builder.build()).collect(Collectors.toList());
        return new VulnerableMethodsCollator.Result(list, (Multimap<LanguageType, CallGraph>)languageCallGraphs, spanningEdges);
    }

    static Set<LanguageType> determineApplicableEngines(Collection<LibraryMatchWithArtifactsApiModel> components, Set<LanguageType> availableEngines) {
        Set languagesRepresented = components.stream().filter(c -> c.getComponent() != null).map(c -> LanguageType.toLanguageType(c.getComponent().getLanguageType())).collect(Collectors.toSet());
        return Sets.intersection(languagesRepresented, availableEngines);
    }

    private VulnMethodsConfig configureVulnerableMethods(VulnMethodsConfig.Builder config) {
        Object result;
        if (this.scanAttributes.containsKey((Object)"VULN_METHODS_IGNORED_DIRECTORIES") && (result = this.scanAttributes.get((Object)"VULN_METHODS_IGNORED_DIRECTORIES")) instanceof String) {
            config.withIgnoredDirectories(EnvironmentVariableUtils.splitByComma((String)result));
        } else if (this.scanAttributes.containsKey((Object)"VULN_METHODS_EXTRA_IGNORED_DIRECTORIES") && (result = this.scanAttributes.get((Object)"VULN_METHODS_EXTRA_IGNORED_DIRECTORIES")) instanceof String) {
            config.withExtraIgnoredDirectories(EnvironmentVariableUtils.splitByComma((String)result));
        }
        return config.build();
    }

    private static /* synthetic */ void lambda$scanPath$1(Multimap languageCallGraphs, LanguageType languageType, CallGraph graph) {
        languageCallGraphs.put((Object)languageType, (Object)graph);
    }
}

