/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods.dotnet;

import com.sourceclear.analysis.dotnet.SrcDot;
import com.sourceclear.analysis.utils.TempFile;
import com.sourceclear.methods.CHACallSite;
import com.sourceclear.methods.CallChainsInspector;
import com.sourceclear.methods.CallGraph;
import com.sourceclear.methods.CallGraphBuilder;
import com.sourceclear.methods.ClassInfo;
import com.sourceclear.methods.MethodDefinition;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.methods.analyzers.ClassHierarchyAnalyzer;
import com.veracode.security.logging.SecureLogger;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class DotNetCallGraphBuilder
extends CallGraphBuilder {
    private final Set<ClassInfo> classes;
    private final Set<CHACallSite> callSites;
    private final boolean parallel;
    private final CallGraph callGraph = CallChainsInspector.createCallGraph();
    private static final SecureLogger LOGGER = SecureLogger.getLogger(DotNetCallGraphBuilder.class);
    private final Set<MethodInfo> methodsDefined;

    public DotNetCallGraphBuilder(InputStream dll, boolean parallel) throws IOException {
        try (TempFile dllPath = new TempFile("dotnetcha", ".dll");){
            Files.copy(dll, dllPath.path, StandardCopyOption.REPLACE_EXISTING);
            this.classes = SrcDot.getClasses((Path)dllPath.path);
            this.callSites = SrcDot.getCallSites((Path)dllPath.path);
        }
        catch (Exception e) {
            throw new IOException("Unable to read dll to compute call graph", e);
        }
        this.parallel = parallel;
        this.methodsDefined = this.classes.stream().flatMap(classInfo -> classInfo.getMethods().stream()).map(MethodDefinition::getMethod).collect(Collectors.toSet());
    }

    public DotNetCallGraphBuilder(Path dll, boolean parallel) throws IOException {
        try {
            this.classes = SrcDot.getClasses((Path)dll);
            this.callSites = SrcDot.getCallSites((Path)dll);
        }
        catch (Exception e) {
            throw new IOException("Unable to read dll to compute call graph", e);
        }
        this.parallel = parallel;
        this.methodsDefined = this.classes.stream().flatMap(classInfo -> classInfo.getMethods().stream()).map(MethodDefinition::getMethod).collect(Collectors.toSet());
    }

    public DotNetCallGraphBuilder(Collection<Path> dlls, boolean parallel) {
        HashSet<ClassInfo> classes = new HashSet<ClassInfo>();
        HashSet<CHACallSite> callSites2 = new HashSet<CHACallSite>();
        for (Path dll : dlls) {
            try {
                classes.addAll(SrcDot.getClasses((Path)dll));
                callSites2.addAll(SrcDot.getCallSites((Path)dll));
            }
            catch (Exception e) {
                LOGGER.warn("Unable to read dll to compute call graph: " + dll.toString(), e);
            }
        }
        this.classes = classes;
        this.callSites = callSites2;
        this.parallel = parallel;
        this.methodsDefined = classes.stream().flatMap(classInfo -> classInfo.getMethods().stream()).map(MethodDefinition::getMethod).collect(Collectors.toSet());
    }

    @Override
    public void build() {
        ClassHierarchyAnalyzer analyzer = new ClassHierarchyAnalyzer(this.classes, this.parallel);
        Set<CHACallSite> result = analyzer.analyze(this.callSites);
        for (CHACallSite callSite : result) {
            this.callGraph.addEdge(callSite.toCallSite());
        }
    }

    @Override
    public Set<MethodInfo> getMethodsDefined() {
        return this.methodsDefined;
    }

    @Override
    public CallGraph getCallGraph() {
        return this.callGraph;
    }
}

