/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods.java;

import com.sourceclear.analysis.utils.Utils;
import com.sourceclear.methods.CHACallSite;
import com.sourceclear.methods.CallChainsInspector;
import com.sourceclear.methods.CallGraph;
import com.sourceclear.methods.CallGraphBuilder;
import com.sourceclear.methods.CallSite;
import com.sourceclear.methods.ClassInfo;
import com.sourceclear.methods.MethodDefinition;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.methods.analyzers.ClassHierarchyAnalyzer;
import com.sourceclear.methods.analyzers.CodeAnalyzer;
import com.sourceclear.methods.analyzers.ReflectedMethodsAnalyzer;
import com.sourceclear.methods.java.CallGraphClassVisitor;
import com.sourceclear.methods.java.ClassHierarchyClassVisitor;
import com.sourceclear.methods.java.Constants;
import com.veracode.security.logging.SecureLogger;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class JavaCallGraphBuilder
extends CallGraphBuilder {
    private static final SecureLogger LOGGER = SecureLogger.getLogger(JavaCallGraphBuilder.class);
    private final CallGraph callGraph = CallChainsInspector.createCallGraph();
    private final List<ClassReader> classReaders;
    private final Map<ClassReader, Path> classReaderPathMap = new HashMap<ClassReader, Path>();
    private final boolean parallel;
    private Set<ClassInfo> classInfos;
    private Set<CHACallSite> callSites;

    public JavaCallGraphBuilder(List<ClassReader> classReaders, boolean parallel) {
        this.classReaders = classReaders;
        this.parallel = parallel;
        this.collectClassHierarchyAndCallSites();
    }

    public JavaCallGraphBuilder(JarInputStream jarInputStream, boolean parallel) throws IOException {
        this.parallel = parallel;
        ArrayList<ClassReader> classReaders = new ArrayList<ClassReader>();
        Utils.readEntries(jarInputStream, classReader -> {
            classReaders.add(classReader);
            return Optional.empty();
        });
        this.classReaders = classReaders;
        this.collectClassHierarchyAndCallSites();
    }

    public JavaCallGraphBuilder(Collection<Path> paths, boolean parallel) throws IOException {
        this.parallel = parallel;
        ArrayList<ClassReader> classReaders = new ArrayList<ClassReader>();
        for (Path path : paths) {
            ClassReader cr;
            try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
                cr = new ClassReader(in);
                cr.getClassName();
            }
            catch (RuntimeException e) {
                this.handleClassFileError(e, path);
                continue;
            }
            classReaders.add(cr);
            this.classReaderPathMap.put(cr, path);
        }
        this.classReaders = classReaders;
        this.collectClassHierarchyAndCallSites();
    }

    public JavaCallGraphBuilder(JarFile jarFile, boolean parallel) {
        this.classReaders = Utils.classReaders(jarFile);
        this.parallel = parallel;
        this.collectClassHierarchyAndCallSites();
    }

    @Override
    public void build() {
        HashSet<ClassInfo> allClassInfos = new HashSet<ClassInfo>(new HashSet<ClassInfo>(this.classInfos));
        allClassInfos.addAll(Constants.JAVA_CLASSES);
        List<CodeAnalyzer> codeAnalyzers = Arrays.asList(new ClassHierarchyAnalyzer(allClassInfos, this.parallel), new ReflectedMethodsAnalyzer(allClassInfos, this.parallel));
        Set<CHACallSite> analysisResult = this.callSites;
        for (CodeAnalyzer analyzer : codeAnalyzers) {
            analysisResult = analyzer.analyzeTimed(analysisResult);
        }
        for (CHACallSite callSite : analysisResult) {
            this.callGraph.addEdge(callSite.toCallSite());
        }
    }

    @Override
    public Set<MethodInfo> getMethodsDefined() {
        return this.classInfos.stream().flatMap(classInfo -> classInfo.getMethods().stream()).map(MethodDefinition::getMethod).collect(Collectors.toSet());
    }

    @Override
    public boolean isTestMethod(MethodInfo m) {
        return m.getClassName() != null && m.getClassName().endsWith("Test") && !Objects.equals(m.getMethodName(), "<init>") && !Objects.equals(m.getMethodName(), "<clinit>");
    }

    @Override
    public boolean isTestFrameworkEntryPoint(CallSite callSite) {
        boolean calledByJUnitRunner = callSite.getCaller().getClassName() != null && callSite.getCaller().getClassName().matches("org/junit/runners/.*");
        boolean calledByTestNGRunner = Objects.equals(callSite.getCaller().getClassName(), "org/testng/internal/ObjectFactoryImpl") && Objects.equals(callSite.getCaller().getMethodName(), "newInstance");
        return (calledByJUnitRunner || calledByTestNGRunner) && this.isTestMethod(callSite.getCallee());
    }

    private void collectClassHierarchyAndCallSites() {
        this.classInfos = this.getClassReaderStream().map(cr -> {
            String className = "<unknown>";
            try {
                className = cr.getClassName();
                ClassHierarchyClassVisitor classHierarchyVisitor = new ClassHierarchyClassVisitor(589824, className);
                cr.accept((ClassVisitor)classHierarchyVisitor, 0);
                return Optional.of(classHierarchyVisitor.getClassInfo());
            }
            catch (RuntimeException e) {
                this.handleClassFileError(e, (ClassReader)cr, className);
                return Optional.empty();
            }
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        this.callSites = this.getClassReaderStream().flatMap(cr -> {
            String className = cr.getClassName();
            CallGraphClassVisitor visitor2 = new CallGraphClassVisitor(className, 589824);
            try {
                cr.accept((ClassVisitor)visitor2, 0);
                return visitor2.getCallSites().stream();
            }
            catch (RuntimeException e) {
                this.handleClassFileError(e, (ClassReader)cr, className);
                return Stream.of(new CHACallSite[0]);
            }
        }).collect(Collectors.toSet());
    }

    private Stream<ClassReader> getClassReaderStream() {
        return this.parallel ? this.classReaders.parallelStream() : this.classReaders.stream();
    }

    private void handleClassFileError(Exception e, @NotNull ClassReader cr, String className) {
        Path path = this.classReaderPathMap.get(cr);
        if (path != null) {
            this.handleClassFileError(e, path);
        } else {
            LOGGER.debug("Error reading bytecode of class {}", (Object)className, (Object)e);
        }
    }

    private void handleClassFileError(Exception e, @NotNull Path path) {
        LOGGER.debug("Error reading bytecode of class at {}", (Object)path, (Object)e);
    }

    @Override
    public CallGraph getCallGraph() {
        return this.callGraph;
    }
}

