/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods.js;

import com.sourceclear.analysis.utils.Utils;
import com.sourceclear.methods.Cleaner;
import com.sourceclear.methods.EntryPointResolver;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.methods.MethodScanner;
import com.sourceclear.methods.MethodScannerFactory;
import com.sourceclear.methods.VulnMethodsConfig;
import com.sourceclear.methods.VulnerablePartsDetector;
import com.sourceclear.methods.js.JSCallGraphBuilder;
import com.veracode.security.logging.SecureLogger;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Optional;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;

public class JSMethodScannerFactory
extends MethodScannerFactory {
    private static final SecureLogger LOGGER = SecureLogger.getLogger(JSMethodScannerFactory.class);

    @Override
    public VulnMethodsConfig.Builder defaultVulnMethodsConfig() {
        return VulnMethodsConfig.Builder.js();
    }

    @Override
    public MethodScanner forArchiveStream(InputStream archiveStream, Collection<MethodInfo> vulnerableMethods, EntryPointResolver entryPointResolver) throws IOException {
        Path tempDir = Files.createTempDirectory("js-package", new FileAttribute[0]);
        InputStream stream = archiveStream;
        try {
            stream = new CompressorStreamFactory().createCompressorInputStream(stream);
        }
        catch (CompressorException e) {
            LOGGER.debug("Unable to decompress using autodetector: " + e.getMessage());
        }
        if (!stream.markSupported()) {
            stream = new BufferedInputStream(stream);
        }
        try {
            VulnerablePartsDetector vulnerablePartsDetector;
            block18: {
                ArchiveInputStream archiveInputStream = new ArchiveStreamFactory().createArchiveInputStream(stream);
                try {
                    Path scanRoot;
                    Utils.unarchiveIntoDirectory(archiveInputStream, tempDir);
                    Path packageDir = tempDir.resolve("package");
                    if (!Files.exists(packageDir, new LinkOption[0])) {
                        LOGGER.error("Unable to find the `package` directory for npm package");
                        Optional<Path> first = Files.list(tempDir).findFirst();
                        if (Files.list(tempDir).count() == 1L && first.isPresent()) {
                            scanRoot = first.get();
                            LOGGER.debug("Falling back to an inner directory: {}", (Object)scanRoot);
                        } else {
                            scanRoot = tempDir;
                            LOGGER.debug("Falling back to the root of the archive: {}", (Object)scanRoot);
                        }
                    } else {
                        scanRoot = packageDir;
                    }
                    JSCallGraphBuilder callGraphBuilder = new JSCallGraphBuilder(scanRoot, this.config);
                    vulnerablePartsDetector = new VulnerablePartsDetector(vulnerableMethods, entryPointResolver, callGraphBuilder, this.input, () -> FileUtils.deleteQuietly((File)scanRoot.toFile()));
                    if (archiveInputStream == null) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        if (archiveInputStream != null) {
                            try {
                                archiveInputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ArchiveException e) {
                        throw new IOException(e);
                    }
                }
                archiveInputStream.close();
            }
            return vulnerablePartsDetector;
        }
        finally {
            IOUtils.closeQuietly((Closeable)archiveStream);
        }
    }

    @Override
    public MethodScanner forFiles(Collection<Path> files2, Collection<MethodInfo> vulnerableMethods, EntryPointResolver entryPointResolver) {
        throw new UnsupportedOperationException("File scanning is unsupported");
    }

    @Override
    public MethodScanner forDirectory(Path directory, Collection<MethodInfo> vulnerableMethods, EntryPointResolver entryPointResolver) throws IOException {
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            throw new IOException(String.format("Not a directory: %s", directory));
        }
        JSCallGraphBuilder callGraphBuilder = new JSCallGraphBuilder(directory, this.config);
        return new VulnerablePartsDetector(vulnerableMethods, entryPointResolver, callGraphBuilder, this.input, Cleaner.DO_NOTHING);
    }
}

