/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.scm.core;

import java.util.HashMap;
import java.util.Map;

public enum SCMType {
    GITHUB("GitHub"),
    GITHUBENTERPRISE("GitHub Enterprise"),
    STASH("Stash"),
    BITBUCKET("Bitbucket"),
    BITBUCKETSERVER("Bitbucket Server"),
    KILN("Kiln"),
    GITLABCOMMUNITY("GitLab Community"),
    GITLABENTERPRISE("GitLab Enterprise"),
    SUBVERSIONCLOUD("Apache Subversion - Cloud"),
    SUBVERSIONHOSTED("Apache Subversion - Self-hosted"),
    FOUNDATIONCLOUD("Team Foundation - Cloud"),
    FOUNDATIONHOSTED("Team Foundation - Self-hosted"),
    OTHERCLOUD("Other - Cloud"),
    OTHERHOSTED("Other - Self-hosted"),
    GIT("Git Server - Self-hosted"),
    GITLAB("GitLab");

    private static final Map<String, SCMType> lookupMap;
    private final String name;

    public static SCMType fromTitle(String title) {
        return lookupMap.get(title.toUpperCase());
    }

    private SCMType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isGitHubType() {
        return this == GITHUB || this == GITHUBENTERPRISE;
    }

    static {
        lookupMap = new HashMap<String, SCMType>();
        for (SCMType type : SCMType.values()) {
            lookupMap.put(type.name.toUpperCase(), type);
        }
    }
}

