/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.jdbc.config;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbSchema;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbSpec;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbTable;
import com.stratio.deep.commons.config.DeepJobConfig;
import com.stratio.deep.commons.config.ExtractorConfig;
import com.stratio.deep.commons.entity.Cells;
import com.stratio.deep.commons.exception.DeepGenericException;
import com.stratio.deep.commons.filter.Filter;
import com.stratio.deep.commons.filter.FilterType;
import com.stratio.deep.jdbc.config.IJdbcDeepJobConfig;
import com.stratio.deep.jdbc.extractor.JdbcNativeCellExtractor;
import com.stratio.deep.jdbc.extractor.JdbcNativeEntityExtractor;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class JdbcDeepJobConfig<T>
extends DeepJobConfig<T, JdbcDeepJobConfig<T>>
implements IJdbcDeepJobConfig<T, JdbcDeepJobConfig<T>>,
Serializable {
    private static final long serialVersionUID = -3772553194634727039L;
    private Class driverClass;
    private String connectionUrl;
    private transient DbSpec dbSpec = new DbSpec();
    private transient SelectQuery query;
    private transient DbSchema dbSchema;
    private transient DbTable dbTable;
    private transient DbColumn sort;
    private transient DbColumn partitionKey;
    private int upperBound = 0x7FFFFFFE;
    private int lowerBound = 0;
    private int numPartitions = 1;
    private boolean quoteSql;

    public JdbcDeepJobConfig() {
    }

    public JdbcDeepJobConfig(Class<T> entityClass) {
        super(entityClass);
        this.extractorImplClass = Cells.class.isAssignableFrom(entityClass) ? JdbcNativeCellExtractor.class : JdbcNativeEntityExtractor.class;
    }

    public JdbcDeepJobConfig<T> initialize() throws IllegalStateException {
        this.validate();
        return this;
    }

    public JdbcDeepJobConfig<T> initialize(ExtractorConfig extractorConfig) {
        Map values = extractorConfig.getValues();
        if (values.get("catalog") != null) {
            this.database(extractorConfig.getString("catalog"));
        }
        if (values.get("table") != null) {
            this.table(extractorConfig.getString("table"));
        }
        super.initialize(extractorConfig);
        if (values.get("filterQuery") != null) {
            this.filters(extractorConfig.getFilterArray("filterQuery"));
        }
        if (values.get("driverClass") != null) {
            this.driverClass(extractorConfig.getString("driverClass"));
        }
        if (values.get("connectionUrl") != null) {
            this.connectionUrl(extractorConfig.getString("connectionUrl"));
        }
        if (values.get("jdbcQuoteSQL") != null) {
            this.quoteSql(extractorConfig.getBoolean("jdbcQuoteSQL"));
        }
        if (values.get("partitionKey") != null) {
            this.partitionKey(extractorConfig.getString("partitionKey"));
        }
        if (values.get("numPartitions") != null) {
            this.numPartitions(extractorConfig.getInteger("numPartitions"));
        }
        if (values.get("lowerBound") != null) {
            this.lowerBound(extractorConfig.getInteger("lowerBound"));
        }
        if (values.get("upperBound") != null) {
            this.upperBound(extractorConfig.getInteger("upperBound"));
        }
        this.initialize();
        return this;
    }

    private void validate() {
        if (this.driverClass == null) {
            throw new IllegalArgumentException("Driver class must be specified");
        }
        if (this.catalog == null || this.catalog.isEmpty()) {
            throw new IllegalArgumentException("Schema name must be specified");
        }
        if (this.table == null || this.table.isEmpty()) {
            throw new IllegalArgumentException("Table name must be specified");
        }
        if (this.connectionUrl == null || this.connectionUrl.isEmpty()) {
            if (this.host != null && !this.host.isEmpty() && this.port > 0) {
                this.connectionUrl(this.getJdbcUrl());
            } else {
                throw new IllegalArgumentException("You must specify at least one of connectionUrl or host and port properties");
            }
        }
        if (this.partitionKey == null && this.numPartitions > 1) {
            throw new IllegalArgumentException("You must define a valid partition key for using more than one partition.");
        }
    }

    public JdbcDeepJobConfig<T> filters(Filter[] filters) {
        this.filters = filters;
        return this;
    }

    @Override
    public SelectQuery getQuery() {
        SelectQuery selectQuery = new SelectQuery();
        List columns = this.dbTable.getColumns();
        if (!columns.isEmpty()) {
            selectQuery.addColumns(columns.toArray(new Column[columns.size()]));
        } else {
            selectQuery.addAllTableColumns((Table)this.dbTable);
        }
        selectQuery.addFromTable((Table)this.dbTable);
        if (this.sort != null) {
            selectQuery.addOrderings(new Column[]{this.sort});
        }
        this.applyFilters(selectQuery);
        this.query = selectQuery;
        return this.query;
    }

    @Override
    public JdbcDeepJobConfig<T> connectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
        return this;
    }

    @Override
    public String getConnectionUrl() {
        if (this.connectionUrl == null || this.connectionUrl.isEmpty()) {
            return this.getJdbcUrl();
        }
        return this.connectionUrl;
    }

    @Override
    public JdbcDeepJobConfig<T> driverClass(String driverClass) {
        try {
            this.driverClass = Class.forName(driverClass);
        }
        catch (ClassNotFoundException e) {
            throw new DeepGenericException("Class " + driverClass + "not found", (Throwable)e);
        }
        return this;
    }

    @Override
    public String getDriverClass() {
        return this.driverClass.getCanonicalName();
    }

    @Override
    public JdbcDeepJobConfig<T> database(String database) {
        this.catalog = database;
        this.dbSchema = new DbSchema(this.dbSpec, this.catalog);
        return this;
    }

    @Override
    public String getDatabase() {
        return this.catalog;
    }

    public JdbcDeepJobConfig<T> table(String table) {
        this.table = table;
        if (this.dbSchema != null) {
            this.dbTable = new DbTable(this.dbSchema, table, table);
        }
        return this;
    }

    public JdbcDeepJobConfig<T> inputColumns(String ... columns) {
        if (this.dbTable != null) {
            for (String column : columns) {
                this.dbTable.addColumn(column);
            }
        }
        return this;
    }

    @Override
    public JdbcDeepJobConfig<T> sort(String sort) {
        if (this.dbTable != null) {
            this.sort = new DbColumn(this.dbTable, sort, "", new Object[0]);
        }
        return this;
    }

    @Override
    public DbColumn getSort() {
        return this.sort;
    }

    @Override
    public JdbcDeepJobConfig<T> partitionKey(String partitionKey) {
        if (this.dbTable != null) {
            this.partitionKey = new DbColumn(this.dbTable, partitionKey, "", new Object[0]);
        }
        return this;
    }

    @Override
    public DbColumn getPartitionKey() {
        return this.partitionKey;
    }

    @Override
    public JdbcDeepJobConfig<T> upperBound(int upperBound) {
        this.upperBound = upperBound;
        return this;
    }

    @Override
    public int getUpperBound() {
        return this.upperBound;
    }

    @Override
    public JdbcDeepJobConfig<T> lowerBound(int lowerBound) {
        this.lowerBound = lowerBound;
        return this;
    }

    @Override
    public int getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public JdbcDeepJobConfig<T> numPartitions(int numPartitions) {
        this.numPartitions = numPartitions;
        return this;
    }

    @Override
    public int getNumPartitions() {
        return this.numPartitions;
    }

    @Override
    public JdbcDeepJobConfig<T> quoteSql(boolean quoteSql) {
        this.quoteSql = quoteSql;
        return this;
    }

    @Override
    public boolean getQuoteSql() {
        return this.quoteSql;
    }

    private String getJdbcUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append("jdbc:");
        sb.append(this.getJdbcProvider());
        sb.append("://");
        sb.append((String)this.host.get(0));
        sb.append(":");
        sb.append(this.port);
        sb.append("/");
        sb.append(this.catalog);
        sb.append("?");
        return sb.toString();
    }

    private String getJdbcProvider() {
        int firstIndex = this.driverClass.toString().indexOf(".");
        int secondIndex = this.driverClass.toString().indexOf(".", ++firstIndex);
        return this.driverClass.toString().substring(firstIndex, secondIndex);
    }

    private void applyFilters(SelectQuery query) {
        if (this.filters != null && this.filters.length > 0) {
            ComboCondition comboCondition = new ComboCondition(ComboCondition.Op.AND);
            if (this.filters.length > 0) {
                for (int i = 0; i < this.filters.length; ++i) {
                    Filter filter = this.filters[i];
                    FilterType filterType = filter.getFilterType();
                    DbColumn filterColumn = new DbColumn(this.dbTable, filter.getField(), "", new Object[0]);
                    if (filterType.equals((Object)FilterType.EQ)) {
                        comboCondition.addCondition((Condition)BinaryCondition.equalTo((Object)filterColumn, (Object)filter.getValue()));
                        continue;
                    }
                    if (filterType.equals((Object)FilterType.GT)) {
                        comboCondition.addCondition((Condition)BinaryCondition.greaterThan((Object)filterColumn, (Object)filter.getValue(), (boolean)false));
                        continue;
                    }
                    if (filterType.equals((Object)FilterType.LT)) {
                        comboCondition.addCondition((Condition)BinaryCondition.lessThan((Object)filterColumn, (Object)filter.getValue(), (boolean)false));
                        continue;
                    }
                    if (filterType.equals((Object)FilterType.GTE)) {
                        comboCondition.addCondition((Condition)BinaryCondition.greaterThan((Object)filterColumn, (Object)filter.getValue(), (boolean)true));
                        continue;
                    }
                    if (filterType.equals((Object)FilterType.LTE)) {
                        comboCondition.addCondition((Condition)BinaryCondition.lessThan((Object)filterColumn, (Object)filter.getValue(), (boolean)true));
                        continue;
                    }
                    if (filterType.equals((Object)FilterType.NEQ)) {
                        comboCondition.addCondition((Condition)BinaryCondition.notEqualTo((Object)filterColumn, (Object)filter.getValue()));
                        continue;
                    }
                    throw new UnsupportedOperationException("Currently, the filter operation " + filterType + " is not supported");
                }
            }
            query.addCondition((Condition)comboCondition);
        }
    }
}

