/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.jdbc.config;

import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import com.stratio.deep.commons.config.DeepJobConfig;
import com.stratio.deep.commons.config.ExtractorConfig;
import com.stratio.deep.commons.entity.Cells;
import com.stratio.deep.jdbc.config.IJdbcDeepJobConfig;
import com.stratio.deep.jdbc.extractor.JdbcNeo4JNativeCellExtractor;
import com.stratio.deep.jdbc.extractor.JdbcNeo4JNativeEntityExtractor;
import java.io.Serializable;
import java.util.Map;
import org.neo4j.jdbc.Driver;

public class JdbcNeo4JDeepJobConfig<T>
extends DeepJobConfig<T, JdbcNeo4JDeepJobConfig<T>>
implements IJdbcDeepJobConfig<T, JdbcNeo4JDeepJobConfig<T>>,
Serializable {
    private static final long serialVersionUID = 2175797074628634327L;
    private String connectionUrl;
    private String cypherQuery;
    private int lowerBound = 0;
    private int upperBound = 0x7FFFFFFE;
    private int numPartitions = 1;

    public JdbcNeo4JDeepJobConfig() {
    }

    public JdbcNeo4JDeepJobConfig(Class<T> entityClass) {
        super(entityClass);
        this.extractorImplClass = Cells.class.isAssignableFrom(entityClass) ? JdbcNeo4JNativeCellExtractor.class : JdbcNeo4JNativeEntityExtractor.class;
    }

    public JdbcNeo4JDeepJobConfig<T> initialize() {
        this.validate();
        return this;
    }

    public JdbcNeo4JDeepJobConfig<T> initialize(ExtractorConfig config) {
        Map values = config.getValues();
        if (values.get("connectionUrl") != null) {
            this.connectionUrl(config.getString("connectionUrl"));
        }
        if (values.get("jdbcQuery") != null) {
            this.cypherQuery(config.getString("jdbcQuery"));
        }
        super.initialize(config);
        return this;
    }

    private void validate() {
        if (this.connectionUrl == null || this.connectionUrl.isEmpty()) {
            throw new IllegalArgumentException("You must specify at least one of connectionUrl or host and port properties");
        }
        if (this.cypherQuery == null || this.cypherQuery.isEmpty()) {
            throw new IllegalArgumentException("You must specify the Cypher query to execute.");
        }
    }

    @Override
    public JdbcNeo4JDeepJobConfig<T> driverClass(String driverClass) {
        return this;
    }

    @Override
    public String getDriverClass() {
        return Driver.class.getCanonicalName();
    }

    @Override
    public JdbcNeo4JDeepJobConfig<T> connectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
        return this;
    }

    @Override
    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    @Override
    public JdbcNeo4JDeepJobConfig<T> database(String database) {
        return this;
    }

    @Override
    public String getDatabase() {
        return "NEO4J";
    }

    @Override
    public JdbcNeo4JDeepJobConfig<T> sort(String sort) {
        throw new UnsupportedOperationException("Cannot configure sort for Neo4J extractor");
    }

    @Override
    public DbColumn getSort() {
        throw new UnsupportedOperationException("Cannot configure sort for Neo4J extractor");
    }

    @Override
    public JdbcNeo4JDeepJobConfig<T> partitionKey(String partitionKey) {
        throw new UnsupportedOperationException("Cannot configure partitioning for Neo4J extractor");
    }

    @Override
    public DbColumn getPartitionKey() {
        throw new UnsupportedOperationException("Cannot configure partitioning for Neo4J extractor");
    }

    @Override
    public JdbcNeo4JDeepJobConfig<T> upperBound(int upperBound) {
        throw new UnsupportedOperationException("Cannot configure partitioning for Neo4J extractor");
    }

    public JdbcNeo4JDeepJobConfig<T> cypherQuery(String cypherQuery) {
        this.cypherQuery = cypherQuery;
        return this;
    }

    public String getCypherQuery() {
        return this.cypherQuery;
    }

    @Override
    public int getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public JdbcNeo4JDeepJobConfig<T> numPartitions(int numPartitions) {
        throw new UnsupportedOperationException("Cannot configure partitioning for Neo4J extractor");
    }

    @Override
    public int getNumPartitions() {
        return this.numPartitions;
    }

    @Override
    public SelectQuery getQuery() {
        throw new UnsupportedOperationException("Cannot configure SQL query for Neo4J extractor");
    }

    @Override
    public JdbcNeo4JDeepJobConfig<T> quoteSql(boolean quoteSql) {
        throw new UnsupportedOperationException("Cannot configure SQL formatfor Neo4J extractor");
    }

    @Override
    public boolean getQuoteSql() {
        throw new UnsupportedOperationException("Cannot configure SQL format for Neo4J extractor");
    }

    @Override
    public int getUpperBound() {
        return this.upperBound;
    }

    @Override
    public JdbcNeo4JDeepJobConfig<T> lowerBound(int lowerBound) {
        throw new UnsupportedOperationException("Cannot configure partitioning for Neo4J extractor");
    }
}

