/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.jdbc.extractor;

import com.stratio.deep.commons.exception.DeepTransformException;
import com.stratio.deep.jdbc.config.JdbcDeepJobConfig;
import com.stratio.deep.jdbc.extractor.JdbcNativeExtractor;
import com.stratio.deep.jdbc.utils.UtilJdbc;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

public class JdbcNativeEntityExtractor<T>
extends JdbcNativeExtractor<T, JdbcDeepJobConfig<T>> {
    private static final long serialVersionUID = 957463022436044036L;

    public JdbcNativeEntityExtractor(Class<T> t) {
        this.jdbcDeepJobConfig = new JdbcDeepJobConfig<T>(t);
    }

    @Override
    protected T transformElement(Map<String, Object> entity) {
        try {
            return UtilJdbc.getObjectFromRow(this.jdbcDeepJobConfig.getEntityClass(), entity, this.jdbcDeepJobConfig);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new DeepTransformException((Throwable)e);
        }
    }

    @Override
    protected Map<String, Object> transformElement(T entity) {
        try {
            return UtilJdbc.getRowFromObject(entity);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new DeepTransformException((Throwable)e);
        }
    }
}

