/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.jdbc.extractor;

import com.stratio.deep.commons.config.BaseConfig;
import com.stratio.deep.commons.exception.DeepGenericException;
import com.stratio.deep.commons.querybuilder.UpdateQueryBuilder;
import com.stratio.deep.commons.rdd.IExtractor;
import com.stratio.deep.commons.utils.Utils;
import com.stratio.deep.jdbc.config.JdbcDeepJobConfig;
import com.stratio.deep.jdbc.reader.IJdbcReader;
import com.stratio.deep.jdbc.reader.JdbcReader;
import com.stratio.deep.jdbc.writer.JdbcWriter;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.spark.Partition;
import org.apache.spark.rdd.JdbcPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JdbcNativeExtractor<T, S extends BaseConfig>
implements IExtractor<T, S> {
    private static final long serialVersionUID = -298383130965427783L;
    private static final Logger LOG = LoggerFactory.getLogger(JdbcNativeExtractor.class);
    protected JdbcDeepJobConfig<T> jdbcDeepJobConfig;
    protected IJdbcReader jdbcReader;
    protected JdbcWriter<T> jdbcWriter;

    public Partition[] getPartitions(S config) {
        this.jdbcDeepJobConfig = (JdbcDeepJobConfig)Utils.initConfig(config, this.jdbcDeepJobConfig);
        int upperBound = this.jdbcDeepJobConfig.getUpperBound();
        int lowerBound = this.jdbcDeepJobConfig.getLowerBound();
        int numPartitions = this.jdbcDeepJobConfig.getNumPartitions();
        int length = 1 + upperBound - lowerBound;
        Partition[] result = new Partition[numPartitions];
        for (int i = 0; i < numPartitions; ++i) {
            int start = lowerBound + lowerBound + i * length / numPartitions;
            int end = lowerBound + (i + 1) * length / numPartitions - 1;
            result[i] = new JdbcPartition(i, (long)start, (long)end);
        }
        return result;
    }

    public boolean hasNext() {
        try {
            return this.jdbcReader.hasNext();
        }
        catch (SQLException e) {
            throw new DeepGenericException((Throwable)e);
        }
    }

    public T next() {
        try {
            return this.transformElement(this.jdbcReader.next());
        }
        catch (SQLException e) {
            throw new DeepGenericException((Throwable)e);
        }
    }

    public void close() {
        if (this.jdbcReader != null) {
            try {
                this.jdbcReader.close();
            }
            catch (Exception e) {
                LOG.error("Unable to close jdbcReader", (Throwable)e);
            }
        }
        if (this.jdbcWriter != null) {
            try {
                this.jdbcWriter.close();
            }
            catch (Exception e) {
                LOG.error("Unable to close jdbcWriter", (Throwable)e);
            }
        }
    }

    public void initIterator(Partition dp, S config) {
        this.jdbcDeepJobConfig = (JdbcDeepJobConfig)Utils.initConfig(config, this.jdbcDeepJobConfig);
        this.jdbcReader = new JdbcReader(this.jdbcDeepJobConfig);
        try {
            this.jdbcReader.init(dp);
        }
        catch (Exception e) {
            throw new DeepGenericException("Unable to initialize JdbcReader", (Throwable)e);
        }
    }

    public void saveRDD(T t) {
        try {
            this.jdbcWriter.save(this.transformElement(t));
        }
        catch (Exception e) {
            throw new DeepGenericException("Error while writing row", (Throwable)e);
        }
    }

    public List<String> getPreferredLocations(Partition split) {
        return null;
    }

    public void initSave(S config, T first, UpdateQueryBuilder queryBuilder) {
        this.jdbcDeepJobConfig = (JdbcDeepJobConfig)Utils.initConfig(config, this.jdbcDeepJobConfig);
        try {
            this.jdbcWriter = new JdbcWriter(this.jdbcDeepJobConfig);
        }
        catch (Exception e) {
            throw new DeepGenericException((Throwable)e);
        }
    }

    protected abstract T transformElement(Map<String, Object> var1);

    protected abstract Map<String, Object> transformElement(T var1);
}

