/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.jdbc.reader;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import com.stratio.deep.jdbc.config.JdbcDeepJobConfig;
import com.stratio.deep.jdbc.reader.IJdbcReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.apache.spark.Partition;
import org.apache.spark.rdd.JdbcPartition;

public class JdbcReader
implements IJdbcReader {
    private JdbcDeepJobConfig jdbcDeepJobConfig;
    protected Connection conn;
    protected ResultSet resultSet;
    protected boolean hasNext = false;

    protected JdbcReader() {
    }

    public JdbcReader(JdbcDeepJobConfig config) {
        this.jdbcDeepJobConfig = config;
    }

    @Override
    public void init(Partition p) throws Exception {
        Class.forName(this.jdbcDeepJobConfig.getDriverClass());
        this.conn = DriverManager.getConnection(this.jdbcDeepJobConfig.getConnectionUrl(), this.jdbcDeepJobConfig.getUsername(), this.jdbcDeepJobConfig.getPassword());
        Statement statement = this.conn.createStatement();
        SelectQuery query = this.jdbcDeepJobConfig.getQuery();
        JdbcPartition jdbcPartition = (JdbcPartition)p;
        if (this.jdbcDeepJobConfig.getNumPartitions() > 1) {
            DbColumn partitionKey = this.jdbcDeepJobConfig.getPartitionKey();
            query.getWhereClause().addCondition((Condition)BinaryCondition.lessThan((Object)partitionKey, (Object)jdbcPartition.upper(), (boolean)true)).addCondition((Condition)BinaryCondition.greaterThan((Object)partitionKey, (Object)jdbcPartition.lower(), (boolean)true));
        }
        this.resultSet = statement.executeQuery(query.toString());
        this.hasNext = this.resultSet.next();
    }

    @Override
    public boolean hasNext() throws SQLException {
        return this.hasNext;
    }

    @Override
    public Map<String, Object> next() throws SQLException {
        HashMap<String, Object> row = new HashMap<String, Object>();
        ResultSetMetaData metadata = this.resultSet.getMetaData();
        int columnsNumber = metadata.getColumnCount();
        for (int i = 1; i <= columnsNumber; ++i) {
            String columnName = metadata.getColumnName(i);
            row.put(columnName, this.resultSet.getObject(i));
        }
        this.hasNext = this.resultSet.next();
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        try {
            if (this.resultSet != null) {
                this.resultSet.close();
            }
        }
        finally {
            if (this.conn != null) {
                this.conn.close();
            }
        }
    }

    public void setJdbcDeepJobConfig(JdbcDeepJobConfig jdbcDeepJobConfig) {
        this.jdbcDeepJobConfig = jdbcDeepJobConfig;
    }
}

