/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.jdbc.utils;

import com.stratio.deep.commons.config.DeepJobConfig;
import com.stratio.deep.commons.entity.Cell;
import com.stratio.deep.commons.entity.Cells;
import com.stratio.deep.commons.utils.AnnotationUtils;
import com.stratio.deep.commons.utils.Utils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtilJdbc {
    private static final Logger LOG = LoggerFactory.getLogger(UtilJdbc.class);

    public static <T, S extends DeepJobConfig> T getObjectFromRow(Class<T> classEntity, Map<String, Object> row, DeepJobConfig<T, S> config) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        Field[] fields;
        T t = classEntity.newInstance();
        for (Field field : fields = AnnotationUtils.filterDeepFields(classEntity)) {
            Object currentRow = null;
            Method method = null;
            Class<?> classField = field.getType();
            try {
                method = Utils.findSetter((String)field.getName(), classEntity, field.getType());
                currentRow = row.get(AnnotationUtils.deepFieldName((Field)field));
                if (currentRow == null) continue;
                method.invoke(t, currentRow);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                LOG.error("impossible to create a java object from column:" + field.getName() + " and type:" + field.getType() + " and value:" + t + "; recordReceived:" + currentRow);
                method.invoke(t, Utils.castNumberType((Object)currentRow, classField));
            }
        }
        return t;
    }

    public static <T> Map<String, Object> getRowFromObject(T entity) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        Field[] fields = AnnotationUtils.filterDeepFields(entity.getClass());
        HashMap<String, Object> row = new HashMap<String, Object>();
        for (Field field : fields) {
            Method method = Utils.findGetter((String)field.getName(), entity.getClass());
            Object object = method.invoke(entity, new Object[0]);
            if (object == null) continue;
            row.put(AnnotationUtils.deepFieldName((Field)field), object);
        }
        return row;
    }

    public static <T extends DeepJobConfig> Cells getCellsFromObject(Map<String, Object> row, DeepJobConfig<Cells, T> config) {
        Cells result = new Cells(config.getCatalog() + "." + config.getTable());
        for (Map.Entry<String, Object> entry : row.entrySet()) {
            Cell cell = Cell.create((String)entry.getKey(), (Object)entry.getValue());
            result.add(cell);
        }
        return result;
    }

    public static Map<String, Object> getObjectFromCells(Cells cells) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Cell cell : cells.getCells()) {
            result.put(cell.getName(), cell.getValue());
        }
        return result;
    }
}

