/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.jdbc.writer;

import com.stratio.deep.jdbc.config.JdbcDeepJobConfig;
import com.stratio.deep.jdbc.writer.IJdbcWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import scala.Tuple2;

public class JdbcWriter<T>
implements IJdbcWriter {
    private JdbcDeepJobConfig<T> jdbcDeepJobConfig;
    protected Connection conn;

    protected JdbcWriter() {
    }

    public JdbcWriter(JdbcDeepJobConfig jdbcDeepJobConfig) throws Exception {
        this.jdbcDeepJobConfig = jdbcDeepJobConfig;
        Class.forName(jdbcDeepJobConfig.getDriverClass());
        this.conn = DriverManager.getConnection(jdbcDeepJobConfig.getConnectionUrl(), jdbcDeepJobConfig.getUsername(), jdbcDeepJobConfig.getPassword());
    }

    @Override
    public void save(Map<String, Object> row) throws Exception {
        Tuple2<List<String>, String> data = this.sqlFromRow(row);
        PreparedStatement statement = this.conn.prepareStatement((String)data._2());
        int i = 1;
        for (String columnName : (List)data._1()) {
            statement.setObject(i, row.get(columnName));
            ++i;
        }
        statement.executeUpdate();
    }

    @Override
    public void close() throws SQLException {
        this.conn.close();
    }

    private Tuple2<List<String>, String> sqlFromRow(Map<String, Object> row) {
        ArrayList<String> params = new ArrayList<String>();
        for (int i = 0; i < row.size(); ++i) {
            params.add("?");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ");
        if (this.jdbcDeepJobConfig.getQuoteSql()) {
            sb.append("\"");
        }
        sb.append(this.jdbcDeepJobConfig.getDatabase());
        if (this.jdbcDeepJobConfig.getQuoteSql()) {
            sb.append("\"");
        }
        sb.append(".");
        if (this.jdbcDeepJobConfig.getQuoteSql()) {
            sb.append("\"");
        }
        sb.append(this.jdbcDeepJobConfig.getTable());
        if (this.jdbcDeepJobConfig.getQuoteSql()) {
            sb.append("\"");
        }
        sb.append("(");
        ArrayList<String> columns = new ArrayList<String>(row.keySet());
        ArrayList<String> quotedColumns = new ArrayList<String>();
        for (String column : columns) {
            if (this.jdbcDeepJobConfig.getQuoteSql()) {
                quotedColumns.add(String.format("\"%s\"", column));
                continue;
            }
            quotedColumns.add(String.format("%s", column));
        }
        sb.append(StringUtils.join(quotedColumns, (String)","));
        sb.append(" ) VALUES (");
        sb.append(StringUtils.join(params, (String)","));
        sb.append(")");
        Tuple2 result = new Tuple2(columns, (Object)sb.toString());
        return result;
    }
}

