/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SelectUtils {
    private SelectUtils() {
    }

    static boolean matchValue(FacesContext facesContext, UIComponent uIComponent, Object object, Iterator<SelectItem> iterator, Converter converter) {
        while (iterator.hasNext()) {
            Object[] objectArray;
            SelectItem selectItem = iterator.next();
            if (selectItem instanceof SelectItemGroup) {
                objectArray = ((SelectItemGroup)selectItem).getSelectItems();
                if (objectArray == null || objectArray.length <= 0 || !SelectUtils.matchValue(facesContext, uIComponent, object, new ArrayIterator(objectArray), converter)) continue;
                return true;
            }
            objectArray = null;
            try {
                objectArray = SelectUtils.doConversion(facesContext, uIComponent, selectItem, object, converter);
            }
            catch (IllegalStateException illegalStateException) {
                continue;
            }
            if (null == objectArray && null == object) {
                return true;
            }
            if (!object.equals(objectArray)) continue;
            return true;
        }
        return false;
    }

    static boolean valueIsNoSelectionOption(FacesContext facesContext, UIComponent uIComponent, Object object, Iterator<SelectItem> iterator, Converter converter) {
        boolean bl = false;
        while (iterator.hasNext()) {
            Object[] objectArray;
            SelectItem selectItem = iterator.next();
            if (selectItem instanceof SelectItemGroup) {
                objectArray = ((SelectItemGroup)selectItem).getSelectItems();
                if (objectArray == null || objectArray.length <= 0 || !SelectUtils.valueIsNoSelectionOption(facesContext, uIComponent, object, new ArrayIterator(objectArray), converter)) continue;
                bl = true;
                break;
            }
            objectArray = null;
            try {
                objectArray = SelectUtils.doConversion(facesContext, uIComponent, selectItem, object, converter);
            }
            catch (IllegalStateException illegalStateException) {
                continue;
            }
            if (null == objectArray && null == object && selectItem.isNoSelectionOption()) {
                bl = true;
                break;
            }
            if (!object.equals(objectArray) || !selectItem.isNoSelectionOption()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static Object doConversion(FacesContext facesContext, UIComponent uIComponent, SelectItem selectItem, Object object, Converter converter) throws IllegalStateException {
        Object object2;
        Object object3 = selectItem.getValue();
        if (object3 == null && object == null) {
            return null;
        }
        if (object == null ^ object3 == null) {
            throw new IllegalStateException("Either value was null, or itemValue was null, but not both.");
        }
        if (converter == null) {
            object2 = SelectUtils.coerceToModelType(facesContext, object3, object.getClass());
        } else {
            object2 = object3;
            if (object2 instanceof String && !(object instanceof String)) {
                object2 = converter.getAsObject(facesContext, uIComponent, (String)object2);
            }
        }
        return object2;
    }

    private static Object coerceToModelType(FacesContext facesContext, Object object, Class clazz) {
        Object object2;
        try {
            ExpressionFactory expressionFactory = facesContext.getApplication().getExpressionFactory();
            object2 = expressionFactory.coerceToType(object, clazz);
        }
        catch (ELException eLException) {
            object2 = object;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            object2 = object;
        }
        return object2;
    }

    static class ArrayIterator
    implements Iterator {
        private Object[] items;
        private int index = 0;

        public ArrayIterator(Object[] objectArray) {
            this.items = objectArray;
        }

        public boolean hasNext() {
            return this.index < this.items.length;
        }

        public Object next() {
            try {
                return this.items[this.index++];
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

