/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.webapp;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UpdateModelException;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExceptionHandlerFactory;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import javax.faces.event.PhaseId;
import javax.faces.event.SystemEvent;

public class PreJsf2ExceptionHandlerFactory
extends ExceptionHandlerFactory {
    public ExceptionHandler getExceptionHandler() {
        return new PreJsf2ExceptionHandler();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PreJsf2ExceptionHandler
    extends ExceptionHandler {
        private static final Logger LOGGER = Logger.getLogger("javax.faces.webapp", "javax.faces.LogStrings");
        private static final String LOG_BEFORE_KEY = "servere.webapp.prejsf2.exception.handler.log_before";
        private static final String LOG_AFTER_KEY = "servere.webapp.prejsf2.exception.handler.log_after";
        private static final String LOG_KEY = "servere.webapp.prejsf2.exception.handler.log";
        private LinkedList<ExceptionQueuedEvent> unhandledExceptions;
        private LinkedList<ExceptionQueuedEvent> handledExceptions;
        private ExceptionQueuedEvent handled;

        private PreJsf2ExceptionHandler() {
        }

        @Override
        public ExceptionQueuedEvent getHandledExceptionQueuedEvent() {
            return this.handled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle() throws FacesException {
            Iterator<ExceptionQueuedEvent> iterator = this.getUnhandledExceptionQueuedEvents().iterator();
            while (iterator.hasNext()) {
                ExceptionQueuedEvent exceptionQueuedEvent = iterator.next();
                ExceptionQueuedEventContext exceptionQueuedEventContext = (ExceptionQueuedEventContext)exceptionQueuedEvent.getSource();
                try {
                    Throwable throwable = exceptionQueuedEventContext.getException();
                    if (this.isRethrown(throwable, exceptionQueuedEventContext.inBeforePhase() || exceptionQueuedEventContext.inAfterPhase())) {
                        this.handled = exceptionQueuedEvent;
                        Throwable throwable2 = this.getRootCause(throwable);
                        if (throwable2 != null) {
                            throw new FacesException(throwable2.getMessage(), throwable2);
                        }
                        if (throwable instanceof FacesException) {
                            throw (FacesException)throwable;
                        }
                        throw new FacesException(throwable.getMessage(), throwable);
                    }
                    this.log(exceptionQueuedEventContext);
                }
                finally {
                    if (this.handledExceptions == null) {
                        this.handledExceptions = new LinkedList();
                    }
                    this.handledExceptions.add(exceptionQueuedEvent);
                    iterator.remove();
                }
            }
        }

        @Override
        public boolean isListenerForSource(Object object) {
            return object instanceof ExceptionQueuedEventContext;
        }

        @Override
        public void processEvent(SystemEvent systemEvent) throws AbortProcessingException {
            if (systemEvent != null) {
                if (this.unhandledExceptions == null) {
                    this.unhandledExceptions = new LinkedList();
                }
                this.unhandledExceptions.add((ExceptionQueuedEvent)systemEvent);
            }
        }

        @Override
        public Throwable getRootCause(Throwable throwable) {
            if (throwable == null) {
                return null;
            }
            if (this.shouldUnwrap(throwable.getClass())) {
                Throwable throwable2 = throwable.getCause();
                if (throwable2 != null) {
                    Throwable throwable3 = this.getRootCause(throwable2);
                    if (throwable3 == null) {
                        return throwable2;
                    }
                    return throwable3;
                }
                return throwable;
            }
            return throwable;
        }

        @Override
        public Iterable<ExceptionQueuedEvent> getUnhandledExceptionQueuedEvents() {
            return this.unhandledExceptions != null ? this.unhandledExceptions : Collections.emptyList();
        }

        @Override
        public Iterable<ExceptionQueuedEvent> getHandledExceptionQueuedEvents() {
            return this.handledExceptions != null ? this.handledExceptions : Collections.emptyList();
        }

        private boolean shouldUnwrap(Class<? extends Throwable> clazz) {
            return FacesException.class.equals(clazz) || ELException.class.equals(clazz);
        }

        private boolean isRethrown(Throwable throwable, boolean bl) {
            return !bl && !(throwable instanceof AbortProcessingException) && !(throwable instanceof UpdateModelException);
        }

        private void log(ExceptionQueuedEventContext exceptionQueuedEventContext) {
            Throwable throwable = exceptionQueuedEventContext.getException();
            UIComponent uIComponent = exceptionQueuedEventContext.getComponent();
            if (throwable instanceof UpdateModelException) {
                FacesContext facesContext = FacesContext.getCurrentInstance();
                FacesMessage facesMessage = ((UpdateModelException)throwable).getFacesMessage();
                LOGGER.log(Level.SEVERE, facesMessage.getSummary(), throwable.getCause());
                facesContext.addMessage(uIComponent.getClientId(facesContext), facesMessage);
            } else {
                boolean bl = exceptionQueuedEventContext.inBeforePhase();
                boolean bl2 = exceptionQueuedEventContext.inAfterPhase();
                PhaseId phaseId = exceptionQueuedEventContext.getPhaseId();
                String string = this.getLoggingKey(bl, bl2);
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, string, new Object[]{throwable.getClass().getName(), phaseId.toString(), uIComponent != null ? uIComponent.getClientId(exceptionQueuedEventContext.getContext()) : "", throwable.getMessage()});
                    LOGGER.log(Level.SEVERE, throwable.getMessage(), throwable);
                }
            }
        }

        private String getLoggingKey(boolean bl, boolean bl2) {
            if (bl) {
                return LOG_BEFORE_KEY;
            }
            if (bl2) {
                return LOG_AFTER_KEY;
            }
            return LOG_KEY;
        }
    }
}

