/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.application;

import java.io.IOException;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

public abstract class StateManager {
    public static final String STATE_SAVING_METHOD_PARAM_NAME = "javax.faces.STATE_SAVING_METHOD";
    public static final String PARTIAL_STATE_SAVING_PARAM_NAME = "javax.faces.PARTIAL_STATE_SAVING";
    public static final String FULL_STATE_SAVING_VIEW_IDS_PARAM_NAME = "javax.faces.FULL_STATE_SAVING_VIEW_IDS";
    public static final String IS_SAVING_STATE = "javax.faces.IS_SAVING_STATE";
    public static final String IS_BUILDING_INITIAL_STATE = "javax.faces.IS_BUILDING_INITIAL_STATE";
    public static final String STATE_SAVING_METHOD_CLIENT = "client";
    public static final String STATE_SAVING_METHOD_SERVER = "server";
    private static final String IS_CALLED_FROM_API_CLASS = "javax.faces.ensureOverriddenInvocation";
    private Boolean savingStateInClient = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SerializedView saveSerializedView(FacesContext context) {
        Object[] state;
        context.getAttributes().put(IS_CALLED_FROM_API_CLASS, Boolean.TRUE);
        Object stateObj = null;
        try {
            stateObj = this.saveView(context);
        }
        finally {
            context.getAttributes().remove(IS_CALLED_FROM_API_CLASS);
        }
        SerializedView result = null;
        if (null != stateObj && stateObj instanceof Object[] && (state = (Object[])stateObj).length == 2) {
            result = new SerializedView(state[0], state[1]);
        }
        return result;
    }

    @Deprecated
    public Object saveView(FacesContext context) {
        SerializedView view;
        Object[] stateArray = null;
        if (!context.getAttributes().containsKey(IS_CALLED_FROM_API_CLASS) && null != (view = this.saveSerializedView(context))) {
            stateArray = new Object[]{view.getStructure(), view.getState()};
        }
        return stateArray;
    }

    protected Object getTreeStructureToSave(FacesContext context) {
        return null;
    }

    protected Object getComponentStateToSave(FacesContext context) {
        return null;
    }

    public void writeState(FacesContext context, Object state) throws IOException {
        Object[] stateArray;
        if (null != state && state.getClass().isArray() && state.getClass().getComponentType().equals(Object.class) && 2 == (stateArray = (Object[])state).length) {
            SerializedView view = new SerializedView(stateArray[0], stateArray[1]);
            this.writeState(context, view);
        }
    }

    public void writeState(FacesContext context, SerializedView state) throws IOException {
        if (state != null) {
            this.writeState(context, new Object[]{state.getStructure(), state.getState()});
        }
    }

    @Deprecated
    public abstract UIViewRoot restoreView(FacesContext var1, String var2, String var3);

    protected UIViewRoot restoreTreeStructure(FacesContext context, String viewId, String renderKitId) {
        return null;
    }

    protected void restoreComponentState(FacesContext context, UIViewRoot viewRoot, String renderKitId) {
    }

    public boolean isSavingStateInClient(FacesContext context) {
        if (null != this.savingStateInClient) {
            return this.savingStateInClient;
        }
        this.savingStateInClient = Boolean.FALSE;
        String saveStateParam = context.getExternalContext().getInitParameter(STATE_SAVING_METHOD_PARAM_NAME);
        if (saveStateParam != null && saveStateParam.equalsIgnoreCase(STATE_SAVING_METHOD_CLIENT)) {
            this.savingStateInClient = Boolean.TRUE;
        }
        return this.savingStateInClient;
    }

    public String getViewState(FacesContext context) {
        Object state = this.saveView(context);
        if (state != null) {
            return context.getRenderKit().getResponseStateManager().getViewState(context, state);
        }
        return null;
    }

    public class SerializedView {
        private Object structure = null;
        private Object state = null;

        public SerializedView(Object newStructure, Object newState) {
            this.structure = newStructure;
            this.state = newState;
        }

        public Object getStructure() {
            return this.structure;
        }

        public Object getState() {
            return this.state;
        }
    }
}

