/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.MessageFactory;
import javax.faces.component.SelectItemsIterator;
import javax.faces.component.SelectUtils;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.ValueBinding;

public class UISelectMany
extends UIInput {
    public static final String COMPONENT_TYPE = "javax.faces.SelectMany";
    public static final String COMPONENT_FAMILY = "javax.faces.SelectMany";
    public static final String INVALID_MESSAGE_ID = "javax.faces.component.UISelectMany.INVALID";

    public UISelectMany() {
        this.setRendererType("javax.faces.Listbox");
    }

    public String getFamily() {
        return "javax.faces.SelectMany";
    }

    public Object[] getSelectedValues() {
        return (Object[])this.getValue();
    }

    public void setSelectedValues(Object[] selectedValues) {
        this.setValue(selectedValues);
    }

    public ValueBinding getValueBinding(String name) {
        if ("selectedValues".equals(name)) {
            return super.getValueBinding("value");
        }
        return super.getValueBinding(name);
    }

    public void setValueBinding(String name, ValueBinding binding) {
        if ("selectedValues".equals(name)) {
            super.setValueBinding("value", binding);
        } else {
            super.setValueBinding(name, binding);
        }
    }

    public ValueExpression getValueExpression(String name) {
        if ("selectedValues".equals(name)) {
            return super.getValueExpression("value");
        }
        return super.getValueExpression(name);
    }

    public void setValueExpression(String name, ValueExpression binding) {
        if ("selectedValues".equals(name)) {
            super.setValueExpression("value", binding);
        } else {
            super.setValueExpression(name, binding);
        }
    }

    protected boolean compareValues(Object previous, Object value) {
        if (previous == null && value != null) {
            return true;
        }
        if (previous != null && value == null) {
            return true;
        }
        if (previous == null) {
            return false;
        }
        boolean valueChanged = false;
        if (!(previous instanceof Object[])) {
            previous = UISelectMany.toObjectArray(previous);
        }
        if (!(value instanceof Object[])) {
            value = UISelectMany.toObjectArray(value);
        }
        if (!(previous instanceof Object[]) || !(value instanceof Object[])) {
            return false;
        }
        Object[] oldarray = previous;
        Object[] newarray = value;
        if (oldarray.length != newarray.length) {
            return true;
        }
        for (int i = 0; i < oldarray.length; ++i) {
            int count2;
            int count1 = UISelectMany.countElementOccurrence(oldarray[i], oldarray);
            if (count1 == (count2 = UISelectMany.countElementOccurrence(oldarray[i], newarray))) continue;
            valueChanged = true;
            break;
        }
        return valueChanged;
    }

    private static int countElementOccurrence(Object element, Object[] array) {
        int count = 0;
        for (int i = 0; i < array.length; ++i) {
            Object arrayElement = array[i];
            if (arrayElement == null || element == null || !arrayElement.equals(element)) continue;
            ++count;
        }
        return count;
    }

    private static Object[] toObjectArray(Object primitiveArray) {
        if (primitiveArray == null) {
            throw new NullPointerException();
        }
        if (primitiveArray instanceof Object[]) {
            return (Object[])primitiveArray;
        }
        if (primitiveArray instanceof List) {
            return ((List)primitiveArray).toArray();
        }
        Class<?> clazz = primitiveArray.getClass();
        if (!clazz.isArray()) {
            return null;
        }
        int length = Array.getLength(primitiveArray);
        Object[] array = new Object[length];
        for (int i = 0; i < length; ++i) {
            array[i] = Array.get(primitiveArray, i);
        }
        return array;
    }

    protected void validateValue(FacesContext context, Object value) {
        super.validateValue(context, value);
        if (!this.isValid() || value == null) {
            return;
        }
        Converter converter = this.getConverter();
        Iterator i = this.getValuesIterator(value);
        while (i.hasNext()) {
            SelectItemsIterator items = new SelectItemsIterator(context, this);
            Object currentValue = i.next();
            if (SelectUtils.matchValue(context, this, currentValue, items, converter)) continue;
            FacesMessage message = MessageFactory.getMessage(context, INVALID_MESSAGE_ID, MessageFactory.getLabel(context, this));
            context.addMessage(this.getClientId(context), message);
            this.setValid(false);
            return;
        }
    }

    private Iterator getValuesIterator(Object value) {
        if (value instanceof Collection) {
            return ((Collection)value).iterator();
        }
        return new ArrayIterator(value);
    }

    private static final class ArrayIterator
    implements Iterator {
        private int length;
        private int idx = 0;
        private Object value;

        ArrayIterator(Object value) {
            this.value = value;
            this.length = Array.getLength(value);
        }

        public boolean hasNext() {
            return this.idx < this.length;
        }

        public Object next() {
            if (this.idx >= this.length) {
                throw new NoSuchElementException();
            }
            return Array.get(this.value, this.idx++);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

