/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 *
 *
 * This file incorporates work covered by the following copyright and
 * permission notice:
 *
 *      Copyright 2006-2008 OpenAjax Alliance
 *      
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*******************************************************************************
 * OpenAjax.js
 *
 * Reference implementation of the OpenAjax Hub, as specified by OpenAjax Alliance.
 * Specification is under development at: 
 *
 *   http://www.openajax.org/member/wiki/OpenAjax_Hub_Specification
 *
 * Copyright 2006-2008 OpenAjax Alliance
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not 
 * use this file except in compliance with the License. You may obtain a copy 
 * of the License at http://www.apache.org/licenses/LICENSE-2.0 . Unless 
 * required by applicable law or agreed to in writing, software distributed 
 * under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR 
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the 
 * specific language governing permissions and limitations under the License.
 *
 ******************************************************************************/

// prevent re-definition of the OpenAjax object
if (!window["OpenAjax"]) {
    OpenAjax = new function() {
        var t = true;
        var f = false;
        var g = window;
        var libs;
        var ooh = "org.openajax.hub.";

        var h = {};
        this.hub = h;
        h.implementer = "http://openajax.org";
        h.implVersion = "1.0";
        h.specVersion = "1.0";
        h.implExtraData = {};
        libs = {};
        h.libraries = libs;

        h.registerLibrary = function(prefix, nsURL, version, extra) {
            libs[prefix] = {
                prefix: prefix,
                namespaceURI: nsURL,
                version: version,
                extraData: extra
            };
            this.publish(ooh + "registerLibrary", libs[prefix]);
        }
        h.unregisterLibrary = function(prefix) {
            this.publish(ooh + "unregisterLibrary", libs[prefix]);
            delete libs[prefix];
        }

        h._subscriptions = { c:{}, s:[] };
        h._cleanup = [];
        h._subIndex = 0;
        h._pubDepth = 0;

        h.subscribe = function(name, callback, scope, subscriberData, filter)
        {
            if (!scope) {
                scope = window;
            }
            var handle = name + "." + this._subIndex;
            var sub = { scope: scope, cb: callback, fcb: filter, data: subscriberData, sid: this._subIndex++, hdl: handle };
            var path = name.split(".");
            this._subscribe(this._subscriptions, path, 0, sub);
            return handle;
        }

        h.publish = function(name, message)
        {
            var path = name.split(".");
            this._pubDepth++;
            this._publish(this._subscriptions, path, 0, name, message);
            this._pubDepth--;
            if ((this._cleanup.length > 0) && (this._pubDepth == 0)) {
                for (var i = 0; i < this._cleanup.length; i++)
                    this.unsubscribe(this._cleanup[i].hdl);
                delete(this._cleanup);
                this._cleanup = [];
            }
        }

        h.unsubscribe = function(sub)
        {
            var path = sub.split(".");
            var sid = path.pop();
            this._unsubscribe(this._subscriptions, path, 0, sid);
        }

        h._subscribe = function(tree, path, index, sub)
        {
            var token = path[index];
            if (index == path.length)
                tree.s.push(sub);
            else {
                if (typeof tree.c == "undefined")
                    tree.c = {};
                if (typeof tree.c[token] == "undefined") {
                    tree.c[token] = { c: {}, s: [] };
                    this._subscribe(tree.c[token], path, index + 1, sub);
                }
                else
                    this._subscribe(tree.c[token], path, index + 1, sub);
            }
        }

        h._publish = function(tree, path, index, name, msg) {
            if (typeof tree != "undefined") {
                var node;
                if (index == path.length) {
                    node = tree;
                } else {
                    this._publish(tree.c[path[index]], path, index + 1, name, msg);
                    this._publish(tree.c["*"], path, index + 1, name, msg);
                    node = tree.c["**"];
                }
                if (typeof node != "undefined") {
                    var callbacks = node.s;
                    var max = callbacks.length;
                    for (var i = 0; i < max; i++) {
                        if (callbacks[i].cb) {
                            var sc = callbacks[i].scope;
                            var cb = callbacks[i].cb;
                            var fcb = callbacks[i].fcb;
                            var d = callbacks[i].data;
                            if (typeof cb == "string") {
                                // get a function object
                                cb = sc[cb];
                            }
                            if (typeof fcb == "string") {
                                // get a function object
                                fcb = sc[fcb];
                            }
                            if ((!fcb) ||
                                (fcb.call(sc, name, msg, d))) {
                                cb.call(sc, name, msg, d);
                            }
                        }
                    }
                }
            }
        }

        h._unsubscribe = function(tree, path, index, sid) {
            if (typeof tree != "undefined") {
                if (index < path.length) {
                    var childNode = tree.c[path[index]];
                    this._unsubscribe(childNode, path, index + 1, sid);
                    if (childNode.s.length == 0) {
                        for (var x in childNode.c)
                            return;
                        delete tree.c[path[index]];
                    }
                    return;
                }
                else {
                    var callbacks = tree.s;
                    var max = callbacks.length;
                    for (var i = 0; i < max; i++)
                        if (sid == callbacks[i].sid) {
                            if (this._pubDepth > 0) {
                                callbacks[i].cb = null;
                                this._cleanup.push(callbacks[i]);
                            }
                            else
                                callbacks.splice(i, 1);
                            return;
                        }
                }
            }
        }

    };
    
    // Register the OpenAjax Hub itself as a library.
    OpenAjax.hub.registerLibrary("OpenAjax", "http://openajax.org/hub", "1.0", {});

}
/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 *
 *
 * This file incorporates work covered by the following copyright and
 * permission notice:
 *
 * Copyright 2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
  @project JSF Ajax Library 
  @version 2.0 
  @description  
*/

/**
 * Register with OpenAjax
 */
if (typeof OpenAjax != "undefined" &&
    typeof OpenAjax.hub.registerLibrary != "undefined") {
    OpenAjax.hub.registerLibrary("javax", "www.sun.com", "1.0", null);
}

/**
 * Create our top level namespace - javax.faces.Ajax
 */
if (javax == null || typeof javax == "undefined") {
    var javax = new Object();
}
if (javax.faces == null || typeof javax.faces == "undefined") {
    javax["faces"] = new Object();
}
if (javax.faces.Ajax == null || typeof javax.faces.Ajax == "undefined") {
    javax.faces["Ajax"] = new Object();
}

/**
 * @name javax
 * @namespace
 */

/**
 * @name javax.faces
 * @namespace
 */

/**
 * @name javax.faces.Ajax
 * @namespace
 */

/**
 * <p>Collect and encode state for input controls associated 
 * with the specified <code>form</code> element.</p> 
 *
 * @param form The <code>form</code> element whose contained
 * <code>input</code> controls will be collected and encoded.
 * Only successful controls will be collected and encoded in 
 * accordance with: <a href="http://www.w3.org/TR/html401/interact/forms.html#h-17.13.2">
 * Section 17.13.2 of the HTML Specification</a>.
 *
 * @returns The encoded state for the specified form's input controls.
 * @function javax.faces.Ajax.viewState
 */
javax.faces.Ajax.viewState = function(form) {

    var viewState = javax.faces.Ajax.AjaxEngine.serializeForm(form);
    return viewState;

}

/**
 * <p>Send an asynchronous Ajax request to the server.  
 * This function must:
 * <ul>
 * <li>Capture the element that triggered this Ajax request
 * (from the <code>element</code> argument, also known as the
 * <code>source</code> element.</li>
 * <li>Determine the <code>source</code> element's <code>form</code>
 * element.</li>
 * <li>Get the <code>form</code> view state by calling 
 * {@link javax.faces.Ajax.viewState} passing the 
 * <code>form</code> element as the argument.</li> 
 * <li>Collect post data arguments for the Ajax request.  
 * <ul>
 * <li>The following name/value pairs are required post data arguments:
 * <ul>
 * <li>The name and value of the <code>source</code> element that 
 * triggered this request;</li>
 * <li><code>javax.faces.partial.ajax</code> with the value 
 * <code>true</code></li>
 * </ul>
 * </li>
 * </ul>
 * </li>
 * <li>Collect optional post data arguments for the Ajax request.
 * <ul>
 * <li>Determine additional arguments (if any) from the <code>options</code>
 * argument. If <code>options.execute</code> exists, create the post data argument
 * with the name <code>javax.faces.partial.execute</code> and the value as a 
 * comma delimited <code>string</code> of client identifiers.  If 
 * <code>options.render</code> exists, create the post data argument with the name
 * <code>javax.faces.partial.render</code> and the value as a comma delimited 
 * <code>string</code> of client identifiers.</li>  
 * <li>Determine additional arguments (if any) from the <code>event</code>
 * argument.  The following name/value pairs may be used from the 
 * <code>event</code> object:
 * <ul>
 * <li><code>target</code> - the ID of the element that triggered the event.</li>
 * <li><code>captured</code> - the ID of the element that captured the event.</li>
 * <li><code>type</code> - the type of event (ex: onkeypress)</li>
 * <li><code>alt</code> - <code>true</code> if ALT key was pressed.</li>
 * <li><code>ctrl</code> - <code>true</code> if CTRL key was pressed.</li>
 * <li><code>shift</code> - <code>true</code> if SHIFT key was pressed. </li>
 * <li><code>meta</code> - <code>true</code> if META key was pressed. </li>
 * <li><code>right</code> - <code>true</code> if right mouse button  
 * was pressed. </li>
 * <li><code>left</code> - <code>true</code> if left mouse button  
 * was pressed. </li>
 * <li><code>keycode</code> - the key code. 
 * </ul>
 * </li>
 * </ul>
 * </li>
 * <li>Encode the set of post data arguments.</li>
 * <li>Join the encoded view state with the encoded set of post data arguments
 * to form the <code>query string</code> that will be sent to the server.</li>
 * <li>Send the request as an <code>asynchronous POST</code> using the 
 * <code>action</code> property of the <code>form</code> element as the 
 * <code>url</code>.</li>
 * </ul>  
 * Before the request is sent it must be put into a queue to ensure requests 
 * are sent in the same order as when they were initiated.  The request callback function
 * must examine the queue and determine the next request to be sent.  The behavior of the 
 * request callback function must be as follows:
 * <ul>
 * <li>If the request completed successfully invoke {@link javax.faces.Ajax.ajaxResponse} 
 * passing the <code>request</code> object.</li> 
 * <li>If the request did not complete successfully, notify the client.</li>
 * <li>Regardless of the outcome of the request (success or error) every request in the 
 * queue must be handled.  Examine the status of each request in the queue starting from 
 * the request that has been in the queue the longest.  If the status of the request is 
 * <code>complete</code> (readyState 4), dequeue the request (remove it from the queue).  
 * If the request has not been sent (readyState 0), send the request.  Requests that are 
 * taken off the queue and sent should not be put back on the queue.</li>
 * </ul>
 *
 * </p>
 *
 * @param element The DOM element that triggered this Ajax request.
 * @param event The DOM event that triggered this Ajax request.  The
 * <code>event</code> argument is optional.
 * @param options The set of available options that can be sent as
 * request parameters to control client and/or server side 
 * request processing. Acceptable name/value pair options are:
 * <table border="1">
 * <tr>
 * <th>name</th>
 * <th>value</th>
 * </tr>
 * <tr>
 * <td><code>execute</code></td>
 * <td><code>comma seperated list of client identifiers</code></td>
 * </tr>
 * <tr>
 * <td><code>render</code></td>
 * <td><code>comma seperated list of client identifiers</code></td>
 * </tr>
 * </table>
 * The <code>options</code> argument is optional. 
 *
 * @function javax.faces.Ajax.ajaxRequest
 * @throws ArgNotSet Error if first required argument <code>element</code> is not specified
 */
javax.faces.Ajax.ajaxRequest = function(element, event, options) {

    if (typeof element == 'undefined' || element == null) {
        throw {
                    name: 'ArgNotSet',
                    message: "ajaxRequest:Required first argument has not been set"
                }
    }

    // Capture the element that triggered this Ajax request.
    var source = element;

    var utils = new javax.faces.Ajax.Utils();
    var form = utils.getForm(source); 
    var viewState = javax.faces.Ajax.viewState(form);

    // Set up additional arguments to be used in the request..
    var args = new Object();
    if (typeof(options) != 'undefined' && options != null) {
        if (options.execute) {
            args["javax.faces.partial.execute"] = utils.toArray(options.execute,',').join(','); 
            options.execute = null;
            delete options.execute;
        }
        if (options.render) {
            args["javax.faces.partial.render"] = utils.toArray(options.render,',').join(','); 
            options.render = null;
            delete options.render;
        }
        utils.extend(args, options);
    }

    args["javax.faces.partial.ajax"] = "true";
    args["method"] = "POST";
    args["url"] = form.action;
    // add source
    var action = utils.$(source);
    if (action && action.form) {
        args[action.name] = action.value || 'x';
    } else {
        args[source] = source;
    }

    var ajaxEngine = new javax.faces.Ajax.AjaxEngine();
    ajaxEngine.setupArguments(args);
    ajaxEngine.queryString = viewState;
    ajaxEngine.sendRequest();
} 

/**
 * <p>Receive an Ajax response from the server.  
 * This function must evaluate the markup returned in the 
 * <code>responseXML</code> object and update the <code>DOM</code>
 * as follows:
 * <ul>
 * <li>Determine if the entire <code>DOM</code> should be replaced, or
 * if only specified sections (known as partial rendering) should be
 * updated.  The entire <code>DOM</code> must be replaced if a 
 * <code>render</code> element identifier is 
 * <code>javax.faces.viewRoot</code>.</li> 
 * <li>If partial <code>DOM</code> update is required, replace the 
 * <code>DOM</code> markup whose identifier matches the corresponding
 * <code>render</code> identifier.</li>
 * <li>Capture the view state sent in the response and insert it into
 * the <code>DOM</code> as a <code>hidden input</code> field with the
 * identifier <code>javax.faces.viewState</code>.  Look for all the
 * <code>form</code> elements in the <code>DOM</code>, and for each
 * <code>form</code> element, determine if a <code>javax.faces.viewState</code>
 * field exists.  If it does, replace it with the view state from the 
 * response.  If it does not exist, create a <code>hidden input</code>
 * field with the identifier <code>javax.faces.viewState</code> and 
 * insert it as a child element of the <code>form</code> elements.</li> 
 * </ul>
 * </p>
 *
 * @param request The <code>XMLHttpRequest</code> instance that 
 * contains the status code and response message from the server.
 *
 * @throws EmptyResponse error if request contains no data
 *
 * @function javax.faces.Ajax.ajaxResponse
 */ 
javax.faces.Ajax.ajaxResponse = function(request) {

    //  RELEASE_PENDING: We need to add more robust error handing - this error should probably be caught upstream
    if (request == null || typeof request == 'undefined' ) {
        throw new Error("javax.faces.Ajax.ajaxResponse: Request is null");
    }


    var utils = new javax.faces.Ajax.Utils();
    var xmlReq = request;

    var xml = xmlReq.responseXML;
    //  RELEASE_PENDING: We need to add more robust error handing - this error should probably be caught upstream
    if (xml === null) {
        throw new Error("javax.faces.Ajax.ajaxResponse: Reponse contains no data");
    }

    var id, content, markup, str;

    var components = xml.getElementsByTagName('components')[0];
    var render = components.getElementsByTagName('render');

    for (var i = 0; i < render.length; i++) {
        id = render[i].getAttribute('id');
        // join the CDATA sections in the markup
        markup = '';
        for (var j = 0; j < render[i].firstChild.childNodes.length; j++) {
            content = render[i].firstChild.childNodes[j];
            markup += content.text || content.data;
        }
        str = utils.stripScripts(markup);
        var src = str;
         
        // If our special render all markup is present..
        if (-1 != id.indexOf("javax.faces.ViewRoot")) {
            // if src contains <html>, trim the <html> and </html>, if present.
            //   if src contains <head>
            //      extract the contents of <head> and replace current document's
            //      <head> with the contents.
            //   if src contains <body>
            //      extract the contents of <body> and replace the current
            //      document's <body> with the contents.
            //   if src does not contain <body>
            //      replace the current document's <body> with the contents.
            var
                htmlStartEx = new RegExp("< *html.*>", "gi"),
                htmlEndEx = new RegExp("< */ *html.*>", "gi"),
                headStartEx = new RegExp("< *head.*>", "gi"),
                headEndEx = new RegExp("< */ *head.*>", "gi"),
                bodyStartEx = new RegExp("< *body.*>", "gi"),
                bodyEndEx = new RegExp("< */ *body.*>", "gi"),
                htmlStart, htmlEnd, headStart, headEnd, bodyStart, bodyEnd;
            var srcHead = null, srcBody = null;
            // find the current document's "body" element
            var docBody = document.getElementsByTagName("body")[0];
            // if src contains <html>
            if (null != (htmlStart = htmlStartEx.exec(src))) {
                // if src contains </html>
                if (null != (htmlEnd = htmlEndEx.exec(src))) {
                    src = src.substring(htmlStartEx.lastIndex, htmlEnd.index);
                } else {
                    src = src.substring(htmlStartEx.lastIndex);
                }
            }
            // if src contains <head>
            if (null != (headStart = headStartEx.exec(src))) {
                // if src contains </head>
                if (null != (headEnd = headEndEx.exec(src))) {
                    srcHead = src.substring(headStartEx.lastIndex,
                        headEnd.index);
                } else {
                    srcHead = src.substring(headStartEx.lastIndex);
                }
                // find the "head" element
                var docHead = document.getElementsByTagName("head")[0];
                if (docHead) {
                    utils.elementReplace(docHead, "head", srcHead);
                }
            }       
            // if src contains <body>
            if (null != (bodyStart = bodyStartEx.exec(src))) {
                // if src contains </body>
                if (null != (bodyEnd = bodyEndEx.exec(src))) {
                    srcBody = src.substring(bodyStartEx.lastIndex,
                        bodyEnd.index);
                } else {
                    srcBody = src.substring(bodyStartEx.lastIndex);
                }
                utils.elementReplace(docBody, "body", srcBody);
            }
            if (!srcBody) {
                utils.elementReplace(docBody, "body", src);
            }
        
        } else {
            var d = utils.$(id);
            if (!d) {
                throw {
                    name: 'NotFound',
                    message: id + 'not found'
                }
            }
            var parent = d.parentNode;
            var temp = document.createElement('div');
            temp.id = d.id;
            temp.innerHTML = utils.trim(str);

            parent.replaceChild(temp.firstChild,d);
        }
    }

    // Now set the view state from the server into the DOM
    // If there are multiple forms, make sure they all have a 
    // viewState hidden field.

    var state = state || xml.getElementsByTagName('state')[0].firstChild;
    if (state) {
        var stateElem = utils.$("javax.faces.ViewState");
        if (stateElem) {
            stateElem.value = state.text || state.data;
        }
        var numForms = document.forms.length;
        var field;
        for (var k = 0; k < numForms; k++) {
            field = document.forms[k].elements["javax.faces.ViewState"];
            if (typeof field == 'undefined') {
                field = document.createElement("input");
                field.type = "hidden";
                field.name = "javax.faces.ViewState";
                document.forms[k].appendChild(field);
            }
            field.value = state.text || state.data;
        }
    }
}

/**
 *
 * <p>Return the value of <code>Application.getProjectStage()</code> for
 * the currently running application instance.  Calling this method must
 * not cause any network transaction to happen to the server.</p>
 * 
 * @returns The <code>String</code> representing the current state of the 
 * running application in a typical product development lifecycle.  Refer
 * to <code>javax.faces.application.Application.getProjectStage</code> and
 * <code>javax.faces.application.ProjectStage</code>.
 * @function javax.faces.Ajax.getProjectStage
 */ 

javax.faces.Ajax.getProjectStage = function() {

    var result = "#{facesContext.application.projectStage}";

    return result;

}

/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 *
 *
 * This file incorporates work covered by the following copyright and
 * permission notice:
 *
 * Copyright 2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * AjaxEngine contains the JavaScript for performing Ajax functions. 
 */
javax.faces.Ajax.AjaxEngine = function() {

    var req = new Object();        // Request Object
    req.url = null;                // Request URL
    req.xmlReq = null;             // XMLHttpRequest Object
    req.async = true;              // Default - Asynchronous
    req.parameters = new Object(); // Parameters For GET or POST
    req.queryString = null;        // Encoded Data For GET or POST
    req.method = null;             // GET or POST
    req.onComplete = null;         // Request/Response Complete Callback Handle
    req.onSuccess = null;          // Request/Response Success Callback Handle
    req.onError = null;            // Request/Response Error Callback Handle
    req.responseTxt = null;        // Response Content (Text)
    req.responseXML = null;        // Response Content (XML) 
    req.status = null;             // Response Status Code From Server
    req.fromQueue = false;         // Indicates if the request was taken off the queue
                                   // before being sent.  This prevents the request from
                                   // entering the queue redundantly. 

    req.que = javax.faces.Ajax.AjaxEngine.Queue;

    // Get an XMLHttpRequest Handle
    req.xmlReq = javax.faces.Ajax.AjaxEngine.getTransport();
    if (req.xmlReq == null) { return null; }

    // Set up request/response state callbacks
    req.xmlReq.onreadystatechange = function() {
        if (req==null || req.xmlReq==null) { return; }
        if (req.xmlReq.readyState==1) { req.onOpenCB(req); }      // open has been called
        if (req.xmlReq.readyState==2) { req.onSendCB(req); }      // send has been called
        if (req.xmlReq.readyState==3) { req.onReceivingCB(req); } // data in process of being received from the server
        if (req.xmlReq.readyState==4) { req.onCompleteCB(req); }  // response from server has arrived
    };

    // State Callback Functions

    req.onOpenCB = function() {
    };

    req.onSendCB = function() {
    };

    req.onReceivingCB = function() {
    };

    /**
     * This function is called when the request/response interaction
     * is complete.  'onComplete', 'onSuccess' or 'onError' callbacks 
     * will be called if they have been registered,
     * If the return status code is successfull, dequeue all requests
     * from the queue that have completed.  If a request has been found 
     * on the queue that has not been sent, send the request.
     */
    req.onCompleteCB = function() {
        if (typeof(req.onComplete)=="function") {
            req.onComplete(req);
            return;
        }
        if ((req.xmlReq.status == null || typeof req.xmlReq.status == 'undefined')
            || req.xmlReq.status == 0 ||
            (req.xmlReq.status >= 200 && req.xmlReq.status < 300)) { 
            javax.faces.Ajax.ajaxResponse(req.xmlReq);
        } else {
            if (typeof(req.onError)=="function") {
                req.onError(req);
                return;
            } else {
                throw new Error("AjaxEngine:  reponse was an error code, onError not set");
            }

        }

        // Regardless of whether the request completed successfully (or not),
        // dequeue requests that have been completed (readyState 4) and send
        // requests that ready to be sent (readyState 0).

        var nextReq = req.que.getOldestElement();
        if (nextReq == null || typeof nextReq == 'undefined') { 
            return;
        }
        while ((typeof nextReq.xmlReq != 'undefined' && nextReq.xmlReq != null) && 
            nextReq.xmlReq.readyState == 4) {
            req.que.dequeue();
            nextReq = req.que.getOldestElement();
            if (nextReq == null || typeof nextReq == 'undefined') {
                break;
            }
        }
        if (nextReq == null || typeof nextReq == 'undefined') { 
            return;
        }
        if ((typeof nextReq.xmlReq != 'undefined' && nextReq.xmlReq != null) && 
            nextReq.xmlReq.readyState == 0) {
            nextReq.fromQueue = true;
            nextReq.sendRequest();
        }
    };

    /**
     * Utility method that accepts additional arguments for the AjaxEngine.
     * If an argument is passed in that matches an AjaxEngine property, the 
     * argument value becomes the value of the AjaxEngine property.  
     * Arguments that don't match AjaxEngine properties are added as 
     * request parameters.
     */
    req.setupArguments = function(args) {
        for (var i in args) {
            if (typeof(req[i]) == 'undefined') {
                req.parameters[i] = args[i];
            } else {
                req[i] = args[i];
            }
        }
    };

    /**
     * This function does final encoding of parameters, determines the request method
     * (GET or POST) and sends the request using the specified url.
     */ 
    req.sendRequest = function() {
        if (req.xmlReq != null) {
            // if there is already a request on the queue waiting to be processed..
            // just queue this request
            if (!req.que.isEmpty()) {
                if (!req.fromQueue) {
                    req.que.enqueue(req);
                    return;
                }
            }
            // If the queue is empty, queue up this request and send
            if (!req.fromQueue) {
                req.que.enqueue(req);
            } 
            // Some logic to get the real request URL
            if (req.generateUniqueUrl && req.method=="GET") {
                req.parameters["AjaxRequestUniqueId"] = new Date().getTime() + "" + req.requestIndex;
            }
            var content = null; // For POST requests, to hold query string
            for (var i in req.parameters) {
                if (req.queryString.length>0) { req.queryString += "&"; }
                    req.queryString += encodeURIComponent(i) + "=" + encodeURIComponent(req.parameters[i]);
            }
            if (req.method=="GET") {
                if (req.queryString.length>0) {
                    req.url += ((req.url.indexOf("?")>-1)?"&":"?") + req.queryString;
                }
            }
            req.xmlReq.open(req.method,req.url,req.async);
            if (req.method=="POST") {
                if (typeof(req.xmlReq.setRequestHeader) != 'undefined') {
                    req.xmlReq.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
                }
                content = req.queryString;
            }
            req.xmlReq.send(content);
        }
    };

    return req;
};

/**
 * Utility function to serialize form elements.
 */
javax.faces.Ajax.AjaxEngine.serializeForm = function(theform) {
    var els = theform.elements;
    var len = els.length;
    var qString = "";
    this.addField = function(name,value) {
        if (qString.length>0) {
            qString += "&";
        }
        qString += encodeURIComponent(name) + "=" + encodeURIComponent(value);
    };
    for (var i=0; i<len; i++) {
        var el = els[i];
        if (!el.disabled) {
            switch(el.type) {
                case 'text': case 'password': case 'hidden': case 'textarea':
                    this.addField(el.name,el.value);
                    break;
                case 'select-one':
                    if (el.selectedIndex>=0) {
                        this.addField(el.name,el.options[el.selectedIndex].value);
                    }
                    break;
                case 'select-multiple':
                    for (var j=0; j<el.options.length; j++) {
                        if (el.options[j].selected) {
                            this.addField(el.name,el.options[j].value);
                        }
                    }
                    break;
                case 'checkbox': case 'radio':
                    if (el.checked) {
                        this.addField(el.name,el.value);
                    }
                    break;
            }
        }
    }
    return qString;
};

/**
 * Utility function to get an XMLHttpRequest handle.
 */
javax.faces.Ajax.AjaxEngine.getTransport = function() {
    var methods = [
      function() { return new XMLHttpRequest(); },
      function() { return new ActiveXObject('Msxml2.XMLHTTP'); },
      function() { return new ActiveXObject('Microsoft.XMLHTTP'); }
    ];

    var returnVal;
    for(var i = 0, len = methods.length; i < len; i++) {
      try {
        returnVal = methods[i]();
      } catch(e) {
        continue;
      }
      return returnVal;
    }
    throw new Error('Could not create an XHR object.');
}


/**
 * Simple queue implementaton.
 */

 // RELEASE_PENDING: Need to change the format of the data payload to be flat
 //   since the OpenAjax spec would prefer that we don't pass values by reference.
if (!window["javax.faces.Ajax.AjaxEngine.Queue"]) {
  javax.faces.Ajax.AjaxEngine.Queue = new function() {

    // Create the internal queue
    var queue = [];


    // the amount of space at the front of the queue, initialised to zero
    var queueSpace = 0;

    /* Returns the size of this Queue. The size of a Queue is equal to the number
     * of elements that have been enqueued minus the number of elements that have
     * been dequeued.
     */
    this.getSize = function(){
        return queue.length - queueSpace;
    }

    /* Returns true if this Queue is empty, and false otherwise. A Queue is empty
     * if the number of elements that have been enqueued equals the number of
     * elements that have been dequeued.
     */
    this.isEmpty = function(){
        return (queue.length == 0);
    }

    /* Enqueues the specified element in this Queue.
     * After the element is put in the queue, an event is fired.
     *
     * @param element - the element to enqueue
     */
    this.enqueue = function(element){
        queue.push(element);
        var args = new Object();
        args["enqueue"] = element;
        OpenAjax.hub.publish("javax.faces.AjaxEngine.Queue",args);
    }

    /* Dequeues an element from this Queue. The oldest element in this Queue is
     * removed and returned. If this Queue is empty then undefined is returned.
     *
     * @returns The element that was removed rom the queue.
     */
    this.dequeue = function(){
        // initialise the element to return to be undefined
        var element = undefined;

        // check whether the queue is empty
        if (queue.length){
            // fetch the oldest element in the queue
            element = queue[queueSpace];

            // update the amount of space and check whether a shift should occur
            if (++queueSpace * 2 >= queue.length){
                // set the queue equal to the non-empty portion of the queue
                queue = queue.slice(queueSpace);
                // reset the amount of space at the front of the queue
                queueSpace=0;
            }
        }
        if (element != "undefined") {
            var args = new Object();
            args["dequeue"] = element;
            OpenAjax.hub.publish("javax.faces.AjaxEngine.Queue",args);
        }

        // return the removed element
        return element;
    }

    /* Returns the oldest element in this Queue. If this Queue is empty then
     * undefined is returned. This function returns the same value as the dequeue
     * function, but does not remove the returned element from this Queue.
     */
    this.getOldestElement = function() {
        // initialise the element to return to be undefined
        var element = undefined;

        // if the queue is not element then fetch the oldest element in the queue
        if (queue.length) element = queue[queueSpace];
        // return the oldest element
        return element;
    }
  }
}

/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 *
 *
 * This file incorporates work covered by the following copyright and
 * permission notice:
 *
 * Copyright 2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Utility functions
 */
javax.faces.Ajax.Utils = function() {

    this.createClass = function() {
        return function() {
            this.initialize.apply(this, arguments);
        }
    }

    this.extend = function(destination, source) {
        for (var property in source) {
            destination[property] = source[property];
        }
        return destination;
    }

    this.getForm = function(element) {
        if (element) {
            var form = this.$(element);
            while (form && form.tagName && form.tagName.toLowerCase() != 'form') {
                if (form.form) return form.form;
                if (form.parentNode) {
                        form = form.parentNode;
                } else {
                    form = null;
                }
                if (form) return form;
            }
            return document.forms[0];
        }
        return null;
    }

    this.$ = function() {
        var results = [], element;
        for (var i = 0; i < arguments.length; i++) {
            element = arguments[i];
            if (typeof element == 'string')
                element = document.getElementById(element);
            results.push(element);
        }
        return this.reduce(results);
    }

    this.reduce = function(toReduce) {
        return toReduce.length > 1 ? toReduce : toReduce[0];
    }

    this.toArray = function(s,e) {
        var sarray;
        if (typeof s == 'string') {
            sarray = s.split((e)?e:' ');
            for (var i=0; i<sarray.length; i++) {
                sarray[i] = this.trim(sarray[i]);
            }
        }
        return sarray;
    }

    this.trim = function(toTrim) {
        var result = null;
        if (null != toTrim) {
            var s = toTrim.replace( /^\s+/g, "" );
            result = s.replace( /\s+$/g, "" );
        }
        return result;
    }

    this.scriptFrag = '(?:<script.*?>)((\n|\r|.)*?)(?:<\/script>)';

    this.stripScripts = function(src) {
        return src.replace(new RegExp(this.scriptFrag, 'img'), '');
    }

    this.evalScripts = function(src) {
        return this.extractScripts(src).map(function(script) { return eval(script) });
    }

    this.extractScripts = function(src) {
        var matchAll = new RegExp(this.scriptFrag, 'img');
        var matchOne = new RegExp(this.scriptFrag, 'im');
        return (src.match(matchAll) || []).map(function(scriptTag) {
            return (scriptTag.match(matchOne) || ['', ''])[1];
        });
    }

this.elementReplace = function(d, tempTagName, src) {
        var parent = d.parentNode;
        var temp = document.createElement(tempTagName);
        var result = null;
        temp.id = d.id;
    
        // If we are creating a head element...
        if (-1 != d.tagName.toLowerCase().indexOf("head") && d.tagName.length == 4) {
    
            // head replacement only appears to work on firefox.
            if (-1 == BrowserDetect.browser.indexOf("Firefox")) {
                return result;
            }   
        
            // Strip link elements from src.
            if (-1 != src.indexOf("link")) {
                var 
                    linkStartEx = new RegExp("< *link.*>", "gi");
                var linkStart;
                while (null != (linkStart = linkStartEx.exec(src))) {
                    src = src.substring(0, linkStart.index) +
                        src.substring(linkStartEx.lastIndex);
                    linkStartEx.lastIndex = 0;
                }
            }

            // Strip style elements from src
            if (-1 != src.indexOf("style")) {
                var
                    styleStartEx = new RegExp("< *style.*>", "gi"),
                    styleEndEx = new RegExp("< */ *style.*>", "gi");
                var styleStart, styleEnd;
                while (null != (styleStart = styleStartEx.exec(src))) {
                    styleEnd = styleEndEx.exec(src);
                    src = src.substring(0, styleStart.index) +
                        src.substring(styleStartEx.lastIndex);
                    styleStartEx.lastIndex = 0;
                }
            }

            temp.innerHTML = src;

            // clone all the link elements...
            var i, links, styles;
            links = d.getElementsByTagName("link");
            if (links) {
                for (i = 0; i < links.length; i++) {
                    temp.appendChild(links[i].cloneNode(true));
                }
            }
            // then clone all the style elements.
            styles = d.getElementsByTagName("style");
            if (styles) {
                for (i = 0; i < styles.length; i++) {
                    temp.appendChild(styles[i].cloneNode(true));
                }
            }
        } else {
            temp.innerHTML = src;
        }


        result = temp
        parent.replaceChild(temp, d);
        return result;
    }
}
/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 *
 *
 * This file incorporates work covered by the following copyright and
 * permission notice:
 *
 *      Copyright 2006-2008 OpenAjax Alliance
 *      
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*******************************************************************************
 * OpenAjax.js
 *
 * Reference implementation of the OpenAjax Hub, as specified by OpenAjax Alliance.
 * Specification is under development at: 
 *
 *   http://www.openajax.org/member/wiki/OpenAjax_Hub_Specification
 *
 * Copyright 2006-2008 OpenAjax Alliance
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not 
 * use this file except in compliance with the License. You may obtain a copy 
 * of the License at http://www.apache.org/licenses/LICENSE-2.0 . Unless 
 * required by applicable law or agreed to in writing, software distributed 
 * under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR 
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the 
 * specific language governing permissions and limitations under the License.
 *
 ******************************************************************************/

// prevent re-definition of the OpenAjax object
if (!window["OpenAjax"]) {
    OpenAjax = new function() {
        var t = true;
        var f = false;
        var g = window;
        var libs;
        var ooh = "org.openajax.hub.";

        var h = {};
        this.hub = h;
        h.implementer = "http://openajax.org";
        h.implVersion = "1.0";
        h.specVersion = "1.0";
        h.implExtraData = {};
        libs = {};
        h.libraries = libs;

        h.registerLibrary = function(prefix, nsURL, version, extra) {
            libs[prefix] = {
                prefix: prefix,
                namespaceURI: nsURL,
                version: version,
                extraData: extra
            };
            this.publish(ooh + "registerLibrary", libs[prefix]);
        }
        h.unregisterLibrary = function(prefix) {
            this.publish(ooh + "unregisterLibrary", libs[prefix]);
            delete libs[prefix];
        }

        h._subscriptions = { c:{}, s:[] };
        h._cleanup = [];
        h._subIndex = 0;
        h._pubDepth = 0;

        h.subscribe = function(name, callback, scope, subscriberData, filter)
        {
            if (!scope) {
                scope = window;
            }
            var handle = name + "." + this._subIndex;
            var sub = { scope: scope, cb: callback, fcb: filter, data: subscriberData, sid: this._subIndex++, hdl: handle };
            var path = name.split(".");
            this._subscribe(this._subscriptions, path, 0, sub);
            return handle;
        }

        h.publish = function(name, message)
        {
            var path = name.split(".");
            this._pubDepth++;
            this._publish(this._subscriptions, path, 0, name, message);
            this._pubDepth--;
            if ((this._cleanup.length > 0) && (this._pubDepth == 0)) {
                for (var i = 0; i < this._cleanup.length; i++)
                    this.unsubscribe(this._cleanup[i].hdl);
                delete(this._cleanup);
                this._cleanup = [];
            }
        }

        h.unsubscribe = function(sub)
        {
            var path = sub.split(".");
            var sid = path.pop();
            this._unsubscribe(this._subscriptions, path, 0, sid);
        }

        h._subscribe = function(tree, path, index, sub)
        {
            var token = path[index];
            if (index == path.length)
                tree.s.push(sub);
            else {
                if (typeof tree.c == "undefined")
                    tree.c = {};
                if (typeof tree.c[token] == "undefined") {
                    tree.c[token] = { c: {}, s: [] };
                    this._subscribe(tree.c[token], path, index + 1, sub);
                }
                else
                    this._subscribe(tree.c[token], path, index + 1, sub);
            }
        }

        h._publish = function(tree, path, index, name, msg) {
            if (typeof tree != "undefined") {
                var node;
                if (index == path.length) {
                    node = tree;
                } else {
                    this._publish(tree.c[path[index]], path, index + 1, name, msg);
                    this._publish(tree.c["*"], path, index + 1, name, msg);
                    node = tree.c["**"];
                }
                if (typeof node != "undefined") {
                    var callbacks = node.s;
                    var max = callbacks.length;
                    for (var i = 0; i < max; i++) {
                        if (callbacks[i].cb) {
                            var sc = callbacks[i].scope;
                            var cb = callbacks[i].cb;
                            var fcb = callbacks[i].fcb;
                            var d = callbacks[i].data;
                            if (typeof cb == "string") {
                                // get a function object
                                cb = sc[cb];
                            }
                            if (typeof fcb == "string") {
                                // get a function object
                                fcb = sc[fcb];
                            }
                            if ((!fcb) ||
                                (fcb.call(sc, name, msg, d))) {
                                cb.call(sc, name, msg, d);
                            }
                        }
                    }
                }
            }
        }

        h._unsubscribe = function(tree, path, index, sid) {
            if (typeof tree != "undefined") {
                if (index < path.length) {
                    var childNode = tree.c[path[index]];
                    this._unsubscribe(childNode, path, index + 1, sid);
                    if (childNode.s.length == 0) {
                        for (var x in childNode.c)
                            return;
                        delete tree.c[path[index]];
                    }
                    return;
                }
                else {
                    var callbacks = tree.s;
                    var max = callbacks.length;
                    for (var i = 0; i < max; i++)
                        if (sid == callbacks[i].sid) {
                            if (this._pubDepth > 0) {
                                callbacks[i].cb = null;
                                this._cleanup.push(callbacks[i]);
                            }
                            else
                                callbacks.splice(i, 1);
                            return;
                        }
                }
            }
        }

    };
    
    // Register the OpenAjax Hub itself as a library.
    OpenAjax.hub.registerLibrary("OpenAjax", "http://openajax.org/hub", "1.0", {});

}
/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 *
 *
 * This file incorporates work covered by the following copyright and
 * permission notice:
 *
 * Copyright 2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
  @project JSF Ajax Library 
  @version 2.0 
  @description  
*/

/**
 * Register with OpenAjax
 */
if (typeof OpenAjax != "undefined" &&
    typeof OpenAjax.hub.registerLibrary != "undefined") {
    OpenAjax.hub.registerLibrary("javax", "www.sun.com", "1.0", null);
}

/**
 * Create our top level namespace - javax.faces.Ajax
 */
if (javax == null || typeof javax == "undefined") {
    var javax = new Object();
}
if (javax.faces == null || typeof javax.faces == "undefined") {
    javax["faces"] = new Object();
}
if (javax.faces.Ajax == null || typeof javax.faces.Ajax == "undefined") {
    javax.faces["Ajax"] = new Object();
}

/**
 * @name javax
 * @namespace
 */

/**
 * @name javax.faces
 * @namespace
 */

/**
 * @name javax.faces.Ajax
 * @namespace
 */

/**
 * <p>Collect and encode state for input controls associated 
 * with the specified <code>form</code> element.</p> 
 *
 * @param form The <code>form</code> element whose contained
 * <code>input</code> controls will be collected and encoded.
 * Only successful controls will be collected and encoded in 
 * accordance with: <a href="http://www.w3.org/TR/html401/interact/forms.html#h-17.13.2">
 * Section 17.13.2 of the HTML Specification</a>.
 *
 * @returns The encoded state for the specified form's input controls.
 * @function javax.faces.Ajax.viewState
 */
javax.faces.Ajax.viewState = function(form) {

    var viewState = javax.faces.Ajax.AjaxEngine.serializeForm(form);
    return viewState;

}

/**
 * <p>Send an asynchronous Ajax request to the server.  
 * This function must:
 * <ul>
 * <li>Capture the element that triggered this Ajax request
 * (from the <code>element</code> argument, also known as the
 * <code>source</code> element.</li>
 * <li>Determine the <code>source</code> element's <code>form</code>
 * element.</li>
 * <li>Get the <code>form</code> view state by calling 
 * {@link javax.faces.Ajax.viewState} passing the 
 * <code>form</code> element as the argument.</li> 
 * <li>Collect post data arguments for the Ajax request.  
 * <ul>
 * <li>The following name/value pairs are required post data arguments:
 * <ul>
 * <li>The name and value of the <code>source</code> element that 
 * triggered this request;</li>
 * <li><code>javax.faces.partial.ajax</code> with the value 
 * <code>true</code></li>
 * </ul>
 * </li>
 * </ul>
 * </li>
 * <li>Collect optional post data arguments for the Ajax request.
 * <ul>
 * <li>Determine additional arguments (if any) from the <code>options</code>
 * argument. If <code>options.execute</code> exists, create the post data argument
 * with the name <code>javax.faces.partial.execute</code> and the value as a 
 * comma delimited <code>string</code> of client identifiers.  If 
 * <code>options.render</code> exists, create the post data argument with the name
 * <code>javax.faces.partial.render</code> and the value as a comma delimited 
 * <code>string</code> of client identifiers.</li>  
 * <li>Determine additional arguments (if any) from the <code>event</code>
 * argument.  The following name/value pairs may be used from the 
 * <code>event</code> object:
 * <ul>
 * <li><code>target</code> - the ID of the element that triggered the event.</li>
 * <li><code>captured</code> - the ID of the element that captured the event.</li>
 * <li><code>type</code> - the type of event (ex: onkeypress)</li>
 * <li><code>alt</code> - <code>true</code> if ALT key was pressed.</li>
 * <li><code>ctrl</code> - <code>true</code> if CTRL key was pressed.</li>
 * <li><code>shift</code> - <code>true</code> if SHIFT key was pressed. </li>
 * <li><code>meta</code> - <code>true</code> if META key was pressed. </li>
 * <li><code>right</code> - <code>true</code> if right mouse button  
 * was pressed. </li>
 * <li><code>left</code> - <code>true</code> if left mouse button  
 * was pressed. </li>
 * <li><code>keycode</code> - the key code. 
 * </ul>
 * </li>
 * </ul>
 * </li>
 * <li>Encode the set of post data arguments.</li>
 * <li>Join the encoded view state with the encoded set of post data arguments
 * to form the <code>query string</code> that will be sent to the server.</li>
 * <li>Send the request as an <code>asynchronous POST</code> using the 
 * <code>action</code> property of the <code>form</code> element as the 
 * <code>url</code>.</li>
 * </ul>  
 * Before the request is sent it must be put into a queue to ensure requests 
 * are sent in the same order as when they were initiated.  The request callback function
 * must examine the queue and determine the next request to be sent.  The behavior of the 
 * request callback function must be as follows:
 * <ul>
 * <li>If the request completed successfully invoke {@link javax.faces.Ajax.ajaxResponse} 
 * passing the <code>request</code> object.</li> 
 * <li>If the request did not complete successfully, notify the client.</li>
 * <li>Regardless of the outcome of the request (success or error) every request in the 
 * queue must be handled.  Examine the status of each request in the queue starting from 
 * the request that has been in the queue the longest.  If the status of the request is 
 * <code>complete</code> (readyState 4), dequeue the request (remove it from the queue).  
 * If the request has not been sent (readyState 0), send the request.  Requests that are 
 * taken off the queue and sent should not be put back on the queue.</li>
 * </ul>
 *
 * </p>
 *
 * @param element The DOM element that triggered this Ajax request.
 * @param event The DOM event that triggered this Ajax request.  The
 * <code>event</code> argument is optional.
 * @param options The set of available options that can be sent as
 * request parameters to control client and/or server side 
 * request processing. Acceptable name/value pair options are:
 * <table border="1">
 * <tr>
 * <th>name</th>
 * <th>value</th>
 * </tr>
 * <tr>
 * <td><code>execute</code></td>
 * <td><code>comma seperated list of client identifiers</code></td>
 * </tr>
 * <tr>
 * <td><code>render</code></td>
 * <td><code>comma seperated list of client identifiers</code></td>
 * </tr>
 * </table>
 * The <code>options</code> argument is optional. 
 *
 * @function javax.faces.Ajax.ajaxRequest
 * @throws ArgNotSet Error if first required argument <code>element</code> is not specified
 */
javax.faces.Ajax.ajaxRequest = function(element, event, options) {

    if (typeof element == 'undefined' || element == null) {
        throw {
                    name: 'ArgNotSet',
                    message: "ajaxRequest:Required first argument has not been set"
                }
    }

    // Capture the element that triggered this Ajax request.
    var source = element;

    var utils = new javax.faces.Ajax.Utils();
    var form = utils.getForm(source); 
    var viewState = javax.faces.Ajax.viewState(form);

    // Set up additional arguments to be used in the request..
    var args = new Object();
    if (typeof(options) != 'undefined' && options != null) {
        if (options.execute) {
            args["javax.faces.partial.execute"] = utils.toArray(options.execute,',').join(','); 
            options.execute = null;
            delete options.execute;
        }
        if (options.render) {
            args["javax.faces.partial.render"] = utils.toArray(options.render,',').join(','); 
            options.render = null;
            delete options.render;
        }
        utils.extend(args, options);
    }

    args["javax.faces.partial.ajax"] = "true";
    args["method"] = "POST";
    args["url"] = form.action;
    // add source
    var action = utils.$(source);
    if (action && action.form) {
        args[action.name] = action.value || 'x';
    } else {
        args[source] = source;
    }

    var ajaxEngine = new javax.faces.Ajax.AjaxEngine();
    ajaxEngine.setupArguments(args);
    ajaxEngine.queryString = viewState;
    ajaxEngine.sendRequest();
} 

/**
 * <p>Receive an Ajax response from the server.  
 * This function must evaluate the markup returned in the 
 * <code>responseXML</code> object and update the <code>DOM</code>
 * as follows:
 * <ul>
 * <li>Determine if the entire <code>DOM</code> should be replaced, or
 * if only specified sections (known as partial rendering) should be
 * updated.  The entire <code>DOM</code> must be replaced if a 
 * <code>render</code> element identifier is 
 * <code>javax.faces.viewRoot</code>.</li> 
 * <li>If partial <code>DOM</code> update is required, replace the 
 * <code>DOM</code> markup whose identifier matches the corresponding
 * <code>render</code> identifier.</li>
 * <li>Capture the view state sent in the response and insert it into
 * the <code>DOM</code> as a <code>hidden input</code> field with the
 * identifier <code>javax.faces.viewState</code>.  Look for all the
 * <code>form</code> elements in the <code>DOM</code>, and for each
 * <code>form</code> element, determine if a <code>javax.faces.viewState</code>
 * field exists.  If it does, replace it with the view state from the 
 * response.  If it does not exist, create a <code>hidden input</code>
 * field with the identifier <code>javax.faces.viewState</code> and 
 * insert it as a child element of the <code>form</code> elements.</li> 
 * </ul>
 * </p>
 *
 * @param request The <code>XMLHttpRequest</code> instance that 
 * contains the status code and response message from the server.
 *
 * @throws EmptyResponse error if request contains no data
 *
 * @function javax.faces.Ajax.ajaxResponse
 */ 
javax.faces.Ajax.ajaxResponse = function(request) {

    //  RELEASE_PENDING: We need to add more robust error handing - this error should probably be caught upstream
    if (request == null || typeof request == 'undefined' ) {
        throw new Error("javax.faces.Ajax.ajaxResponse: Request is null");
    }


    var utils = new javax.faces.Ajax.Utils();
    var xmlReq = request;

    var xml = xmlReq.responseXML;
    //  RELEASE_PENDING: We need to add more robust error handing - this error should probably be caught upstream
    if (xml === null) {
        throw new Error("javax.faces.Ajax.ajaxResponse: Reponse contains no data");
    }

    var id, content, markup, str;

    var components = xml.getElementsByTagName('components')[0];
    var render = components.getElementsByTagName('render');

    for (var i = 0; i < render.length; i++) {
        id = render[i].getAttribute('id');
        // join the CDATA sections in the markup
        markup = '';
        for (var j = 0; j < render[i].firstChild.childNodes.length; j++) {
            content = render[i].firstChild.childNodes[j];
            markup += content.text || content.data;
        }
        str = utils.stripScripts(markup);
        var src = str;
         
        // If our special render all markup is present..
        if (-1 != id.indexOf("javax.faces.ViewRoot")) {
            // if src contains <html>, trim the <html> and </html>, if present.
            //   if src contains <head>
            //      extract the contents of <head> and replace current document's
            //      <head> with the contents.
            //   if src contains <body>
            //      extract the contents of <body> and replace the current
            //      document's <body> with the contents.
            //   if src does not contain <body>
            //      replace the current document's <body> with the contents.
            var
                htmlStartEx = new RegExp("< *html.*>", "gi"),
                htmlEndEx = new RegExp("< */ *html.*>", "gi"),
                headStartEx = new RegExp("< *head.*>", "gi"),
                headEndEx = new RegExp("< */ *head.*>", "gi"),
                bodyStartEx = new RegExp("< *body.*>", "gi"),
                bodyEndEx = new RegExp("< */ *body.*>", "gi"),
                htmlStart, htmlEnd, headStart, headEnd, bodyStart, bodyEnd;
            var srcHead = null, srcBody = null;
            // find the current document's "body" element
            var docBody = document.getElementsByTagName("body")[0];
            // if src contains <html>
            if (null != (htmlStart = htmlStartEx.exec(src))) {
                // if src contains </html>
                if (null != (htmlEnd = htmlEndEx.exec(src))) {
                    src = src.substring(htmlStartEx.lastIndex, htmlEnd.index);
                } else {
                    src = src.substring(htmlStartEx.lastIndex);
                }
            }
            // if src contains <head>
            if (null != (headStart = headStartEx.exec(src))) {
                // if src contains </head>
                if (null != (headEnd = headEndEx.exec(src))) {
                    srcHead = src.substring(headStartEx.lastIndex,
                        headEnd.index);
                } else {
                    srcHead = src.substring(headStartEx.lastIndex);
                }
                // find the "head" element
                var docHead = document.getElementsByTagName("head")[0];
                if (docHead) {
                    utils.elementReplace(docHead, "head", srcHead);
                }
            }       
            // if src contains <body>
            if (null != (bodyStart = bodyStartEx.exec(src))) {
                // if src contains </body>
                if (null != (bodyEnd = bodyEndEx.exec(src))) {
                    srcBody = src.substring(bodyStartEx.lastIndex,
                        bodyEnd.index);
                } else {
                    srcBody = src.substring(bodyStartEx.lastIndex);
                }
                utils.elementReplace(docBody, "body", srcBody);
            }
            if (!srcBody) {
                utils.elementReplace(docBody, "body", src);
            }
        
        } else {
            var d = utils.$(id);
            if (!d) {
                throw {
                    name: 'NotFound',
                    message: id + 'not found'
                }
            }
            var parent = d.parentNode;
            var temp = document.createElement('div');
            temp.id = d.id;
            temp.innerHTML = utils.trim(str);

            parent.replaceChild(temp.firstChild,d);
        }
    }

    // Now set the view state from the server into the DOM
    // If there are multiple forms, make sure they all have a 
    // viewState hidden field.

    var state = state || xml.getElementsByTagName('state')[0].firstChild;
    if (state) {
        var stateElem = utils.$("javax.faces.ViewState");
        if (stateElem) {
            stateElem.value = state.text || state.data;
        }
        var numForms = document.forms.length;
        var field;
        for (var k = 0; k < numForms; k++) {
            field = document.forms[k].elements["javax.faces.ViewState"];
            if (typeof field == 'undefined') {
                field = document.createElement("input");
                field.type = "hidden";
                field.name = "javax.faces.ViewState";
                document.forms[k].appendChild(field);
            }
            field.value = state.text || state.data;
        }
    }
}

/**
 *
 * <p>Return the value of <code>Application.getProjectStage()</code> for
 * the currently running application instance.  Calling this method must
 * not cause any network transaction to happen to the server.</p>
 * 
 * @returns The <code>String</code> representing the current state of the 
 * running application in a typical product development lifecycle.  Refer
 * to <code>javax.faces.application.Application.getProjectStage</code> and
 * <code>javax.faces.application.ProjectStage</code>.
 * @function javax.faces.Ajax.getProjectStage
 */ 

javax.faces.Ajax.getProjectStage = function() {

    var result = "#{facesContext.application.projectStage}";

    return result;

}

/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 *
 *
 * This file incorporates work covered by the following copyright and
 * permission notice:
 *
 * Copyright 2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * AjaxEngine contains the JavaScript for performing Ajax functions. 
 */
javax.faces.Ajax.AjaxEngine = function() {

    var req = new Object();        // Request Object
    req.url = null;                // Request URL
    req.xmlReq = null;             // XMLHttpRequest Object
    req.async = true;              // Default - Asynchronous
    req.parameters = new Object(); // Parameters For GET or POST
    req.queryString = null;        // Encoded Data For GET or POST
    req.method = null;             // GET or POST
    req.onComplete = null;         // Request/Response Complete Callback Handle
    req.onSuccess = null;          // Request/Response Success Callback Handle
    req.onError = null;            // Request/Response Error Callback Handle
    req.responseTxt = null;        // Response Content (Text)
    req.responseXML = null;        // Response Content (XML) 
    req.status = null;             // Response Status Code From Server
    req.fromQueue = false;         // Indicates if the request was taken off the queue
                                   // before being sent.  This prevents the request from
                                   // entering the queue redundantly. 

    req.que = javax.faces.Ajax.AjaxEngine.Queue;

    // Get an XMLHttpRequest Handle
    req.xmlReq = javax.faces.Ajax.AjaxEngine.getTransport();
    if (req.xmlReq == null) { return null; }

    // Set up request/response state callbacks
    req.xmlReq.onreadystatechange = function() {
        if (req==null || req.xmlReq==null) { return; }
        if (req.xmlReq.readyState==1) { req.onOpenCB(req); }      // open has been called
        if (req.xmlReq.readyState==2) { req.onSendCB(req); }      // send has been called
        if (req.xmlReq.readyState==3) { req.onReceivingCB(req); } // data in process of being received from the server
        if (req.xmlReq.readyState==4) { req.onCompleteCB(req); }  // response from server has arrived
    };

    // State Callback Functions

    req.onOpenCB = function() {
    };

    req.onSendCB = function() {
    };

    req.onReceivingCB = function() {
    };

    /**
     * This function is called when the request/response interaction
     * is complete.  'onComplete', 'onSuccess' or 'onError' callbacks 
     * will be called if they have been registered,
     * If the return status code is successfull, dequeue all requests
     * from the queue that have completed.  If a request has been found 
     * on the queue that has not been sent, send the request.
     */
    req.onCompleteCB = function() {
        if (typeof(req.onComplete)=="function") {
            req.onComplete(req);
            return;
        }
        if ((req.xmlReq.status == null || typeof req.xmlReq.status == 'undefined')
            || req.xmlReq.status == 0 ||
            (req.xmlReq.status >= 200 && req.xmlReq.status < 300)) { 
            javax.faces.Ajax.ajaxResponse(req.xmlReq);
        } else {
            if (typeof(req.onError)=="function") {
                req.onError(req);
                return;
            } else {
                throw new Error("AjaxEngine:  reponse was an error code, onError not set");
            }

        }

        // Regardless of whether the request completed successfully (or not),
        // dequeue requests that have been completed (readyState 4) and send
        // requests that ready to be sent (readyState 0).

        var nextReq = req.que.getOldestElement();
        if (nextReq == null || typeof nextReq == 'undefined') { 
            return;
        }
        while ((typeof nextReq.xmlReq != 'undefined' && nextReq.xmlReq != null) && 
            nextReq.xmlReq.readyState == 4) {
            req.que.dequeue();
            nextReq = req.que.getOldestElement();
            if (nextReq == null || typeof nextReq == 'undefined') {
                break;
            }
        }
        if (nextReq == null || typeof nextReq == 'undefined') { 
            return;
        }
        if ((typeof nextReq.xmlReq != 'undefined' && nextReq.xmlReq != null) && 
            nextReq.xmlReq.readyState == 0) {
            nextReq.fromQueue = true;
            nextReq.sendRequest();
        }
    };

    /**
     * Utility method that accepts additional arguments for the AjaxEngine.
     * If an argument is passed in that matches an AjaxEngine property, the 
     * argument value becomes the value of the AjaxEngine property.  
     * Arguments that don't match AjaxEngine properties are added as 
     * request parameters.
     */
    req.setupArguments = function(args) {
        for (var i in args) {
            if (typeof(req[i]) == 'undefined') {
                req.parameters[i] = args[i];
            } else {
                req[i] = args[i];
            }
        }
    };

    /**
     * This function does final encoding of parameters, determines the request method
     * (GET or POST) and sends the request using the specified url.
     */ 
    req.sendRequest = function() {
        if (req.xmlReq != null) {
            // if there is already a request on the queue waiting to be processed..
            // just queue this request
            if (!req.que.isEmpty()) {
                if (!req.fromQueue) {
                    req.que.enqueue(req);
                    return;
                }
            }
            // If the queue is empty, queue up this request and send
            if (!req.fromQueue) {
                req.que.enqueue(req);
            } 
            // Some logic to get the real request URL
            if (req.generateUniqueUrl && req.method=="GET") {
                req.parameters["AjaxRequestUniqueId"] = new Date().getTime() + "" + req.requestIndex;
            }
            var content = null; // For POST requests, to hold query string
            for (var i in req.parameters) {
                if (req.queryString.length>0) { req.queryString += "&"; }
                    req.queryString += encodeURIComponent(i) + "=" + encodeURIComponent(req.parameters[i]);
            }
            if (req.method=="GET") {
                if (req.queryString.length>0) {
                    req.url += ((req.url.indexOf("?")>-1)?"&":"?") + req.queryString;
                }
            }
            req.xmlReq.open(req.method,req.url,req.async);
            if (req.method=="POST") {
                if (typeof(req.xmlReq.setRequestHeader) != 'undefined') {
                    req.xmlReq.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
                }
                content = req.queryString;
            }
            req.xmlReq.send(content);
        }
    };

    return req;
};

/**
 * Utility function to serialize form elements.
 */
javax.faces.Ajax.AjaxEngine.serializeForm = function(theform) {
    var els = theform.elements;
    var len = els.length;
    var qString = "";
    this.addField = function(name,value) {
        if (qString.length>0) {
            qString += "&";
        }
        qString += encodeURIComponent(name) + "=" + encodeURIComponent(value);
    };
    for (var i=0; i<len; i++) {
        var el = els[i];
        if (!el.disabled) {
            switch(el.type) {
                case 'text': case 'password': case 'hidden': case 'textarea':
                    this.addField(el.name,el.value);
                    break;
                case 'select-one':
                    if (el.selectedIndex>=0) {
                        this.addField(el.name,el.options[el.selectedIndex].value);
                    }
                    break;
                case 'select-multiple':
                    for (var j=0; j<el.options.length; j++) {
                        if (el.options[j].selected) {
                            this.addField(el.name,el.options[j].value);
                        }
                    }
                    break;
                case 'checkbox': case 'radio':
                    if (el.checked) {
                        this.addField(el.name,el.value);
                    }
                    break;
            }
        }
    }
    return qString;
};

/**
 * Utility function to get an XMLHttpRequest handle.
 */
javax.faces.Ajax.AjaxEngine.getTransport = function() {
    var methods = [
      function() { return new XMLHttpRequest(); },
      function() { return new ActiveXObject('Msxml2.XMLHTTP'); },
      function() { return new ActiveXObject('Microsoft.XMLHTTP'); }
    ];

    var returnVal;
    for(var i = 0, len = methods.length; i < len; i++) {
      try {
        returnVal = methods[i]();
      } catch(e) {
        continue;
      }
      return returnVal;
    }
    throw new Error('Could not create an XHR object.');
}


/**
 * Simple queue implementaton.
 */

 // RELEASE_PENDING: Need to change the format of the data payload to be flat
 //   since the OpenAjax spec would prefer that we don't pass values by reference.
if (!window["javax.faces.Ajax.AjaxEngine.Queue"]) {
  javax.faces.Ajax.AjaxEngine.Queue = new function() {

    // Create the internal queue
    var queue = [];


    // the amount of space at the front of the queue, initialised to zero
    var queueSpace = 0;

    /* Returns the size of this Queue. The size of a Queue is equal to the number
     * of elements that have been enqueued minus the number of elements that have
     * been dequeued.
     */
    this.getSize = function(){
        return queue.length - queueSpace;
    }

    /* Returns true if this Queue is empty, and false otherwise. A Queue is empty
     * if the number of elements that have been enqueued equals the number of
     * elements that have been dequeued.
     */
    this.isEmpty = function(){
        return (queue.length == 0);
    }

    /* Enqueues the specified element in this Queue.
     * After the element is put in the queue, an event is fired.
     *
     * @param element - the element to enqueue
     */
    this.enqueue = function(element){
        queue.push(element);
        var args = new Object();
        args["enqueue"] = element;
        OpenAjax.hub.publish("javax.faces.AjaxEngine.Queue",args);
    }

    /* Dequeues an element from this Queue. The oldest element in this Queue is
     * removed and returned. If this Queue is empty then undefined is returned.
     *
     * @returns The element that was removed rom the queue.
     */
    this.dequeue = function(){
        // initialise the element to return to be undefined
        var element = undefined;

        // check whether the queue is empty
        if (queue.length){
            // fetch the oldest element in the queue
            element = queue[queueSpace];

            // update the amount of space and check whether a shift should occur
            if (++queueSpace * 2 >= queue.length){
                // set the queue equal to the non-empty portion of the queue
                queue = queue.slice(queueSpace);
                // reset the amount of space at the front of the queue
                queueSpace=0;
            }
        }
        if (element != "undefined") {
            var args = new Object();
            args["dequeue"] = element;
            OpenAjax.hub.publish("javax.faces.AjaxEngine.Queue",args);
        }

        // return the removed element
        return element;
    }

    /* Returns the oldest element in this Queue. If this Queue is empty then
     * undefined is returned. This function returns the same value as the dequeue
     * function, but does not remove the returned element from this Queue.
     */
    this.getOldestElement = function() {
        // initialise the element to return to be undefined
        var element = undefined;

        // if the queue is not element then fetch the oldest element in the queue
        if (queue.length) element = queue[queueSpace];
        // return the oldest element
        return element;
    }
  }
}

/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 *
 *
 * This file incorporates work covered by the following copyright and
 * permission notice:
 *
 * Copyright 2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Utility functions
 */
javax.faces.Ajax.Utils = function() {

    this.createClass = function() {
        return function() {
            this.initialize.apply(this, arguments);
        }
    }

    this.extend = function(destination, source) {
        for (var property in source) {
            destination[property] = source[property];
        }
        return destination;
    }

    this.getForm = function(element) {
        if (element) {
            var form = this.$(element);
            while (form && form.tagName && form.tagName.toLowerCase() != 'form') {
                if (form.form) return form.form;
                if (form.parentNode) {
                        form = form.parentNode;
                } else {
                    form = null;
                }
                if (form) return form;
            }
            return document.forms[0];
        }
        return null;
    }

    this.$ = function() {
        var results = [], element;
        for (var i = 0; i < arguments.length; i++) {
            element = arguments[i];
            if (typeof element == 'string')
                element = document.getElementById(element);
            results.push(element);
        }
        return this.reduce(results);
    }

    this.reduce = function(toReduce) {
        return toReduce.length > 1 ? toReduce : toReduce[0];
    }

    this.toArray = function(s,e) {
        var sarray;
        if (typeof s == 'string') {
            sarray = s.split((e)?e:' ');
            for (var i=0; i<sarray.length; i++) {
                sarray[i] = this.trim(sarray[i]);
            }
        }
        return sarray;
    }

    this.trim = function(toTrim) {
        var result = null;
        if (null != toTrim) {
            var s = toTrim.replace( /^\s+/g, "" );
            result = s.replace( /\s+$/g, "" );
        }
        return result;
    }

    this.scriptFrag = '(?:<script.*?>)((\n|\r|.)*?)(?:<\/script>)';

    this.stripScripts = function(src) {
        return src.replace(new RegExp(this.scriptFrag, 'img'), '');
    }

    this.evalScripts = function(src) {
        return this.extractScripts(src).map(function(script) { return eval(script) });
    }

    this.extractScripts = function(src) {
        var matchAll = new RegExp(this.scriptFrag, 'img');
        var matchOne = new RegExp(this.scriptFrag, 'im');
        return (src.match(matchAll) || []).map(function(scriptTag) {
            return (scriptTag.match(matchOne) || ['', ''])[1];
        });
    }

this.elementReplace = function(d, tempTagName, src) {
        var parent = d.parentNode;
        var temp = document.createElement(tempTagName);
        var result = null;
        temp.id = d.id;
    
        // If we are creating a head element...
        if (-1 != d.tagName.toLowerCase().indexOf("head") && d.tagName.length == 4) {
    
            // head replacement only appears to work on firefox.
            if (-1 == BrowserDetect.browser.indexOf("Firefox")) {
                return result;
            }   
        
            // Strip link elements from src.
            if (-1 != src.indexOf("link")) {
                var 
                    linkStartEx = new RegExp("< *link.*>", "gi");
                var linkStart;
                while (null != (linkStart = linkStartEx.exec(src))) {
                    src = src.substring(0, linkStart.index) +
                        src.substring(linkStartEx.lastIndex);
                    linkStartEx.lastIndex = 0;
                }
            }

            // Strip style elements from src
            if (-1 != src.indexOf("style")) {
                var
                    styleStartEx = new RegExp("< *style.*>", "gi"),
                    styleEndEx = new RegExp("< */ *style.*>", "gi");
                var styleStart, styleEnd;
                while (null != (styleStart = styleStartEx.exec(src))) {
                    styleEnd = styleEndEx.exec(src);
                    src = src.substring(0, styleStart.index) +
                        src.substring(styleStartEx.lastIndex);
                    styleStartEx.lastIndex = 0;
                }
            }

            temp.innerHTML = src;

            // clone all the link elements...
            var i, links, styles;
            links = d.getElementsByTagName("link");
            if (links) {
                for (i = 0; i < links.length; i++) {
                    temp.appendChild(links[i].cloneNode(true));
                }
            }
            // then clone all the style elements.
            styles = d.getElementsByTagName("style");
            if (styles) {
                for (i = 0; i < styles.length; i++) {
                    temp.appendChild(styles[i].cloneNode(true));
                }
            }
        } else {
            temp.innerHTML = src;
        }


        result = temp
        parent.replaceChild(temp, d);
        return result;
    }
}
/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 *
 *
 * This file incorporates work covered by the following copyright and
 * permission notice:
 *
 *      Copyright 2006-2008 OpenAjax Alliance
 *      
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*******************************************************************************
 * OpenAjax.js
 *
 * Reference implementation of the OpenAjax Hub, as specified by OpenAjax Alliance.
 * Specification is under development at: 
 *
 *   http://www.openajax.org/member/wiki/OpenAjax_Hub_Specification
 *
 * Copyright 2006-2008 OpenAjax Alliance
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not 
 * use this file except in compliance with the License. You may obtain a copy 
 * of the License at http://www.apache.org/licenses/LICENSE-2.0 . Unless 
 * required by applicable law or agreed to in writing, software distributed 
 * under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR 
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the 
 * specific language governing permissions and limitations under the License.
 *
 ******************************************************************************/

// prevent re-definition of the OpenAjax object
if (!window["OpenAjax"]) {
    OpenAjax = new function() {
        var t = true;
        var f = false;
        var g = window;
        var libs;
        var ooh = "org.openajax.hub.";

        var h = {};
        this.hub = h;
        h.implementer = "http://openajax.org";
        h.implVersion = "1.0";
        h.specVersion = "1.0";
        h.implExtraData = {};
        libs = {};
        h.libraries = libs;

        h.registerLibrary = function(prefix, nsURL, version, extra) {
            libs[prefix] = {
                prefix: prefix,
                namespaceURI: nsURL,
                version: version,
                extraData: extra
            };
            this.publish(ooh + "registerLibrary", libs[prefix]);
        }
        h.unregisterLibrary = function(prefix) {
            this.publish(ooh + "unregisterLibrary", libs[prefix]);
            delete libs[prefix];
        }

        h._subscriptions = { c:{}, s:[] };
        h._cleanup = [];
        h._subIndex = 0;
        h._pubDepth = 0;

        h.subscribe = function(name, callback, scope, subscriberData, filter)
        {
            if (!scope) {
                scope = window;
            }
            var handle = name + "." + this._subIndex;
            var sub = { scope: scope, cb: callback, fcb: filter, data: subscriberData, sid: this._subIndex++, hdl: handle };
            var path = name.split(".");
            this._subscribe(this._subscriptions, path, 0, sub);
            return handle;
        }

        h.publish = function(name, message)
        {
            var path = name.split(".");
            this._pubDepth++;
            this._publish(this._subscriptions, path, 0, name, message);
            this._pubDepth--;
            if ((this._cleanup.length > 0) && (this._pubDepth == 0)) {
                for (var i = 0; i < this._cleanup.length; i++)
                    this.unsubscribe(this._cleanup[i].hdl);
                delete(this._cleanup);
                this._cleanup = [];
            }
        }

        h.unsubscribe = function(sub)
        {
            var path = sub.split(".");
            var sid = path.pop();
            this._unsubscribe(this._subscriptions, path, 0, sid);
        }

        h._subscribe = function(tree, path, index, sub)
        {
            var token = path[index];
            if (index == path.length)
                tree.s.push(sub);
            else {
                if (typeof tree.c == "undefined")
                    tree.c = {};
                if (typeof tree.c[token] == "undefined") {
                    tree.c[token] = { c: {}, s: [] };
                    this._subscribe(tree.c[token], path, index + 1, sub);
                }
                else
                    this._subscribe(tree.c[token], path, index + 1, sub);
            }
        }

        h._publish = function(tree, path, index, name, msg) {
            if (typeof tree != "undefined") {
                var node;
                if (index == path.length) {
                    node = tree;
                } else {
                    this._publish(tree.c[path[index]], path, index + 1, name, msg);
                    this._publish(tree.c["*"], path, index + 1, name, msg);
                    node = tree.c["**"];
                }
                if (typeof node != "undefined") {
                    var callbacks = node.s;
                    var max = callbacks.length;
                    for (var i = 0; i < max; i++) {
                        if (callbacks[i].cb) {
                            var sc = callbacks[i].scope;
                            var cb = callbacks[i].cb;
                            var fcb = callbacks[i].fcb;
                            var d = callbacks[i].data;
                            if (typeof cb == "string") {
                                // get a function object
                                cb = sc[cb];
                            }
                            if (typeof fcb == "string") {
                                // get a function object
                                fcb = sc[fcb];
                            }
                            if ((!fcb) ||
                                (fcb.call(sc, name, msg, d))) {
                                cb.call(sc, name, msg, d);
                            }
                        }
                    }
                }
            }
        }

        h._unsubscribe = function(tree, path, index, sid) {
            if (typeof tree != "undefined") {
                if (index < path.length) {
                    var childNode = tree.c[path[index]];
                    this._unsubscribe(childNode, path, index + 1, sid);
                    if (childNode.s.length == 0) {
                        for (var x in childNode.c)
                            return;
                        delete tree.c[path[index]];
                    }
                    return;
                }
                else {
                    var callbacks = tree.s;
                    var max = callbacks.length;
                    for (var i = 0; i < max; i++)
                        if (sid == callbacks[i].sid) {
                            if (this._pubDepth > 0) {
                                callbacks[i].cb = null;
                                this._cleanup.push(callbacks[i]);
                            }
                            else
                                callbacks.splice(i, 1);
                            return;
                        }
                }
            }
        }

    };
    
    // Register the OpenAjax Hub itself as a library.
    OpenAjax.hub.registerLibrary("OpenAjax", "http://openajax.org/hub", "1.0", {});

}
/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 *
 *
 * This file incorporates work covered by the following copyright and
 * permission notice:
 *
 * Copyright 2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
  @project JSF Ajax Library 
  @version 2.0 
  @description  
*/

/**
 * Register with OpenAjax
 */
if (typeof OpenAjax != "undefined" &&
    typeof OpenAjax.hub.registerLibrary != "undefined") {
    OpenAjax.hub.registerLibrary("javax", "www.sun.com", "1.0", null);
}

/**
 * Create our top level namespace - javax.faces.Ajax
 */
if (javax == null || typeof javax == "undefined") {
    var javax = new Object();
}
if (javax.faces == null || typeof javax.faces == "undefined") {
    javax["faces"] = new Object();
}
if (javax.faces.Ajax == null || typeof javax.faces.Ajax == "undefined") {
    javax.faces["Ajax"] = new Object();
}

/**
 * @name javax
 * @namespace
 */

/**
 * @name javax.faces
 * @namespace
 */

/**
 * @name javax.faces.Ajax
 * @namespace
 */

/**
 * <p>Collect and encode state for input controls associated 
 * with the specified <code>form</code> element.</p> 
 *
 * @param form The <code>form</code> element whose contained
 * <code>input</code> controls will be collected and encoded.
 * Only successful controls will be collected and encoded in 
 * accordance with: <a href="http://www.w3.org/TR/html401/interact/forms.html#h-17.13.2">
 * Section 17.13.2 of the HTML Specification</a>.
 *
 * @returns The encoded state for the specified form's input controls.
 * @function javax.faces.Ajax.viewState
 */
javax.faces.Ajax.viewState = function(form) {

    var viewState = javax.faces.Ajax.AjaxEngine.serializeForm(form);
    return viewState;

}

/**
 * <p>Send an asynchronous Ajax request to the server.  
 * This function must:
 * <ul>
 * <li>Capture the element that triggered this Ajax request
 * (from the <code>element</code> argument, also known as the
 * <code>source</code> element.</li>
 * <li>Determine the <code>source</code> element's <code>form</code>
 * element.</li>
 * <li>Get the <code>form</code> view state by calling 
 * {@link javax.faces.Ajax.viewState} passing the 
 * <code>form</code> element as the argument.</li> 
 * <li>Collect post data arguments for the Ajax request.  
 * <ul>
 * <li>The following name/value pairs are required post data arguments:
 * <ul>
 * <li>The name and value of the <code>source</code> element that 
 * triggered this request;</li>
 * <li><code>javax.faces.partial.ajax</code> with the value 
 * <code>true</code></li>
 * </ul>
 * </li>
 * </ul>
 * </li>
 * <li>Collect optional post data arguments for the Ajax request.
 * <ul>
 * <li>Determine additional arguments (if any) from the <code>options</code>
 * argument. If <code>options.execute</code> exists, create the post data argument
 * with the name <code>javax.faces.partial.execute</code> and the value as a 
 * comma delimited <code>string</code> of client identifiers.  If 
 * <code>options.render</code> exists, create the post data argument with the name
 * <code>javax.faces.partial.render</code> and the value as a comma delimited 
 * <code>string</code> of client identifiers.</li>  
 * <li>Determine additional arguments (if any) from the <code>event</code>
 * argument.  The following name/value pairs may be used from the 
 * <code>event</code> object:
 * <ul>
 * <li><code>target</code> - the ID of the element that triggered the event.</li>
 * <li><code>captured</code> - the ID of the element that captured the event.</li>
 * <li><code>type</code> - the type of event (ex: onkeypress)</li>
 * <li><code>alt</code> - <code>true</code> if ALT key was pressed.</li>
 * <li><code>ctrl</code> - <code>true</code> if CTRL key was pressed.</li>
 * <li><code>shift</code> - <code>true</code> if SHIFT key was pressed. </li>
 * <li><code>meta</code> - <code>true</code> if META key was pressed. </li>
 * <li><code>right</code> - <code>true</code> if right mouse button  
 * was pressed. </li>
 * <li><code>left</code> - <code>true</code> if left mouse button  
 * was pressed. </li>
 * <li><code>keycode</code> - the key code. 
 * </ul>
 * </li>
 * </ul>
 * </li>
 * <li>Encode the set of post data arguments.</li>
 * <li>Join the encoded view state with the encoded set of post data arguments
 * to form the <code>query string</code> that will be sent to the server.</li>
 * <li>Send the request as an <code>asynchronous POST</code> using the 
 * <code>action</code> property of the <code>form</code> element as the 
 * <code>url</code>.</li>
 * </ul>  
 * Before the request is sent it must be put into a queue to ensure requests 
 * are sent in the same order as when they were initiated.  The request callback function
 * must examine the queue and determine the next request to be sent.  The behavior of the 
 * request callback function must be as follows:
 * <ul>
 * <li>If the request completed successfully invoke {@link javax.faces.Ajax.ajaxResponse} 
 * passing the <code>request</code> object.</li> 
 * <li>If the request did not complete successfully, notify the client.</li>
 * <li>Regardless of the outcome of the request (success or error) every request in the 
 * queue must be handled.  Examine the status of each request in the queue starting from 
 * the request that has been in the queue the longest.  If the status of the request is 
 * <code>complete</code> (readyState 4), dequeue the request (remove it from the queue).  
 * If the request has not been sent (readyState 0), send the request.  Requests that are 
 * taken off the queue and sent should not be put back on the queue.</li>
 * </ul>
 *
 * </p>
 *
 * @param element The DOM element that triggered this Ajax request.
 * @param event The DOM event that triggered this Ajax request.  The
 * <code>event</code> argument is optional.
 * @param options The set of available options that can be sent as
 * request parameters to control client and/or server side 
 * request processing. Acceptable name/value pair options are:
 * <table border="1">
 * <tr>
 * <th>name</th>
 * <th>value</th>
 * </tr>
 * <tr>
 * <td><code>execute</code></td>
 * <td><code>comma seperated list of client identifiers</code></td>
 * </tr>
 * <tr>
 * <td><code>render</code></td>
 * <td><code>comma seperated list of client identifiers</code></td>
 * </tr>
 * </table>
 * The <code>options</code> argument is optional. 
 *
 * @function javax.faces.Ajax.ajaxRequest
 * @throws ArgNotSet Error if first required argument <code>element</code> is not specified
 */
javax.faces.Ajax.ajaxRequest = function(element, event, options) {

    if (typeof element == 'undefined' || element == null) {
        throw {
                    name: 'ArgNotSet',
                    message: "ajaxRequest:Required first argument has not been set"
                }
    }

    // Capture the element that triggered this Ajax request.
    var source = element;

    var utils = new javax.faces.Ajax.Utils();
    var form = utils.getForm(source); 
    var viewState = javax.faces.Ajax.viewState(form);

    // Set up additional arguments to be used in the request..
    var args = new Object();
    if (typeof(options) != 'undefined' && options != null) {
        if (options.execute) {
            args["javax.faces.partial.execute"] = utils.toArray(options.execute,',').join(','); 
            options.execute = null;
            delete options.execute;
        }
        if (options.render) {
            args["javax.faces.partial.render"] = utils.toArray(options.render,',').join(','); 
            options.render = null;
            delete options.render;
        }
        utils.extend(args, options);
    }

    args["javax.faces.partial.ajax"] = "true";
    args["method"] = "POST";
    args["url"] = form.action;
    // add source
    var action = utils.$(source);
    if (action && action.form) {
        args[action.name] = action.value || 'x';
    } else {
        args[source] = source;
    }

    var ajaxEngine = new javax.faces.Ajax.AjaxEngine();
    ajaxEngine.setupArguments(args);
    ajaxEngine.queryString = viewState;
    ajaxEngine.sendRequest();
} 

/**
 * <p>Receive an Ajax response from the server.  
 * This function must evaluate the markup returned in the 
 * <code>responseXML</code> object and update the <code>DOM</code>
 * as follows:
 * <ul>
 * <li>Determine if the entire <code>DOM</code> should be replaced, or
 * if only specified sections (known as partial rendering) should be
 * updated.  The entire <code>DOM</code> must be replaced if a 
 * <code>render</code> element identifier is 
 * <code>javax.faces.viewRoot</code>.</li> 
 * <li>If partial <code>DOM</code> update is required, replace the 
 * <code>DOM</code> markup whose identifier matches the corresponding
 * <code>render</code> identifier.</li>
 * <li>Capture the view state sent in the response and insert it into
 * the <code>DOM</code> as a <code>hidden input</code> field with the
 * identifier <code>javax.faces.viewState</code>.  Look for all the
 * <code>form</code> elements in the <code>DOM</code>, and for each
 * <code>form</code> element, determine if a <code>javax.faces.viewState</code>
 * field exists.  If it does, replace it with the view state from the 
 * response.  If it does not exist, create a <code>hidden input</code>
 * field with the identifier <code>javax.faces.viewState</code> and 
 * insert it as a child element of the <code>form</code> elements.</li> 
 * </ul>
 * </p>
 *
 * @param request The <code>XMLHttpRequest</code> instance that 
 * contains the status code and response message from the server.
 *
 * @throws EmptyResponse error if request contains no data
 *
 * @function javax.faces.Ajax.ajaxResponse
 */ 
javax.faces.Ajax.ajaxResponse = function(request) {

    //  RELEASE_PENDING: We need to add more robust error handing - this error should probably be caught upstream
    if (request == null || typeof request == 'undefined' ) {
        throw new Error("javax.faces.Ajax.ajaxResponse: Request is null");
    }


    var utils = new javax.faces.Ajax.Utils();
    var xmlReq = request;

    var xml = xmlReq.responseXML;
    //  RELEASE_PENDING: We need to add more robust error handing - this error should probably be caught upstream
    if (xml === null) {
        throw new Error("javax.faces.Ajax.ajaxResponse: Reponse contains no data");
    }

    var id, content, markup, str;

    var components = xml.getElementsByTagName('components')[0];
    var render = components.getElementsByTagName('render');

    for (var i = 0; i < render.length; i++) {
        id = render[i].getAttribute('id');
        // join the CDATA sections in the markup
        markup = '';
        for (var j = 0; j < render[i].firstChild.childNodes.length; j++) {
            content = render[i].firstChild.childNodes[j];
            markup += content.text || content.data;
        }
        str = utils.stripScripts(markup);
        var src = str;
         
        // If our special render all markup is present..
        if (-1 != id.indexOf("javax.faces.ViewRoot")) {
            // if src contains <html>, trim the <html> and </html>, if present.
            //   if src contains <head>
            //      extract the contents of <head> and replace current document's
            //      <head> with the contents.
            //   if src contains <body>
            //      extract the contents of <body> and replace the current
            //      document's <body> with the contents.
            //   if src does not contain <body>
            //      replace the current document's <body> with the contents.
            var
                htmlStartEx = new RegExp("< *html.*>", "gi"),
                htmlEndEx = new RegExp("< */ *html.*>", "gi"),
                headStartEx = new RegExp("< *head.*>", "gi"),
                headEndEx = new RegExp("< */ *head.*>", "gi"),
                bodyStartEx = new RegExp("< *body.*>", "gi"),
                bodyEndEx = new RegExp("< */ *body.*>", "gi"),
                htmlStart, htmlEnd, headStart, headEnd, bodyStart, bodyEnd;
            var srcHead = null, srcBody = null;
            // find the current document's "body" element
            var docBody = document.getElementsByTagName("body")[0];
            // if src contains <html>
            if (null != (htmlStart = htmlStartEx.exec(src))) {
                // if src contains </html>
                if (null != (htmlEnd = htmlEndEx.exec(src))) {
                    src = src.substring(htmlStartEx.lastIndex, htmlEnd.index);
                } else {
                    src = src.substring(htmlStartEx.lastIndex);
                }
            }
            // if src contains <head>
            if (null != (headStart = headStartEx.exec(src))) {
                // if src contains </head>
                if (null != (headEnd = headEndEx.exec(src))) {
                    srcHead = src.substring(headStartEx.lastIndex,
                        headEnd.index);
                } else {
                    srcHead = src.substring(headStartEx.lastIndex);
                }
                // find the "head" element
                var docHead = document.getElementsByTagName("head")[0];
                if (docHead) {
                    utils.elementReplace(docHead, "head", srcHead);
                }
            }       
            // if src contains <body>
            if (null != (bodyStart = bodyStartEx.exec(src))) {
                // if src contains </body>
                if (null != (bodyEnd = bodyEndEx.exec(src))) {
                    srcBody = src.substring(bodyStartEx.lastIndex,
                        bodyEnd.index);
                } else {
                    srcBody = src.substring(bodyStartEx.lastIndex);
                }
                utils.elementReplace(docBody, "body", srcBody);
            }
            if (!srcBody) {
                utils.elementReplace(docBody, "body", src);
            }
        
        } else {
            var d = utils.$(id);
            if (!d) {
                throw {
                    name: 'NotFound',
                    message: id + 'not found'
                }
            }
            var parent = d.parentNode;
            var temp = document.createElement('div');
            temp.id = d.id;
            temp.innerHTML = utils.trim(str);

            parent.replaceChild(temp.firstChild,d);
        }
    }

    // Now set the view state from the server into the DOM
    // If there are multiple forms, make sure they all have a 
    // viewState hidden field.

    var state = state || xml.getElementsByTagName('state')[0].firstChild;
    if (state) {
        var stateElem = utils.$("javax.faces.ViewState");
        if (stateElem) {
            stateElem.value = state.text || state.data;
        }
        var numForms = document.forms.length;
        var field;
        for (var k = 0; k < numForms; k++) {
            field = document.forms[k].elements["javax.faces.ViewState"];
            if (typeof field == 'undefined') {
                field = document.createElement("input");
                field.type = "hidden";
                field.name = "javax.faces.ViewState";
                document.forms[k].appendChild(field);
            }
            field.value = state.text || state.data;
        }
    }
}

/**
 *
 * <p>Return the value of <code>Application.getProjectStage()</code> for
 * the currently running application instance.  Calling this method must
 * not cause any network transaction to happen to the server.</p>
 * 
 * @returns The <code>String</code> representing the current state of the 
 * running application in a typical product development lifecycle.  Refer
 * to <code>javax.faces.application.Application.getProjectStage</code> and
 * <code>javax.faces.application.ProjectStage</code>.
 * @function javax.faces.Ajax.getProjectStage
 */ 

javax.faces.Ajax.getProjectStage = function() {

    var result = "#{facesContext.application.projectStage}";

    return result;

}

/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 *
 *
 * This file incorporates work covered by the following copyright and
 * permission notice:
 *
 * Copyright 2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * AjaxEngine contains the JavaScript for performing Ajax functions. 
 */
javax.faces.Ajax.AjaxEngine = function() {

    var req = new Object();        // Request Object
    req.url = null;                // Request URL
    req.xmlReq = null;             // XMLHttpRequest Object
    req.async = true;              // Default - Asynchronous
    req.parameters = new Object(); // Parameters For GET or POST
    req.queryString = null;        // Encoded Data For GET or POST
    req.method = null;             // GET or POST
    req.onComplete = null;         // Request/Response Complete Callback Handle
    req.onSuccess = null;          // Request/Response Success Callback Handle
    req.onError = null;            // Request/Response Error Callback Handle
    req.responseTxt = null;        // Response Content (Text)
    req.responseXML = null;        // Response Content (XML) 
    req.status = null;             // Response Status Code From Server
    req.fromQueue = false;         // Indicates if the request was taken off the queue
                                   // before being sent.  This prevents the request from
                                   // entering the queue redundantly. 

    req.que = javax.faces.Ajax.AjaxEngine.Queue;

    // Get an XMLHttpRequest Handle
    req.xmlReq = javax.faces.Ajax.AjaxEngine.getTransport();
    if (req.xmlReq == null) { return null; }

    // Set up request/response state callbacks
    req.xmlReq.onreadystatechange = function() {
        if (req==null || req.xmlReq==null) { return; }
        if (req.xmlReq.readyState==1) { req.onOpenCB(req); }      // open has been called
        if (req.xmlReq.readyState==2) { req.onSendCB(req); }      // send has been called
        if (req.xmlReq.readyState==3) { req.onReceivingCB(req); } // data in process of being received from the server
        if (req.xmlReq.readyState==4) { req.onCompleteCB(req); }  // response from server has arrived
    };

    // State Callback Functions

    req.onOpenCB = function() {
    };

    req.onSendCB = function() {
    };

    req.onReceivingCB = function() {
    };

    /**
     * This function is called when the request/response interaction
     * is complete.  'onComplete', 'onSuccess' or 'onError' callbacks 
     * will be called if they have been registered,
     * If the return status code is successfull, dequeue all requests
     * from the queue that have completed.  If a request has been found 
     * on the queue that has not been sent, send the request.
     */
    req.onCompleteCB = function() {
        if (typeof(req.onComplete)=="function") {
            req.onComplete(req);
            return;
        }
        if ((req.xmlReq.status == null || typeof req.xmlReq.status == 'undefined')
            || req.xmlReq.status == 0 ||
            (req.xmlReq.status >= 200 && req.xmlReq.status < 300)) { 
            javax.faces.Ajax.ajaxResponse(req.xmlReq);
        } else {
            if (typeof(req.onError)=="function") {
                req.onError(req);
                return;
            } else {
                throw new Error("AjaxEngine:  reponse was an error code, onError not set");
            }

        }

        // Regardless of whether the request completed successfully (or not),
        // dequeue requests that have been completed (readyState 4) and send
        // requests that ready to be sent (readyState 0).

        var nextReq = req.que.getOldestElement();
        if (nextReq == null || typeof nextReq == 'undefined') { 
            return;
        }
        while ((typeof nextReq.xmlReq != 'undefined' && nextReq.xmlReq != null) && 
            nextReq.xmlReq.readyState == 4) {
            req.que.dequeue();
            nextReq = req.que.getOldestElement();
            if (nextReq == null || typeof nextReq == 'undefined') {
                break;
            }
        }
        if (nextReq == null || typeof nextReq == 'undefined') { 
            return;
        }
        if ((typeof nextReq.xmlReq != 'undefined' && nextReq.xmlReq != null) && 
            nextReq.xmlReq.readyState == 0) {
            nextReq.fromQueue = true;
            nextReq.sendRequest();
        }
    };

    /**
     * Utility method that accepts additional arguments for the AjaxEngine.
     * If an argument is passed in that matches an AjaxEngine property, the 
     * argument value becomes the value of the AjaxEngine property.  
     * Arguments that don't match AjaxEngine properties are added as 
     * request parameters.
     */
    req.setupArguments = function(args) {
        for (var i in args) {
            if (typeof(req[i]) == 'undefined') {
                req.parameters[i] = args[i];
            } else {
                req[i] = args[i];
            }
        }
    };

    /**
     * This function does final encoding of parameters, determines the request method
     * (GET or POST) and sends the request using the specified url.
     */ 
    req.sendRequest = function() {
        if (req.xmlReq != null) {
            // if there is already a request on the queue waiting to be processed..
            // just queue this request
            if (!req.que.isEmpty()) {
                if (!req.fromQueue) {
                    req.que.enqueue(req);
                    return;
                }
            }
            // If the queue is empty, queue up this request and send
            if (!req.fromQueue) {
                req.que.enqueue(req);
            } 
            // Some logic to get the real request URL
            if (req.generateUniqueUrl && req.method=="GET") {
                req.parameters["AjaxRequestUniqueId"] = new Date().getTime() + "" + req.requestIndex;
            }
            var content = null; // For POST requests, to hold query string
            for (var i in req.parameters) {
                if (req.queryString.length>0) { req.queryString += "&"; }
                    req.queryString += encodeURIComponent(i) + "=" + encodeURIComponent(req.parameters[i]);
            }
            if (req.method=="GET") {
                if (req.queryString.length>0) {
                    req.url += ((req.url.indexOf("?")>-1)?"&":"?") + req.queryString;
                }
            }
            req.xmlReq.open(req.method,req.url,req.async);
            if (req.method=="POST") {
                if (typeof(req.xmlReq.setRequestHeader) != 'undefined') {
                    req.xmlReq.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
                }
                content = req.queryString;
            }
            req.xmlReq.send(content);
        }
    };

    return req;
};

/**
 * Utility function to serialize form elements.
 */
javax.faces.Ajax.AjaxEngine.serializeForm = function(theform) {
    var els = theform.elements;
    var len = els.length;
    var qString = "";
    this.addField = function(name,value) {
        if (qString.length>0) {
            qString += "&";
        }
        qString += encodeURIComponent(name) + "=" + encodeURIComponent(value);
    };
    for (var i=0; i<len; i++) {
        var el = els[i];
        if (!el.disabled) {
            switch(el.type) {
                case 'text': case 'password': case 'hidden': case 'textarea':
                    this.addField(el.name,el.value);
                    break;
                case 'select-one':
                    if (el.selectedIndex>=0) {
                        this.addField(el.name,el.options[el.selectedIndex].value);
                    }
                    break;
                case 'select-multiple':
                    for (var j=0; j<el.options.length; j++) {
                        if (el.options[j].selected) {
                            this.addField(el.name,el.options[j].value);
                        }
                    }
                    break;
                case 'checkbox': case 'radio':
                    if (el.checked) {
                        this.addField(el.name,el.value);
                    }
                    break;
            }
        }
    }
    return qString;
};

/**
 * Utility function to get an XMLHttpRequest handle.
 */
javax.faces.Ajax.AjaxEngine.getTransport = function() {
    var methods = [
      function() { return new XMLHttpRequest(); },
      function() { return new ActiveXObject('Msxml2.XMLHTTP'); },
      function() { return new ActiveXObject('Microsoft.XMLHTTP'); }
    ];

    var returnVal;
    for(var i = 0, len = methods.length; i < len; i++) {
      try {
        returnVal = methods[i]();
      } catch(e) {
        continue;
      }
      return returnVal;
    }
    throw new Error('Could not create an XHR object.');
}


/**
 * Simple queue implementaton.
 */

 // RELEASE_PENDING: Need to change the format of the data payload to be flat
 //   since the OpenAjax spec would prefer that we don't pass values by reference.
if (!window["javax.faces.Ajax.AjaxEngine.Queue"]) {
  javax.faces.Ajax.AjaxEngine.Queue = new function() {

    // Create the internal queue
    var queue = [];


    // the amount of space at the front of the queue, initialised to zero
    var queueSpace = 0;

    /* Returns the size of this Queue. The size of a Queue is equal to the number
     * of elements that have been enqueued minus the number of elements that have
     * been dequeued.
     */
    this.getSize = function(){
        return queue.length - queueSpace;
    }

    /* Returns true if this Queue is empty, and false otherwise. A Queue is empty
     * if the number of elements that have been enqueued equals the number of
     * elements that have been dequeued.
     */
    this.isEmpty = function(){
        return (queue.length == 0);
    }

    /* Enqueues the specified element in this Queue.
     * After the element is put in the queue, an event is fired.
     *
     * @param element - the element to enqueue
     */
    this.enqueue = function(element){
        queue.push(element);
        var args = new Object();
        args["enqueue"] = element;
        OpenAjax.hub.publish("javax.faces.AjaxEngine.Queue",args);
    }

    /* Dequeues an element from this Queue. The oldest element in this Queue is
     * removed and returned. If this Queue is empty then undefined is returned.
     *
     * @returns The element that was removed rom the queue.
     */
    this.dequeue = function(){
        // initialise the element to return to be undefined
        var element = undefined;

        // check whether the queue is empty
        if (queue.length){
            // fetch the oldest element in the queue
            element = queue[queueSpace];

            // update the amount of space and check whether a shift should occur
            if (++queueSpace * 2 >= queue.length){
                // set the queue equal to the non-empty portion of the queue
                queue = queue.slice(queueSpace);
                // reset the amount of space at the front of the queue
                queueSpace=0;
            }
        }
        if (element != "undefined") {
            var args = new Object();
            args["dequeue"] = element;
            OpenAjax.hub.publish("javax.faces.AjaxEngine.Queue",args);
        }

        // return the removed element
        return element;
    }

    /* Returns the oldest element in this Queue. If this Queue is empty then
     * undefined is returned. This function returns the same value as the dequeue
     * function, but does not remove the returned element from this Queue.
     */
    this.getOldestElement = function() {
        // initialise the element to return to be undefined
        var element = undefined;

        // if the queue is not element then fetch the oldest element in the queue
        if (queue.length) element = queue[queueSpace];
        // return the oldest element
        return element;
    }
  }
}

/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 *
 *
 * This file incorporates work covered by the following copyright and
 * permission notice:
 *
 * Copyright 2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Utility functions
 */
javax.faces.Ajax.Utils = function() {

    this.createClass = function() {
        return function() {
            this.initialize.apply(this, arguments);
        }
    }

    this.extend = function(destination, source) {
        for (var property in source) {
            destination[property] = source[property];
        }
        return destination;
    }

    this.getForm = function(element) {
        if (element) {
            var form = this.$(element);
            while (form && form.tagName && form.tagName.toLowerCase() != 'form') {
                if (form.form) return form.form;
                if (form.parentNode) {
                        form = form.parentNode;
                } else {
                    form = null;
                }
                if (form) return form;
            }
            return document.forms[0];
        }
        return null;
    }

    this.$ = function() {
        var results = [], element;
        for (var i = 0; i < arguments.length; i++) {
            element = arguments[i];
            if (typeof element == 'string')
                element = document.getElementById(element);
            results.push(element);
        }
        return this.reduce(results);
    }

    this.reduce = function(toReduce) {
        return toReduce.length > 1 ? toReduce : toReduce[0];
    }

    this.toArray = function(s,e) {
        var sarray;
        if (typeof s == 'string') {
            sarray = s.split((e)?e:' ');
            for (var i=0; i<sarray.length; i++) {
                sarray[i] = this.trim(sarray[i]);
            }
        }
        return sarray;
    }

    this.trim = function(toTrim) {
        var result = null;
        if (null != toTrim) {
            var s = toTrim.replace( /^\s+/g, "" );
            result = s.replace( /\s+$/g, "" );
        }
        return result;
    }

    this.scriptFrag = '(?:<script.*?>)((\n|\r|.)*?)(?:<\/script>)';

    this.stripScripts = function(src) {
        return src.replace(new RegExp(this.scriptFrag, 'img'), '');
    }

    this.evalScripts = function(src) {
        return this.extractScripts(src).map(function(script) { return eval(script) });
    }

    this.extractScripts = function(src) {
        var matchAll = new RegExp(this.scriptFrag, 'img');
        var matchOne = new RegExp(this.scriptFrag, 'im');
        return (src.match(matchAll) || []).map(function(scriptTag) {
            return (scriptTag.match(matchOne) || ['', ''])[1];
        });
    }

this.elementReplace = function(d, tempTagName, src) {
        var parent = d.parentNode;
        var temp = document.createElement(tempTagName);
        var result = null;
        temp.id = d.id;
    
        // If we are creating a head element...
        if (-1 != d.tagName.toLowerCase().indexOf("head") && d.tagName.length == 4) {
    
            // head replacement only appears to work on firefox.
            if (-1 == BrowserDetect.browser.indexOf("Firefox")) {
                return result;
            }   
        
            // Strip link elements from src.
            if (-1 != src.indexOf("link")) {
                var 
                    linkStartEx = new RegExp("< *link.*>", "gi");
                var linkStart;
                while (null != (linkStart = linkStartEx.exec(src))) {
                    src = src.substring(0, linkStart.index) +
                        src.substring(linkStartEx.lastIndex);
                    linkStartEx.lastIndex = 0;
                }
            }

            // Strip style elements from src
            if (-1 != src.indexOf("style")) {
                var
                    styleStartEx = new RegExp("< *style.*>", "gi"),
                    styleEndEx = new RegExp("< */ *style.*>", "gi");
                var styleStart, styleEnd;
                while (null != (styleStart = styleStartEx.exec(src))) {
                    styleEnd = styleEndEx.exec(src);
                    src = src.substring(0, styleStart.index) +
                        src.substring(styleStartEx.lastIndex);
                    styleStartEx.lastIndex = 0;
                }
            }

            temp.innerHTML = src;

            // clone all the link elements...
            var i, links, styles;
            links = d.getElementsByTagName("link");
            if (links) {
                for (i = 0; i < links.length; i++) {
                    temp.appendChild(links[i].cloneNode(true));
                }
            }
            // then clone all the style elements.
            styles = d.getElementsByTagName("style");
            if (styles) {
                for (i = 0; i < styles.length; i++) {
                    temp.appendChild(styles[i].cloneNode(true));
                }
            }
        } else {
            temp.innerHTML = src;
        }


        result = temp
        parent.replaceChild(temp, d);
        return result;
    }
}
