/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.oauth.signature;

import com.sun.jersey.api.uri.UriComponent;
import com.sun.jersey.oauth.signature.Base64;
import com.sun.jersey.oauth.signature.InvalidSecretException;
import com.sun.jersey.oauth.signature.OAuthSecrets;
import com.sun.jersey.oauth.signature.OAuthSignatureMethod;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RSA_SHA1
implements OAuthSignatureMethod {
    public static final String NAME = "RSA-SHA1";
    private static final String SIGNATURE_ALGORITHM = "SHA1withRSA";
    private static final String KEY_TYPE = "RSA";
    private static final String BEGIN_CERT = "-----BEGIN CERTIFICATE";

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public String sign(String elements, OAuthSecrets secrets) throws InvalidSecretException {
        byte[] rsasha1;
        RSAPrivateKey rsaPrivKey;
        KeyFactory keyf;
        byte[] decodedPrivKey;
        Signature sig;
        try {
            sig = Signature.getInstance(SIGNATURE_ALGORITHM);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalStateException(nsae);
        }
        try {
            decodedPrivKey = Base64.decode(secrets.getConsumerSecret());
        }
        catch (IOException ioe) {
            throw new InvalidSecretException("invalid consumer secret");
        }
        try {
            keyf = KeyFactory.getInstance(KEY_TYPE);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalStateException(nsae);
        }
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(decodedPrivKey);
        try {
            rsaPrivKey = (RSAPrivateKey)keyf.generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException ikse) {
            throw new IllegalStateException(ikse);
        }
        try {
            sig.initSign(rsaPrivKey);
        }
        catch (InvalidKeyException ike) {
            throw new IllegalStateException(ike);
        }
        try {
            sig.update(elements.getBytes());
        }
        catch (SignatureException se) {
            throw new IllegalStateException(se);
        }
        try {
            rsasha1 = sig.sign();
        }
        catch (SignatureException se) {
            throw new IllegalStateException(se);
        }
        return UriComponent.encode((String)new String(Base64.encode(rsasha1)), (UriComponent.Type)UriComponent.Type.UNRESERVED);
    }

    @Override
    public boolean verify(String elements, OAuthSecrets secrets, String signature) throws InvalidSecretException {
        byte[] decodedSignature;
        Signature sig;
        try {
            sig = Signature.getInstance(SIGNATURE_ALGORITHM);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalStateException(nsae);
        }
        RSAPublicKey rsaPubKey = null;
        String tmpkey = secrets.getConsumerSecret();
        if (tmpkey.startsWith(BEGIN_CERT)) {
            try {
                Certificate cert = null;
                ByteArrayInputStream bais = new ByteArrayInputStream(tmpkey.getBytes());
                BufferedInputStream bis = new BufferedInputStream(bais);
                CertificateFactory certfac = CertificateFactory.getInstance("X.509");
                while (bis.available() > 0) {
                    cert = certfac.generateCertificate(bis);
                }
                rsaPubKey = (RSAPublicKey)cert.getPublicKey();
            }
            catch (IOException ex) {
                Logger.getLogger(RSA_SHA1.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (CertificateException ex) {
                Logger.getLogger(RSA_SHA1.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        try {
            decodedSignature = Base64.decode(UriComponent.decode((String)signature, (UriComponent.Type)UriComponent.Type.UNRESERVED));
        }
        catch (IOException ioe) {
            return false;
        }
        try {
            sig.initVerify(rsaPubKey);
        }
        catch (InvalidKeyException ike) {
            throw new IllegalStateException(ike);
        }
        try {
            sig.update(elements.getBytes());
        }
        catch (SignatureException se) {
            throw new IllegalStateException(se);
        }
        try {
            return sig.verify(decodedSignature);
        }
        catch (SignatureException se) {
            throw new IllegalStateException(se);
        }
    }
}

