/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.ImageComponent;
import com.sun.webui.jsf.component.ImageHyperlink;
import com.sun.webui.jsf.renderkit.html.HyperlinkRenderer;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.RenderingUtilities;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class ImageHyperlinkRenderer
extends HyperlinkRenderer {
    private static final String LABEL_LEFT = "left";
    private static final String LABEL_RIGHT = "right";

    protected void finishRenderAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        ImageHyperlink ilink = (ImageHyperlink)component;
        ImageComponent ic = ilink.getImageFacet();
        Object text = ilink.getText();
        String label = text == null ? null : ConversionUtilities.convertValueToString(component, text);
        String textPosition = ilink.getTextPosition();
        if (label != null && textPosition.equalsIgnoreCase(LABEL_LEFT)) {
            writer.writeText((Object)label, null);
            writer.write("&nbsp;");
        }
        if (ic != null) {
            String parentText = (String)((ImageHyperlink)component).getText();
            if (ic.getAlt() == null || ic.getAlt().equals("")) {
                ic.setAlt(parentText);
            }
            if (ic.getToolTip() == null || ic.getToolTip().equals("")) {
                ic.setToolTip(parentText);
            }
            RenderingUtilities.renderComponent((UIComponent)ic, context);
        }
        if (label != null && textPosition.equalsIgnoreCase(LABEL_RIGHT)) {
            writer.write("&nbsp;");
            writer.writeText((Object)label, null);
        }
    }
}

