/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.processor.generator;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCatchBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCommentPart;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.codemodel.writer.ProgressCodeWriter;
import com.sun.tools.ws.processor.ProcessorAction;
import com.sun.tools.ws.processor.config.Configuration;
import com.sun.tools.ws.processor.generator.GeneratorBase;
import com.sun.tools.ws.processor.generator.GeneratorException;
import com.sun.tools.ws.processor.generator.GeneratorUtil;
import com.sun.tools.ws.processor.model.Model;
import com.sun.tools.ws.processor.model.Port;
import com.sun.tools.ws.processor.model.Service;
import com.sun.tools.ws.processor.model.java.JavaInterface;
import com.sun.tools.ws.wscompile.WSCodeWriter;
import com.sun.xml.bind.api.JAXBRIContext;
import com.sun.xml.ws.encoding.soap.SOAPVersion;
import com.sun.xml.ws.util.JAXWSUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.WebServiceClient;

public class ServiceGenerator
extends GeneratorBase
implements ProcessorAction {
    private String serviceNS;

    public ServiceGenerator() {
    }

    private ServiceGenerator(Model model, Configuration config, Properties properties) {
        super(model, config, properties);
    }

    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties) {
        return new ServiceGenerator(model, config, properties);
    }

    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties, SOAPVersion ver) {
        return new ServiceGenerator(model, config, properties);
    }

    private JType getType(String typeName) throws IOException {
        JType type = null;
        try {
            type = this.cm.parseType(typeName);
            return type;
        }
        catch (ClassNotFoundException e) {
            type = this.cm.ref(typeName);
            return type;
        }
    }

    private JInvocation createQName(QName name) {
        return JExpr._new((JClass)this.cm.ref(QName.class)).arg(name.getNamespaceURI()).arg(name.getLocalPart());
    }

    private JInvocation createURL(URL url) {
        return JExpr._new((JClass)this.cm.ref(URL.class)).arg(url.toExternalForm());
    }

    protected void visitService(Service service) {
        try {
            String fieldName;
            JavaInterface intf = service.getJavaInterface();
            String className = this.env.getNames().customJavaTypeClassName(intf);
            if (this.donotOverride && GeneratorUtil.classExists(this.env, className)) {
                this.log("Class " + className + " exists. Not overriding.");
                return;
            }
            JDefinedClass cls = this.getClass(className, ClassType.CLASS);
            cls._extends(javax.xml.ws.Service.class);
            JFieldVar urlField = cls.field(28, URL.class, "WSDL_LOCATION");
            JClass qNameCls = this.cm.ref(QName.class);
            JInvocation inv = JExpr._new((JClass)qNameCls);
            inv.arg("namespace");
            inv.arg("localpart");
            String serviceFieldName = JAXBRIContext.mangleNameToClassName((String)service.getName().getLocalPart()).toUpperCase();
            JFieldVar serviceField = cls.field(28, QName.class, serviceFieldName, (JExpression)this.createQName(service.getName()));
            for (Port port : service.getPorts()) {
                if (port.isProvider()) continue;
                inv = JExpr._new((JClass)qNameCls);
                inv.arg("namespace");
                inv.arg("localpart");
                fieldName = JAXBRIContext.mangleNameToClassName((String)port.getName().getLocalPart()).toUpperCase();
                JFieldVar portField = cls.field(28, QName.class, fieldName, (JExpression)this.createQName(port.getName()));
            }
            JBlock staticBlock = cls.init();
            URL url = new URL(JAXWSUtils.absolutize((String)JAXWSUtils.getFileOrURLName((String)this.wsdlLocation)));
            JVar urlVar = staticBlock.decl((JType)this.cm.ref(URL.class), "url", JExpr._null());
            JTryBlock tryBlock = staticBlock._try();
            tryBlock.body().assign((JAssignmentTarget)urlVar, (JExpression)this.createURL(url));
            JCatchBlock catchBlock = tryBlock._catch(this.cm.ref(MalformedURLException.class));
            catchBlock.param("e");
            catchBlock.body().directStatement("e.printStackTrace();");
            staticBlock.assign((JAssignmentTarget)urlField, (JExpression)urlVar);
            JDocComment comment = cls.javadoc();
            if (service.getJavaDoc() != null) {
                comment.add((Object)service.getJavaDoc());
                comment.add((Object)"\n\n");
            }
            for (String doc : this.getJAXWSClassComment()) {
                comment.add((Object)doc);
            }
            JMethod constructor = cls.constructor(1);
            constructor.param(URL.class, "wsdlLocation");
            constructor.param(QName.class, "serviceName");
            constructor.body().directStatement("super(wsdlLocation, serviceName);");
            constructor = cls.constructor(1);
            constructor.body().directStatement("super(WSDL_LOCATION, " + serviceFieldName + ");");
            JAnnotationUse webServiceClientAnn = cls.annotate(this.cm.ref(WebServiceClient.class));
            this.writeWebServiceClientAnnotation(service, webServiceClientAnn);
            for (Port port : service.getPorts()) {
                if (port.isProvider()) continue;
                JMethod m = null;
                JDocComment methodDoc = null;
                JDefinedClass retType = this.getClass(port.getJavaInterface().getName(), ClassType.INTERFACE);
                m = cls.method(1, (JType)retType, port.getPortGetter());
                methodDoc = m.javadoc();
                if (port.getJavaDoc() != null) {
                    methodDoc.add((Object)port.getJavaDoc());
                }
                JCommentPart ret = methodDoc.addReturn();
                ret.add((Object)("returns " + retType.name()));
                JBlock body = m.body();
                StringBuffer statement = new StringBuffer("return (");
                statement.append(retType.name());
                fieldName = JAXBRIContext.mangleNameToClassName((String)port.getName().getLocalPart()).toUpperCase();
                statement.append(")super.getPort(" + fieldName + ", ");
                statement.append(retType.name());
                statement.append(".class);");
                body.directStatement(statement.toString());
                this.writeWebEndpoint(port, m);
            }
            WSCodeWriter cw = new WSCodeWriter(this.sourceDir, this.env);
            if (this.env.verbose()) {
                cw = new ProgressCodeWriter((CodeWriter)cw, System.out);
            }
            this.cm.build((CodeWriter)cw);
        }
        catch (IOException e) {
            throw new GeneratorException("generator.nestedGeneratorError", e);
        }
    }

    protected JDefinedClass getClass(String className, ClassType type) {
        JDefinedClass cls = null;
        try {
            cls = this.cm._class(className, type);
        }
        catch (JClassAlreadyExistsException e) {
            cls = this.cm._getClass(className);
        }
        return cls;
    }

    private void writeWebServiceClientAnnotation(Service service, JAnnotationUse wsa) {
        String serviceName = service.getName().getLocalPart();
        this.serviceNS = service.getName().getNamespaceURI();
        wsa.param("name", serviceName);
        wsa.param("targetNamespace", this.serviceNS);
        wsa.param("wsdlLocation", this.wsdlLocation);
    }

    private void writeWebEndpoint(Port port, JMethod m) {
        JAnnotationUse webEndpointAnn = m.annotate(this.cm.ref(WebEndpoint.class));
        webEndpointAnn.param("name", port.getName().getLocalPart());
    }
}

