/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.processor.generator;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCommentPart;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.writer.ProgressCodeWriter;
import com.sun.tools.ws.processor.ProcessorAction;
import com.sun.tools.ws.processor.config.Configuration;
import com.sun.tools.ws.processor.generator.GeneratorBase;
import com.sun.tools.ws.processor.generator.GeneratorException;
import com.sun.tools.ws.processor.generator.GeneratorUtil;
import com.sun.tools.ws.processor.model.Model;
import com.sun.tools.ws.processor.model.Port;
import com.sun.tools.ws.processor.model.Service;
import com.sun.tools.ws.processor.model.java.JavaInterface;
import com.sun.tools.ws.wscompile.WSCodeWriter;
import com.sun.xml.ws.encoding.soap.SOAPVersion;
import java.io.IOException;
import java.util.Properties;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.WebServiceClient;

public class ServiceInterfaceGenerator
extends GeneratorBase
implements ProcessorAction {
    private String serviceNS;

    public ServiceInterfaceGenerator() {
    }

    private ServiceInterfaceGenerator(Model model, Configuration config, Properties properties) {
        super(model, config, properties);
    }

    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties) {
        return new ServiceInterfaceGenerator(model, config, properties);
    }

    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties, SOAPVersion ver) {
        return new ServiceInterfaceGenerator(model, config, properties);
    }

    protected void visitService(Service service) {
        try {
            JavaInterface intf = service.getJavaInterface();
            String className = this.env.getNames().customJavaTypeClassName(intf);
            if (this.donotOverride && GeneratorUtil.classExists(this.env, className)) {
                this.log("Class " + className + " exists. Not overriding.");
                return;
            }
            JDefinedClass cls = this.getClass(className, ClassType.INTERFACE);
            cls._implements(javax.xml.ws.Service.class);
            JDocComment comment = cls.javadoc();
            for (String doc : this.getJAXWSClassComment()) {
                comment.add((Object)doc);
            }
            JAnnotationUse webServiceClientAnn = cls.annotate(this.cm.ref(WebServiceClient.class));
            this.writeWebServiceClientAnnotation(service, webServiceClientAnn);
            for (Port port : service.getPorts()) {
                if (port.isProvider()) continue;
                JMethod m = null;
                JDocComment methodDoc = null;
                JDefinedClass retType = this.getClass(port.getJavaInterface().getName(), ClassType.INTERFACE);
                m = cls.method(1, (JType)retType, port.getPortGetter());
                methodDoc = m.javadoc();
                JCommentPart ret = methodDoc.addReturn();
                ret.add((Object)("returns " + retType.name()));
                this.writeWebEndpoint(port, m);
            }
            WSCodeWriter cw = new WSCodeWriter(this.sourceDir, this.env);
            if (this.env.verbose()) {
                cw = new ProgressCodeWriter((CodeWriter)cw, System.out);
            }
            this.cm.build((CodeWriter)cw);
        }
        catch (IOException e) {
            throw new GeneratorException("generator.nestedGeneratorError", e);
        }
    }

    protected JDefinedClass getClass(String className, ClassType type) {
        JDefinedClass cls = null;
        try {
            cls = this.cm._class(className, type);
        }
        catch (JClassAlreadyExistsException e) {
            cls = this.cm._getClass(className);
        }
        return cls;
    }

    private void writeWebServiceClientAnnotation(Service service, JAnnotationUse wsa) {
        String serviceName = service.getName().getLocalPart();
        this.serviceNS = service.getName().getNamespaceURI();
        wsa.param("name", serviceName);
        wsa.param("targetNamespace", this.serviceNS);
        wsa.param("wsdlLocation", this.wsdlLocation);
    }

    private void writeWebEndpoint(Port port, JMethod m) {
        JAnnotationUse webEndpointAnn = m.annotate(this.cm.ref(WebEndpoint.class));
        webEndpointAnn.param("name", port.getName().getLocalPart());
    }
}

