/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.processor.modeler.annotation;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.TypeMirror;
import com.sun.tools.ws.processor.modeler.annotation.WebServiceConstants;
import com.sun.xml.ws.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeModeler
implements WebServiceConstants {
    private static Set<String> skipProperties = new HashSet<String>();

    public static TypeDeclaration getDeclaration(TypeMirror typeMirror) {
        Object retDecl = null;
        if (typeMirror instanceof DeclaredType) {
            return ((DeclaredType)typeMirror).getDeclaration();
        }
        return null;
    }

    public static TypeDeclaration getTypeDeclaration(TypeMirror type) {
        Object typeDecl = null;
        typeDecl = type instanceof ClassType ? ((ClassType)type).getDeclaration() : ((InterfaceType)type).getDeclaration();
        return typeDecl;
    }

    public static Collection<InterfaceType> getSuperinterfaces(TypeMirror type) {
        Collection interfaces = null;
        interfaces = type instanceof ClassType ? ((ClassType)type).getSuperinterfaces() : ((InterfaceType)type).getSuperinterfaces();
        return interfaces;
    }

    public static Collection<InterfaceType> getSuperinterfaces(TypeDeclaration type) {
        Collection interfaces = null;
        interfaces = type instanceof ClassDeclaration ? ((ClassDeclaration)type).getSuperinterfaces() : ((InterfaceDeclaration)type).getSuperinterfaces();
        return interfaces;
    }

    public static TypeDeclaration getDeclaringClassMethod(TypeMirror theClass, String methodName, TypeMirror[] args) {
        return TypeModeler.getDeclaringClassMethod(TypeModeler.getDeclaration(theClass), methodName, args);
    }

    public static TypeDeclaration getDeclaringClassMethod(TypeDeclaration theClass, String methodName, TypeMirror[] args) {
        ClassType superClass;
        TypeDeclaration retClass = null;
        if (theClass instanceof ClassDeclaration && (superClass = ((ClassDeclaration)theClass).getSuperclass()) != null) {
            retClass = TypeModeler.getDeclaringClassMethod((TypeMirror)superClass, methodName, args);
        }
        if (retClass == null) {
            for (InterfaceType interfaceType : TypeModeler.getSuperinterfaces(theClass)) {
                retClass = TypeModeler.getDeclaringClassMethod((TypeMirror)interfaceType, methodName, args);
            }
        }
        if (retClass == null) {
            Collection methods = theClass.getMethods();
            for (MethodDeclaration method : methods) {
                if (!method.getSimpleName().equals(methodName) || !method.getDeclaringType().equals(theClass)) continue;
                retClass = theClass;
                break;
            }
        }
        return retClass;
    }

    public static Collection<InterfaceType> collectInterfaces(TypeDeclaration type) {
        Collection superInterfaces = type.getSuperinterfaces();
        Collection interfaces = type.getSuperinterfaces();
        for (InterfaceType interfaceType : superInterfaces) {
            interfaces.addAll(TypeModeler.collectInterfaces(TypeModeler.getDeclaration((TypeMirror)interfaceType)));
        }
        return interfaces;
    }

    public static boolean isSubclass(String subTypeName, String superTypeName, AnnotationProcessorEnvironment env) {
        return TypeModeler.isSubclass(env.getTypeDeclaration(subTypeName), env.getTypeDeclaration(superTypeName));
    }

    public static boolean isSubclass(TypeDeclaration subType, TypeDeclaration superType) {
        if (subType.equals(superType)) {
            return false;
        }
        return TypeModeler.isSubtype(subType, superType);
    }

    public static TypeMirror getHolderValueType(TypeMirror type, TypeDeclaration defHolder, AnnotationProcessorEnvironment env) {
        TypeDeclaration typeDecl = TypeModeler.getDeclaration(type);
        if (typeDecl == null) {
            return null;
        }
        if (TypeModeler.isSubtype(typeDecl, defHolder) && type instanceof DeclaredType) {
            FieldDeclaration member;
            Collection argTypes = ((DeclaredType)type).getActualTypeArguments();
            if (argTypes.size() == 1) {
                TypeMirror mirror = (TypeMirror)argTypes.iterator().next();
                return mirror;
            }
            if (argTypes.size() == 0 && (member = TypeModeler.getValueMember(typeDecl)) != null) {
                return member.getType();
            }
        }
        return null;
    }

    public static FieldDeclaration getValueMember(TypeMirror classType) {
        return TypeModeler.getValueMember(TypeModeler.getDeclaration(classType));
    }

    public static FieldDeclaration getValueMember(TypeDeclaration type) {
        FieldDeclaration member = null;
        for (FieldDeclaration field : type.getFields()) {
            if (!field.getSimpleName().equals("value")) continue;
            member = field;
            break;
        }
        if (member == null && type instanceof ClassDeclaration) {
            member = TypeModeler.getValueMember((TypeMirror)((ClassDeclaration)type).getSuperclass());
        }
        return member;
    }

    public static boolean isSubtype(TypeDeclaration d1, TypeDeclaration d2) {
        ClassType superClass;
        if (d1.equals(d2)) {
            return true;
        }
        ClassDeclaration superClassDecl = null;
        if (d1 instanceof ClassDeclaration && (superClass = ((ClassDeclaration)d1).getSuperclass()) != null && (superClassDecl = superClass.getDeclaration()).equals(d2)) {
            return true;
        }
        for (InterfaceType superIntf : d1.getSuperinterfaces()) {
            if (superIntf.getDeclaration().equals(d2)) {
                return true;
            }
            if (TypeModeler.isSubtype((TypeDeclaration)superIntf.getDeclaration(), d2)) {
                return true;
            }
            if (superClassDecl == null || !TypeModeler.isSubtype((TypeDeclaration)superClassDecl, d2)) continue;
            return true;
        }
        return false;
    }

    public static Map<String, TypeMirror> getExceptionProperties(TypeMirror type) {
        return TypeModeler.getExceptionProperties(TypeModeler.getDeclaration(type));
    }

    public static Map<String, TypeMirror> getExceptionProperties(TypeDeclaration type) {
        HashMap<String, TypeMirror> members = new HashMap<String, TypeMirror>();
        TypeModeler.collectExceptionProperties(type, members);
        return members;
    }

    public static void collectExceptionProperties(TypeMirror type, Map<String, TypeMirror> members) {
        TypeModeler.collectExceptionProperties(TypeModeler.getDeclaration(type), members);
    }

    public static void collectExceptionProperties(TypeDeclaration type, Map<String, TypeMirror> members) {
        Collection methods = type.getMethods();
        for (MethodDeclaration method : methods) {
            String name;
            Collection modifiers = method.getModifiers();
            if (!modifiers.contains(Modifier.PUBLIC) || modifiers.contains(Modifier.FINAL) && modifiers.contains(Modifier.STATIC) || modifiers.contains(Modifier.TRANSIENT) || (name = method.getSimpleName()).length() <= 3 && !name.startsWith("is") || skipProperties.contains(name)) continue;
            TypeMirror resultType = method.getReturnType();
            Collection params = method.getParameters();
            if (params.size() != 0) continue;
            if (name.startsWith("get") && (!(resultType instanceof PrimitiveType) || ((PrimitiveType)resultType).getKind() != PrimitiveType.Kind.BOOLEAN)) {
                members.put(StringUtils.decapitalize((String)name.substring(3)), resultType);
                continue;
            }
            if (!(resultType instanceof PrimitiveType) || ((PrimitiveType)resultType).getKind() != PrimitiveType.Kind.BOOLEAN || !name.startsWith("is")) continue;
            members.put(StringUtils.decapitalize((String)name.substring(2)), resultType);
        }
        if (type instanceof ClassDeclaration && ((ClassDeclaration)type).getSuperclass() != null) {
            TypeModeler.collectExceptionProperties((TypeMirror)((ClassDeclaration)type).getSuperclass(), members);
        }
        for (InterfaceType intfType : TypeModeler.getSuperinterfaces(type)) {
            TypeModeler.collectExceptionProperties((TypeMirror)intfType, members);
        }
    }

    static {
        skipProperties.add("getCause");
        skipProperties.add("getLocalizedMessage");
        skipProperties.add("getClass");
        skipProperties.add("getStackTrace");
    }
}

