/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wsdl.parser;

import com.sun.tools.ws.util.xml.XmlUtil;
import com.sun.tools.ws.wsdl.document.soap.SOAPAddress;
import com.sun.tools.ws.wsdl.document.soap.SOAPBinding;
import com.sun.tools.ws.wsdl.document.soap.SOAPBody;
import com.sun.tools.ws.wsdl.document.soap.SOAPConstants;
import com.sun.tools.ws.wsdl.document.soap.SOAPFault;
import com.sun.tools.ws.wsdl.document.soap.SOAPHeader;
import com.sun.tools.ws.wsdl.document.soap.SOAPHeaderFault;
import com.sun.tools.ws.wsdl.document.soap.SOAPOperation;
import com.sun.tools.ws.wsdl.document.soap.SOAPStyle;
import com.sun.tools.ws.wsdl.document.soap.SOAPUse;
import com.sun.tools.ws.wsdl.framework.Extensible;
import com.sun.tools.ws.wsdl.framework.Extension;
import com.sun.tools.ws.wsdl.framework.ParserContext;
import com.sun.tools.ws.wsdl.framework.WriterContext;
import com.sun.tools.ws.wsdl.parser.ExtensionHandlerBase;
import com.sun.tools.ws.wsdl.parser.Util;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class SOAPExtensionHandler
extends ExtensionHandlerBase {
    public String getNamespaceURI() {
        return "http://schemas.xmlsoap.org/wsdl/soap/";
    }

    protected boolean handleDefinitionsExtension(ParserContext context, Extensible parent, Element e) {
        Util.fail("parsing.invalidExtensionElement", e.getTagName(), e.getNamespaceURI());
        return false;
    }

    protected boolean handleTypesExtension(ParserContext context, Extensible parent, Element e) {
        Util.fail("parsing.invalidExtensionElement", e.getTagName(), e.getNamespaceURI());
        return false;
    }

    protected SOAPBinding getSOAPBinding() {
        return new SOAPBinding();
    }

    protected boolean handleBindingExtension(ParserContext context, Extensible parent, Element e) {
        if (XmlUtil.matchesTagNS(e, this.getBindingQName())) {
            context.push();
            context.registerNamespaces(e);
            SOAPBinding binding = this.getSOAPBinding();
            String transport = Util.getRequiredAttribute(e, "transport");
            binding.setTransport(transport);
            String style = XmlUtil.getAttributeOrNull((Element)e, (String)"style");
            if (style != null) {
                if (style.equals("rpc")) {
                    binding.setStyle(SOAPStyle.RPC);
                } else if (style.equals("document")) {
                    binding.setStyle(SOAPStyle.DOCUMENT);
                } else {
                    Util.fail("parsing.invalidAttributeValue", "style", style);
                }
            }
            parent.addExtension(binding);
            context.pop();
            context.fireDoneParsingEntity(this.getBindingQName(), binding);
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", e.getTagName(), e.getNamespaceURI());
        return false;
    }

    protected boolean handleOperationExtension(ParserContext context, Extensible parent, Element e) {
        if (XmlUtil.matchesTagNS(e, this.getOperationQName())) {
            String style;
            context.push();
            context.registerNamespaces(e);
            SOAPOperation operation = new SOAPOperation();
            String soapAction = XmlUtil.getAttributeOrNull((Element)e, (String)"soapAction");
            if (soapAction != null) {
                operation.setSOAPAction(soapAction);
            }
            if ((style = XmlUtil.getAttributeOrNull((Element)e, (String)"style")) != null) {
                if (style.equals("rpc")) {
                    operation.setStyle(SOAPStyle.RPC);
                } else if (style.equals("document")) {
                    operation.setStyle(SOAPStyle.DOCUMENT);
                } else {
                    Util.fail("parsing.invalidAttributeValue", "style", style);
                }
            }
            parent.addExtension(operation);
            context.pop();
            context.fireDoneParsingEntity(this.getOperationQName(), operation);
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", e.getTagName(), e.getNamespaceURI());
        return false;
    }

    protected boolean handleInputExtension(ParserContext context, Extensible parent, Element e) {
        return this.handleInputOutputExtension(context, parent, e);
    }

    protected boolean handleOutputExtension(ParserContext context, Extensible parent, Element e) {
        return this.handleInputOutputExtension(context, parent, e);
    }

    protected boolean handleMIMEPartExtension(ParserContext context, Extensible parent, Element e) {
        return this.handleInputOutputExtension(context, parent, e);
    }

    protected boolean handleInputOutputExtension(ParserContext context, Extensible parent, Element e) {
        if (XmlUtil.matchesTagNS(e, this.getBodyQName())) {
            String parts;
            String encodingStyle;
            String namespace;
            context.push();
            context.registerNamespaces(e);
            SOAPBody body = new SOAPBody();
            String use = XmlUtil.getAttributeOrNull((Element)e, (String)"use");
            if (use != null) {
                if (use.equals("literal")) {
                    body.setUse(SOAPUse.LITERAL);
                } else if (use.equals("encoded")) {
                    body.setUse(SOAPUse.ENCODED);
                } else {
                    Util.fail("parsing.invalidAttributeValue", "use", use);
                }
            }
            if ((namespace = XmlUtil.getAttributeOrNull((Element)e, (String)"namespace")) != null) {
                body.setNamespace(namespace);
            }
            if ((encodingStyle = XmlUtil.getAttributeOrNull((Element)e, (String)"encodingStyle")) != null) {
                body.setEncodingStyle(encodingStyle);
            }
            if ((parts = XmlUtil.getAttributeOrNull((Element)e, (String)"parts")) != null) {
                body.setParts(parts);
            }
            parent.addExtension(body);
            context.pop();
            context.fireDoneParsingEntity(this.getBodyQName(), body);
            return true;
        }
        if (XmlUtil.matchesTagNS(e, this.getHeaderQName())) {
            Element e2;
            String messageAttr;
            String part;
            String encodingStyle;
            String namespace;
            context.push();
            context.registerNamespaces(e);
            SOAPHeader header = new SOAPHeader();
            String use = XmlUtil.getAttributeOrNull((Element)e, (String)"use");
            if (use != null) {
                if (use.equals("literal")) {
                    header.setUse(SOAPUse.LITERAL);
                } else if (use.equals("encoded")) {
                    header.setUse(SOAPUse.ENCODED);
                } else {
                    Util.fail("parsing.invalidAttributeValue", "use", use);
                }
            }
            if ((namespace = XmlUtil.getAttributeOrNull((Element)e, (String)"namespace")) != null) {
                header.setNamespace(namespace);
            }
            if ((encodingStyle = XmlUtil.getAttributeOrNull((Element)e, (String)"encodingStyle")) != null) {
                header.setEncodingStyle(encodingStyle);
            }
            if ((part = XmlUtil.getAttributeOrNull((Element)e, (String)"part")) != null) {
                header.setPart(part);
            }
            if ((messageAttr = XmlUtil.getAttributeOrNull((Element)e, (String)"message")) != null) {
                header.setMessage(context.translateQualifiedName(messageAttr));
            }
            Iterator iter = XmlUtil.getAllChildren((Element)e);
            while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
                if (XmlUtil.matchesTagNS(e2, this.getHeaderfaultQName())) {
                    String messageAttr2;
                    String part2;
                    String encodingStyle2;
                    String namespace2;
                    context.push();
                    context.registerNamespaces(e);
                    SOAPHeaderFault headerfault = new SOAPHeaderFault();
                    String use2 = XmlUtil.getAttributeOrNull((Element)e2, (String)"use");
                    if (use2 != null) {
                        if (use2.equals("literal")) {
                            headerfault.setUse(SOAPUse.LITERAL);
                        } else if (use.equals("encoded")) {
                            headerfault.setUse(SOAPUse.ENCODED);
                        } else {
                            Util.fail("parsing.invalidAttributeValue", "use", use2);
                        }
                    }
                    if ((namespace2 = XmlUtil.getAttributeOrNull((Element)e2, (String)"namespace")) != null) {
                        headerfault.setNamespace(namespace2);
                    }
                    if ((encodingStyle2 = XmlUtil.getAttributeOrNull((Element)e2, (String)"encodingStyle")) != null) {
                        headerfault.setEncodingStyle(encodingStyle2);
                    }
                    if ((part2 = XmlUtil.getAttributeOrNull((Element)e2, (String)"part")) != null) {
                        headerfault.setPart(part2);
                    }
                    if ((messageAttr2 = XmlUtil.getAttributeOrNull((Element)e2, (String)"message")) != null) {
                        headerfault.setMessage(context.translateQualifiedName(messageAttr2));
                    }
                    header.add(headerfault);
                    context.pop();
                    continue;
                }
                Util.fail("parsing.invalidElement", e2.getTagName(), e2.getNamespaceURI());
            }
            parent.addExtension(header);
            context.pop();
            context.fireDoneParsingEntity(this.getHeaderQName(), header);
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", e.getTagName(), e.getNamespaceURI());
        return false;
    }

    protected boolean handleFaultExtension(ParserContext context, Extensible parent, Element e) {
        if (XmlUtil.matchesTagNS(e, this.getFaultQName())) {
            String encodingStyle;
            String namespace;
            String use;
            context.push();
            context.registerNamespaces(e);
            SOAPFault fault = new SOAPFault();
            String name = XmlUtil.getAttributeOrNull((Element)e, (String)"name");
            if (name != null) {
                fault.setName(name);
            }
            if ((use = XmlUtil.getAttributeOrNull((Element)e, (String)"use")) != null) {
                if (use.equals("literal")) {
                    fault.setUse(SOAPUse.LITERAL);
                } else if (use.equals("encoded")) {
                    fault.setUse(SOAPUse.ENCODED);
                } else {
                    Util.fail("parsing.invalidAttributeValue", "use", use);
                }
            }
            if ((namespace = XmlUtil.getAttributeOrNull((Element)e, (String)"namespace")) != null) {
                fault.setNamespace(namespace);
            }
            if ((encodingStyle = XmlUtil.getAttributeOrNull((Element)e, (String)"encodingStyle")) != null) {
                fault.setEncodingStyle(encodingStyle);
            }
            parent.addExtension(fault);
            context.pop();
            context.fireDoneParsingEntity(this.getFaultQName(), fault);
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", e.getTagName(), e.getNamespaceURI());
        return false;
    }

    protected boolean handleServiceExtension(ParserContext context, Extensible parent, Element e) {
        Util.fail("parsing.invalidExtensionElement", e.getTagName(), e.getNamespaceURI());
        return false;
    }

    protected boolean handlePortExtension(ParserContext context, Extensible parent, Element e) {
        if (XmlUtil.matchesTagNS(e, this.getAddressQName())) {
            context.push();
            context.registerNamespaces(e);
            SOAPAddress address = new SOAPAddress();
            String location = Util.getRequiredAttribute(e, "location");
            address.setLocation(location);
            parent.addExtension(address);
            context.pop();
            context.fireDoneParsingEntity(this.getAddressQName(), address);
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", e.getTagName(), e.getNamespaceURI());
        return false;
    }

    public void doHandleExtension(WriterContext context, Extension extension) throws IOException {
        if (extension instanceof SOAPAddress) {
            SOAPAddress address = (SOAPAddress)extension;
            context.writeStartTag(address.getElementName());
            context.writeAttribute("location", address.getLocation());
            context.writeEndTag(address.getElementName());
        } else if (extension instanceof SOAPBinding) {
            SOAPBinding binding = (SOAPBinding)extension;
            context.writeStartTag(binding.getElementName());
            context.writeAttribute("transport", binding.getTransport());
            String style = binding.getStyle() == null ? null : (binding.getStyle() == SOAPStyle.DOCUMENT ? "document" : "rpc");
            context.writeAttribute("style", style);
            context.writeEndTag(binding.getElementName());
        } else if (extension instanceof SOAPBody) {
            SOAPBody body = (SOAPBody)extension;
            context.writeStartTag(body.getElementName());
            context.writeAttribute("encodingStyle", body.getEncodingStyle());
            context.writeAttribute("parts", body.getParts());
            String use = body.getUse() == null ? null : (body.getUse() == SOAPUse.LITERAL ? "literal" : "encoded");
            context.writeAttribute("use", use);
            context.writeAttribute("namespace", body.getNamespace());
            context.writeEndTag(body.getElementName());
        } else if (extension instanceof SOAPFault) {
            SOAPFault fault = (SOAPFault)extension;
            context.writeStartTag(fault.getElementName());
            context.writeAttribute("name", fault.getName());
            context.writeAttribute("encodingStyle", fault.getEncodingStyle());
            String use = fault.getUse() == null ? null : (fault.getUse() == SOAPUse.LITERAL ? "literal" : "encoded");
            context.writeAttribute("use", use);
            context.writeAttribute("namespace", fault.getNamespace());
            context.writeEndTag(fault.getElementName());
        } else if (extension instanceof SOAPHeader) {
            SOAPHeader header = (SOAPHeader)extension;
            context.writeStartTag(header.getElementName());
            context.writeAttribute("message", header.getMessage());
            context.writeAttribute("part", header.getPart());
            context.writeAttribute("encodingStyle", header.getEncodingStyle());
            String use = header.getUse() == null ? null : (header.getUse() == SOAPUse.LITERAL ? "literal" : "encoded");
            context.writeAttribute("use", use);
            context.writeAttribute("namespace", header.getNamespace());
            context.writeEndTag(header.getElementName());
        } else if (extension instanceof SOAPHeaderFault) {
            SOAPHeaderFault headerfault = (SOAPHeaderFault)extension;
            context.writeStartTag(headerfault.getElementName());
            context.writeAttribute("message", headerfault.getMessage());
            context.writeAttribute("part", headerfault.getPart());
            context.writeAttribute("encodingStyle", headerfault.getEncodingStyle());
            String use = headerfault.getUse() == null ? null : (headerfault.getUse() == SOAPUse.LITERAL ? "literal" : "encoded");
            context.writeAttribute("use", use);
            context.writeAttribute("namespace", headerfault.getNamespace());
            context.writeEndTag(headerfault.getElementName());
        } else if (extension instanceof SOAPOperation) {
            SOAPOperation operation = (SOAPOperation)extension;
            context.writeStartTag(operation.getElementName());
            context.writeAttribute("soapAction", operation.getSOAPAction());
            String style = operation.getStyle() == null ? null : (operation.isDocument() ? "document" : "rpc");
            context.writeAttribute("style", style);
            context.writeEndTag(operation.getElementName());
        } else {
            throw new IllegalArgumentException();
        }
    }

    protected boolean handlePortTypeExtension(ParserContext context, Extensible parent, Element e) {
        Util.fail("parsing.invalidExtensionElement", e.getTagName(), e.getNamespaceURI());
        return false;
    }

    protected QName getBodyQName() {
        return SOAPConstants.QNAME_BODY;
    }

    protected QName getHeaderQName() {
        return SOAPConstants.QNAME_HEADER;
    }

    protected QName getHeaderfaultQName() {
        return SOAPConstants.QNAME_HEADERFAULT;
    }

    protected QName getOperationQName() {
        return SOAPConstants.QNAME_OPERATION;
    }

    protected QName getFaultQName() {
        return SOAPConstants.QNAME_FAULT;
    }

    protected QName getAddressQName() {
        return SOAPConstants.QNAME_ADDRESS;
    }

    protected QName getBindingQName() {
        return SOAPConstants.QNAME_BINDING;
    }
}

