/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trpc.logger.admin;

import com.tencent.trpc.core.logger.LoggerLevel;
import com.tencent.trpc.logger.admin.AbstractLoggerProcessUnit;
import com.tencent.trpc.logger.admin.LoggerLevelInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.LoggerConfig;

public class Log4j2LoggerProcessUnit
extends AbstractLoggerProcessUnit {
    public static final String ROOT_LOGGER_NAME = "ROOT";

    Log4j2LoggerProcessUnit() {
    }

    @Override
    public void init() {
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        Map loggerConfigMap = loggerContext.getConfiguration().getLoggers();
        for (LoggerConfig loggerConfig : loggerConfigMap.values()) {
            String loggerName = loggerConfig.getName();
            if (StringUtils.isBlank((CharSequence)loggerName)) {
                loggerName = ROOT_LOGGER_NAME;
            }
            this.addLogger(loggerName, loggerConfig);
        }
        if (!this.getLoggers().containsKey(ROOT_LOGGER_NAME)) {
            Logger rootLogger = LogManager.getRootLogger();
            this.addLogger(ROOT_LOGGER_NAME, rootLogger);
        }
    }

    @Override
    public List<LoggerLevelInfo> getLoggerLevelInfo() {
        Map<String, Object> loggers = this.getLoggers();
        ArrayList<LoggerLevelInfo> loggerLevelInfoList = new ArrayList<LoggerLevelInfo>(loggers.size());
        for (Map.Entry<String, Object> loggerEntry : loggers.entrySet()) {
            LoggerConfig loggerConfig = (LoggerConfig)loggerEntry.getValue();
            loggerLevelInfoList.add(new LoggerLevelInfo(loggerEntry.getKey(), loggerConfig.getLevel().name()));
        }
        return loggerLevelInfoList;
    }

    @Override
    public String setLoggerLevel(String loggerName, LoggerLevel level) {
        LoggerConfig loggerConfig = (LoggerConfig)this.getLogger(loggerName);
        if (loggerConfig == null) {
            return null;
        }
        Level currentLevel = loggerConfig.getLevel();
        Level newLevel = Level.toLevel((String)level.name(), (Level)currentLevel);
        loggerConfig.setLevel(newLevel);
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        loggerContext.updateLoggers();
        return currentLevel.name();
    }
}

