/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trpc.logger.admin;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import com.tencent.trpc.core.logger.LoggerLevel;
import com.tencent.trpc.logger.admin.AbstractLoggerProcessUnit;
import com.tencent.trpc.logger.admin.LoggerLevelInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.LoggerFactory;

public class LogbackLoggerProcessUnit
extends AbstractLoggerProcessUnit {
    LogbackLoggerProcessUnit() {
    }

    @Override
    public void init() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        List loggerList = loggerContext.getLoggerList();
        for (Logger logger : loggerList) {
            if (logger.getLevel() == null) continue;
            this.addLogger(logger.getName(), logger);
        }
        Logger rootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        this.addLogger(rootLogger.getName(), rootLogger);
    }

    @Override
    public List<LoggerLevelInfo> getLoggerLevelInfo() {
        Map<String, Object> loggers = this.getLoggers();
        ArrayList<LoggerLevelInfo> loggerLevelInfoList = new ArrayList<LoggerLevelInfo>(loggers.size());
        for (Map.Entry<String, Object> loggerEntry : loggers.entrySet()) {
            Logger logger = (Logger)loggerEntry.getValue();
            loggerLevelInfoList.add(new LoggerLevelInfo(loggerEntry.getKey(), logger.getLevel().toString()));
        }
        return loggerLevelInfoList;
    }

    @Override
    public String setLoggerLevel(String loggerName, LoggerLevel level) {
        Logger logger = (Logger)this.getLogger(loggerName);
        if (logger == null) {
            return null;
        }
        Level currentLevel = logger.getLevel();
        Level newLevel = Level.toLevel((String)level.name(), (Level)currentLevel);
        logger.setLevel(newLevel);
        return currentLevel.levelStr;
    }
}

