/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trpc.logger.admin;

import com.tencent.trpc.logger.admin.Log4j2LoggerProcessUnit;
import com.tencent.trpc.logger.admin.LogbackLoggerProcessUnit;
import com.tencent.trpc.logger.admin.LoggerFactoryEnum;
import com.tencent.trpc.logger.admin.LoggerProcessUnit;
import com.tencent.trpc.logger.admin.UnSupportLoggerProcessUnit;
import org.slf4j.LoggerFactory;

public class LoggerProcessUnitFactory {
    private static LoggerProcessUnit loggerProcessUnit;

    public static synchronized LoggerProcessUnit getLoggerProcessUnit() {
        if (loggerProcessUnit != null) {
            return loggerProcessUnit;
        }
        String loggerFactoryClassName = LoggerFactory.getILoggerFactory().getClass().getName();
        LoggerFactoryEnum loggerFactoryEnum = LoggerFactoryEnum.getLoggerFactoryEnum(loggerFactoryClassName);
        switch (loggerFactoryEnum) {
            case LOG4J2_FACTORY: {
                loggerProcessUnit = new Log4j2LoggerProcessUnit();
                break;
            }
            case LOGBACK_FACTORY: {
                loggerProcessUnit = new LogbackLoggerProcessUnit();
                break;
            }
            case UN_SUPPORT_FACTORY: {
                loggerProcessUnit = new UnSupportLoggerProcessUnit();
                break;
            }
        }
        loggerProcessUnit.init();
        return loggerProcessUnit;
    }
}

