/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trpc.registry.nacos;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.tencent.trpc.core.common.config.PluginConfig;
import com.tencent.trpc.core.exception.TRpcExtensionException;
import com.tencent.trpc.core.extension.Extension;
import com.tencent.trpc.core.logger.Logger;
import com.tencent.trpc.core.logger.LoggerFactory;
import com.tencent.trpc.core.registry.RegisterInfo;
import com.tencent.trpc.registry.center.AbstractFailedRetryRegistryCenter;
import com.tencent.trpc.registry.center.NotifyListener;
import com.tencent.trpc.registry.nacos.config.NacosRegistryCenterConfig;
import com.tencent.trpc.registry.nacos.util.NacosNamingServiceUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;

@Extension(value="nacos")
public class NacosRegistryCenter
extends AbstractFailedRetryRegistryCenter {
    private static final Logger logger = LoggerFactory.getLogger(NacosRegistryCenter.class);
    private NamingService namingService;
    private NacosRegistryCenterConfig config;

    public void setPluginConfig(PluginConfig pluginConfig) throws TRpcExtensionException {
        super.setPluginConfig(pluginConfig);
        this.config = new NacosRegistryCenterConfig(pluginConfig);
    }

    public void init() throws TRpcExtensionException {
        this.namingService = NacosNamingServiceUtils.createNamingService(this.config);
    }

    public void doRegister(RegisterInfo registerInfo) {
        this.execute(namingService -> {
            Instance instance = this.createInstance(registerInfo);
            namingService.registerInstance(registerInfo.getServiceName(), registerInfo.getGroup(), instance);
        });
    }

    public void doUnregister(RegisterInfo registerInfo) {
        this.execute(namingService -> {
            Instance instance = this.createInstance(registerInfo);
            namingService.deregisterInstance(registerInfo.getServiceName(), registerInfo.getGroup(), instance.getIp(), instance.getPort());
        });
    }

    public void doSubscribe(RegisterInfo registerInfo, NotifyListener notifyListener) {
        this.execute(namingService -> {
            List instances = namingService.getAllInstances(registerInfo.getServiceName(), registerInfo.getGroup());
            List<RegisterInfo> registerInfos = NacosNamingServiceUtils.convert(instances, registerInfo);
            this.notify(registerInfo, notifyListener, registerInfos);
            this.subscribeEventListener(registerInfo, notifyListener);
        });
    }

    public void doUnsubscribe(RegisterInfo registerInfo, NotifyListener notifyListener) {
    }

    public boolean isAvailable() {
        return "UP".equals(this.namingService.getServerStatus());
    }

    private Instance createInstance(RegisterInfo registerInfo) {
        Instance instance = new Instance();
        instance.setInstanceId(NacosRegistryCenter.getInstanceId(registerInfo));
        instance.setServiceName(registerInfo.getServiceName());
        instance.setIp(registerInfo.getHost());
        instance.setPort(registerInfo.getPort());
        instance.setMetadata(Collections.singletonMap("url", RegisterInfo.encode((RegisterInfo)registerInfo)));
        instance.setEnabled(MapUtils.getBooleanValue((Map)registerInfo.getParameters(), (Object)"is_enable", (boolean)Boolean.TRUE));
        instance.setHealthy(MapUtils.getBooleanValue((Map)registerInfo.getParameters(), (Object)"is_healthy", (boolean)Boolean.TRUE));
        return instance;
    }

    private static String getInstanceId(RegisterInfo registerInfo) {
        return String.join((CharSequence)"-", registerInfo.getServiceName(), registerInfo.getHost(), String.valueOf(registerInfo.getPort()));
    }

    private void subscribeEventListener(RegisterInfo registerInfo, NotifyListener listener) throws NacosException {
        EventListener eventListener = event -> {
            if (event instanceof NamingEvent) {
                NamingEvent e = (NamingEvent)event;
                List instances = e.getInstances();
                List<RegisterInfo> list = NacosNamingServiceUtils.convert(instances, registerInfo);
            }
        };
        this.namingService.subscribe(registerInfo.getServiceName(), registerInfo.getGroup(), eventListener);
    }

    private void execute(NamingServiceCallback callback) {
        try {
            callback.callback(this.namingService);
        }
        catch (NacosException e) {
            logger.error("callback execute error," + e.getErrMsg(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void setNamingService(NamingService namingService) {
        this.namingService = namingService;
    }

    static interface NamingServiceCallback {
        public void callback(NamingService var1) throws NacosException;
    }
}

