/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trpc.registry.nacos.config;

import com.tencent.trpc.core.common.config.PluginConfig;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.collections4.MapUtils;

public class NacosRegistryCenterConfig {
    private final Map<String, Object> parameters;

    public NacosRegistryCenterConfig(PluginConfig pluginConfig) {
        Objects.requireNonNull(pluginConfig, "the pluginConfig can't be null");
        if (MapUtils.isEmpty((Map)pluginConfig.getProperties())) {
            throw new IllegalArgumentException("the pluginConfig properties can't be empty");
        }
        this.parameters = pluginConfig.getProperties();
    }

    public Map<String, String> getParameters(Predicate<String> nameToSelect) {
        LinkedHashMap<String, String> selectedParameters = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Object> entry : this.getParameters().entrySet()) {
            String name = entry.getKey();
            if (!nameToSelect.test(name)) continue;
            selectedParameters.put(name, String.valueOf(entry.getValue()));
        }
        return Collections.unmodifiableMap(selectedParameters);
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }
}

