/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trpc.registry.nacos.util;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.PropertyKeyConst;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.google.common.collect.Lists;
import com.tencent.trpc.core.logger.Logger;
import com.tencent.trpc.core.logger.LoggerFactory;
import com.tencent.trpc.core.registry.RegisterInfo;
import com.tencent.trpc.registry.nacos.config.NacosRegistryCenterConfig;
import com.tencent.trpc.registry.nacos.util.StringConstantFieldValuePredicateUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class NacosNamingServiceUtils {
    private static final Logger logger = LoggerFactory.getLogger(NacosNamingServiceUtils.class);

    public static List<RegisterInfo> convert(List<Instance> services, RegisterInfo consumerRegisterInfo) {
        if (CollectionUtils.isEmpty(services)) {
            return Lists.newArrayList((Object[])new RegisterInfo[]{consumerRegisterInfo.clone()});
        }
        return services.stream().filter(Objects::nonNull).map(Instance::getMetadata).filter(m -> m != null && m.containsKey("url")).map(m -> (String)m.get("url")).map(RegisterInfo::decode).filter(deRegisterInfo -> deRegisterInfo.getServiceName().equals(consumerRegisterInfo.getServiceName())).collect(Collectors.toList());
    }

    public static NamingService createNamingService(NacosRegistryCenterConfig config) {
        NamingService namingService;
        Properties nacosProperties = NacosNamingServiceUtils.buildNacosProperties(config);
        try {
            namingService = NacosFactory.createNamingService((Properties)nacosProperties);
        }
        catch (NacosException e) {
            logger.error("nacos createNamingService error" + e.getErrMsg(), (Throwable)e);
            throw new IllegalStateException(e);
        }
        return namingService;
    }

    private static Properties buildNacosProperties(NacosRegistryCenterConfig config) {
        String addresses = MapUtils.getString(config.getParameters(), (Object)"addresses", (String)"127.0.0.1:8848");
        Properties properties = new Properties();
        properties.put("serverAddr", addresses);
        Map<String, String> parameters = config.getParameters(StringConstantFieldValuePredicateUtils.of(PropertyKeyConst.class));
        properties.putAll(parameters);
        NacosNamingServiceUtils.setNamingLoadCacheStartParam(config, properties);
        return properties;
    }

    private static void setNamingLoadCacheStartParam(NacosRegistryCenterConfig config, Properties properties) {
        String propertyValue = MapUtils.getString(config.getParameters(), (Object)"namingLoadCacheAtStart", (String)"true");
        properties.setProperty("namingLoadCacheAtStart", propertyValue);
    }
}

