/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trpc.registry.nacos.util;

import com.tencent.trpc.core.logger.Logger;
import com.tencent.trpc.core.logger.LoggerFactory;
import com.tencent.trpc.core.utils.ClassUtils;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class StringConstantFieldValuePredicateUtils
implements Predicate<String> {
    private static final Logger logger = LoggerFactory.getLogger(StringConstantFieldValuePredicateUtils.class);
    private final Set<String> constantFieldValues;

    public StringConstantFieldValuePredicateUtils(Class<?> targetClass) {
        this.constantFieldValues = this.getConstantFieldValues(targetClass);
    }

    public static Predicate<String> of(Class<?> targetClass) {
        return new StringConstantFieldValuePredicateUtils(targetClass);
    }

    private Set<String> getConstantFieldValues(Class<?> targetClass) {
        return ClassUtils.getConstantValues(targetClass).stream().map(String.class::cast).collect(Collectors.toSet());
    }

    @Override
    public boolean test(String s) {
        return this.constantFieldValues.contains(s);
    }
}

