/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trpc.selector.nacos;

import com.tencent.trpc.core.exception.TRpcException;
import com.tencent.trpc.core.exception.TRpcExtensionException;
import com.tencent.trpc.core.extension.DisposableExtension;
import com.tencent.trpc.core.extension.Extension;
import com.tencent.trpc.core.extension.ExtensionLoader;
import com.tencent.trpc.core.extension.InitializingExtension;
import com.tencent.trpc.core.logger.Logger;
import com.tencent.trpc.core.logger.LoggerFactory;
import com.tencent.trpc.core.registry.spi.Registry;
import com.tencent.trpc.core.rpc.Request;
import com.tencent.trpc.core.selector.ServiceId;
import com.tencent.trpc.core.selector.ServiceInstance;
import com.tencent.trpc.core.selector.loadbalance.support.RandomLoadBalance;
import com.tencent.trpc.core.selector.spi.Discovery;
import com.tencent.trpc.core.selector.spi.Selector;
import com.tencent.trpc.registry.center.RegistryCenter;
import com.tencent.trpc.registry.discovery.RegistryDiscovery;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;

@Extension(value="nacos")
public class NacosSelector
implements Selector,
InitializingExtension,
DisposableExtension {
    private static final Logger logger = LoggerFactory.getLogger(NacosSelector.class);
    public static final String NAME = "nacos";
    private RandomLoadBalance loadBalance;
    private final Map<String, Discovery> serviceNameToDiscovery = new ConcurrentHashMap<String, Discovery>();
    private RegistryCenter registryCenter;

    public void init() throws TRpcExtensionException {
        this.registryCenter = (RegistryCenter)ExtensionLoader.getExtensionLoader(Registry.class).getExtension(NAME);
        this.loadBalance = new RandomLoadBalance();
    }

    public CompletionStage<ServiceInstance> asyncSelectOne(ServiceId serviceId, Request request) {
        try {
            Discovery discovery = this.serviceNameToDiscovery.computeIfAbsent(serviceId.getServiceName(), n -> this.subscribe(serviceId));
            return CompletableFuture.supplyAsync(() -> this.loadBalance.select(discovery.list(serviceId), request));
        }
        catch (Exception ex) {
            logger.error("[NacosSelector] asyncSelectOne error", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    private Discovery subscribe(ServiceId serviceId) {
        return new RegistryDiscovery(serviceId, this.registryCenter);
    }

    public CompletionStage<List<ServiceInstance>> asyncSelectAll(ServiceId serviceId, Request request) {
        Discovery discovery = this.serviceNameToDiscovery.computeIfAbsent(serviceId.getServiceName(), n -> this.subscribe(serviceId));
        return CompletableFuture.supplyAsync(() -> discovery.list(serviceId));
    }

    public void report(ServiceInstance serviceInstance, int code, long costMs) throws TRpcException {
    }

    public void destroy() throws TRpcExtensionException {
        this.serviceNameToDiscovery.clear();
    }

    public void setRegistryCenter(RegistryCenter registryCenter) {
        this.registryCenter = registryCenter;
    }

    public void setLoadBalance(RandomLoadBalance loadBalance) {
        this.loadBalance = loadBalance;
    }
}

