/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trpc.transport.http;

import com.tencent.trpc.core.common.LifecycleBase;
import com.tencent.trpc.core.common.config.ProtocolConfig;
import com.tencent.trpc.core.exception.LifecycleException;
import com.tencent.trpc.core.exception.TransportException;
import com.tencent.trpc.core.logger.Logger;
import com.tencent.trpc.core.logger.LoggerFactory;
import com.tencent.trpc.transport.http.HttpExecutor;
import com.tencent.trpc.transport.http.HttpServer;
import java.net.InetSocketAddress;
import java.util.Objects;

public abstract class AbstractHttpServer
implements HttpServer {
    private static final Logger logger = LoggerFactory.getLogger(AbstractHttpServer.class);
    protected final String name;
    protected final InetSocketAddress bindAddress;
    protected LifecycleObj lifecycleObj = new LifecycleObj();
    private ProtocolConfig config;
    private HttpExecutor executor;

    public AbstractHttpServer(ProtocolConfig config, HttpExecutor executor) {
        this.name = this.getClass().getName();
        this.bindAddress = config.toInetSocketAddress();
        this.config = Objects.requireNonNull(config, "config is null");
        this.executor = executor;
    }

    @Override
    public void open() throws TransportException {
        try {
            this.lifecycleObj.start();
        }
        catch (Exception ex) {
            Throwable parsedEx = LifecycleException.parseSourceException((Exception)ex);
            if (parsedEx instanceof TransportException) {
                throw (TransportException)parsedEx;
            }
            throw new TransportException("Open http server transport(" + this.config.toSimpleString() + ") exception", parsedEx);
        }
    }

    @Override
    public boolean isClosed() {
        return this.lifecycleObj.isFailed() || this.lifecycleObj.isStopping() || this.lifecycleObj.isStopped();
    }

    @Override
    public void close() {
        try {
            this.lifecycleObj.stop();
        }
        catch (Exception ex) {
            logger.error("Close server transport exception", (Throwable)ex);
        }
    }

    protected abstract void doOpen() throws Exception;

    protected abstract void doClose();

    public String toString() {
        return "{name=" + this.name + ", config=" + this.config + ", bindip=" + this.bindAddress + "}";
    }

    @Override
    public ProtocolConfig getConfig() {
        return this.config;
    }

    public void setConfig(ProtocolConfig config) {
        this.config = config;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.bindAddress;
    }

    @Override
    public HttpExecutor getExecutor() {
        return this.executor;
    }

    public void setExecutor(HttpExecutor executor) {
        this.executor = executor;
    }

    protected class LifecycleObj
    extends LifecycleBase {
        protected LifecycleObj() {
        }

        protected void initInternal() throws Exception {
            super.initInternal();
        }

        protected void startInternal() throws Exception {
            super.startInternal();
            logger.info(">>>Http server transport binding(name={},ip={})", new Object[]{AbstractHttpServer.this.name, AbstractHttpServer.this.bindAddress});
            AbstractHttpServer.this.doOpen();
            logger.info(">>>Http server transport binded(name={},ip={})", new Object[]{AbstractHttpServer.this.name, AbstractHttpServer.this.bindAddress});
        }

        protected void stopInternal() throws Exception {
            super.stopInternal();
            logger.info(">>>Http server transport closing(name={},serverip={})", new Object[]{AbstractHttpServer.this.name, AbstractHttpServer.this.bindAddress});
            try {
                AbstractHttpServer.this.doClose();
            }
            catch (Throwable e) {
                logger.error(String.format("Http server transport(name=%s,ip=%s), close failed", AbstractHttpServer.this.name, AbstractHttpServer.this.bindAddress), e);
            }
            logger.info("<<<Server transport closed(name={},serverip={})", new Object[]{AbstractHttpServer.this.name, AbstractHttpServer.this.bindAddress});
        }

        public String toString() {
            return AbstractHttpServer.this.toString();
        }
    }
}

