/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trpc.transport.http;

import com.tencent.trpc.transport.http.HttpExecutor;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ExecutorDispatcher
extends HttpServlet {
    public static final long serialVersionUID = 6958185211125599194L;
    private static final ConcurrentMap<Integer, HttpExecutor> EXECUTORS = new ConcurrentHashMap<Integer, HttpExecutor>();

    public static void addHttpExecutor(int port, HttpExecutor executor) {
        EXECUTORS.put(port, executor);
    }

    public static void removeHttpExecutor(int port) {
        EXECUTORS.remove(port);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpExecutor executor = (HttpExecutor)EXECUTORS.get(request.getLocalPort());
        if (executor == null) {
            response.sendError(404, "HttpExecutor is closed: port is:" + request.getLocalPort() + ".");
        } else {
            executor.execute(request, response);
        }
    }
}

