/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trpc.transport.http.support.jetty;

import com.tencent.trpc.core.common.config.ProtocolConfig;
import com.tencent.trpc.transport.http.HttpExecutor;
import com.tencent.trpc.transport.http.support.jetty.JettyHttpsServer;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class JettyHttp2Server
extends JettyHttpsServer {
    public JettyHttp2Server(ProtocolConfig config, HttpExecutor executor) {
        super(config, executor);
    }

    @Override
    protected ServerConnector buildServerConnector(Server server, ProtocolConfig config, SslContextFactory sslContextFactory, HttpConfiguration httpConfig, HttpConfiguration httpsConfig) {
        HTTP2ServerConnectionFactory h2 = new HTTP2ServerConnectionFactory(httpsConfig);
        ALPNServerConnectionFactory alpn = new ALPNServerConnectionFactory(new String[0]);
        alpn.setDefaultProtocol("h2");
        SslConnectionFactory ssl = new SslConnectionFactory(sslContextFactory, alpn.getProtocol());
        ServerConnector http2Connector = new ServerConnector(server, new ConnectionFactory[]{ssl, alpn, h2, new HttpConnectionFactory(httpConfig)});
        http2Connector.setHost(config.getIp());
        http2Connector.setPort(config.getPort());
        http2Connector.setAcceptQueueSize(config.getMaxConns());
        return http2Connector;
    }
}

