/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trpc.transport.http.support.jetty;

import com.tencent.trpc.core.common.config.ProtocolConfig;
import com.tencent.trpc.core.extension.Extension;
import com.tencent.trpc.transport.http.HttpExecutor;
import com.tencent.trpc.transport.http.support.jetty.JettyHttpServer;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;

@Extension(value="jetty")
public class JettyHttp2cServer
extends JettyHttpServer {
    public JettyHttp2cServer(ProtocolConfig config, HttpExecutor executor) {
        super(config, executor);
    }

    @Override
    public ServerConnector getServerConnector(Server server) {
        ProtocolConfig config = this.getConfig();
        HttpConfiguration httpConfig = new HttpConfiguration();
        HttpConnectionFactory h1 = new HttpConnectionFactory(httpConfig);
        HTTP2CServerConnectionFactory h2c = new HTTP2CServerConnectionFactory(httpConfig);
        ServerConnector http2Connector = new ServerConnector(server, new ConnectionFactory[]{h1, h2c});
        http2Connector.setHost(config.getIp());
        http2Connector.setPort(config.getPort());
        http2Connector.setAcceptQueueSize(config.getMaxConns());
        return http2Connector;
    }
}

