/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trpc.transport.http.support.jetty;

import com.tencent.trpc.core.common.config.ProtocolConfig;
import com.tencent.trpc.core.extension.Extension;
import com.tencent.trpc.core.logger.Logger;
import com.tencent.trpc.core.logger.LoggerFactory;
import com.tencent.trpc.transport.http.AbstractHttpServer;
import com.tencent.trpc.transport.http.ExecutorDispatcher;
import com.tencent.trpc.transport.http.HttpExecutor;
import com.tencent.trpc.transport.http.common.ServletManager;
import javax.servlet.ServletContext;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

@Extension(value="jetty")
public class JettyHttpServer
extends AbstractHttpServer {
    private static final Logger logger = LoggerFactory.getLogger(JettyHttpServer.class);
    public static final String NAME = "jetty";
    protected Server server;

    public JettyHttpServer(ProtocolConfig config, HttpExecutor executor) {
        super(config, executor);
    }

    @Override
    public boolean isBound() {
        return this.server != null && this.server.isRunning();
    }

    @Override
    public ServerConnector getServerConnector(Server server) {
        ProtocolConfig config = this.getConfig();
        ServerConnector connector = new ServerConnector(server);
        connector.setHost(config.getIp());
        connector.setPort(config.getPort());
        connector.setAcceptQueueSize(config.getMaxConns());
        return connector;
    }

    @Override
    protected void doOpen() throws Exception {
        ProtocolConfig config = this.getConfig();
        QueuedThreadPool threadPool = this.getServerThreadPool(config);
        this.server = new Server((ThreadPool)threadPool);
        this.server.addConnector((Connector)this.getServerConnector(this.server));
        this.initCustomRoute(config);
        this.server.start();
    }

    private void initCustomRoute(ProtocolConfig config) {
        ServletContextHandler context = this.getServletContextHandler(this.server);
        int port = config.getPort();
        ServletManager.getManager().addServletContext(port, (ServletContext)context.getServletContext());
        ExecutorDispatcher.addHttpExecutor(port, this.getExecutor());
    }

    private ServletContextHandler getServletContextHandler(Server server) {
        ServletHandler servletHandler = new ServletHandler();
        ServletHolder servletHolder = servletHandler.addServletWithMapping(ExecutorDispatcher.class, "/*");
        servletHolder.setAsyncSupported(true);
        servletHolder.setInitOrder(1);
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)server, "/", 1);
        context.setServletHandler(servletHandler);
        return context;
    }

    private QueuedThreadPool getServerThreadPool(ProtocolConfig config) {
        int threads = config.getIoThreads();
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setDaemon(true);
        threadPool.setMaxThreads(Math.max(threads, 4));
        threadPool.setMinThreads(Math.max(threads, 4));
        threadPool.setIdleTimeout(Math.max(config.getIdleTimeout(), Integer.parseInt("180000")));
        return threadPool;
    }

    @Override
    protected void doClose() {
        ExecutorDispatcher.removeHttpExecutor(this.getConfig().getPort());
        ServletManager.getManager().removeServletContext(this.getConfig().getPort());
        if (this.getExecutor() != null) {
            try {
                this.getExecutor().destroy();
            }
            catch (Exception e) {
                logger.error("stop server|" + this.bindAddress + " exception", (Throwable)e);
            }
        }
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                logger.error("stop server|" + this.bindAddress + " exception", (Throwable)e);
            }
        }
    }
}

