/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trpc.transport.http.support.jetty;

import com.tencent.trpc.core.common.config.ProtocolConfig;
import com.tencent.trpc.core.extension.Extension;
import com.tencent.trpc.transport.http.HttpExecutor;
import com.tencent.trpc.transport.http.HttpServer;
import com.tencent.trpc.transport.http.spi.HttpServerFactory;
import com.tencent.trpc.transport.http.support.jetty.JettyHttp2Server;
import com.tencent.trpc.transport.http.support.jetty.JettyHttp2cServer;
import com.tencent.trpc.transport.http.support.jetty.JettyHttpServer;
import com.tencent.trpc.transport.http.support.jetty.JettyHttpsServer;
import com.tencent.trpc.transport.http.util.HttpUtils;

@Extension(value="jetty")
public class JettyHttpServerFactory
implements HttpServerFactory {
    @Override
    public HttpServer create(ProtocolConfig config, HttpExecutor executor) {
        switch (HttpUtils.getScheme(config)) {
            case "http2c": {
                return new JettyHttp2cServer(config, executor);
            }
            case "h2": {
                return new JettyHttp2Server(config, executor);
            }
            case "https": {
                return new JettyHttpsServer(config, executor);
            }
        }
        return new JettyHttpServer(config, executor);
    }
}

