/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trpc.transport.http.support.jetty;

import com.tencent.trpc.core.common.config.ProtocolConfig;
import com.tencent.trpc.transport.http.HttpExecutor;
import com.tencent.trpc.transport.http.support.jetty.JettyHttpServer;
import org.eclipse.jetty.http2.HTTP2Cipher;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class JettyHttpsServer
extends JettyHttpServer {
    public JettyHttpsServer(ProtocolConfig config, HttpExecutor executor) {
        super(config, executor);
    }

    @Override
    public ServerConnector getServerConnector(Server server) {
        ProtocolConfig config = this.getConfig();
        SslContextFactory.Client sslContextFactory = new SslContextFactory.Client();
        sslContextFactory.setKeyStorePath(String.valueOf(config.getExtMap().get("keystore_path")));
        sslContextFactory.setKeyStorePassword(String.valueOf(config.getExtMap().get("keystore_pass")));
        sslContextFactory.setCipherComparator(HTTP2Cipher.COMPARATOR);
        sslContextFactory.setProvider("Conscrypt");
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSecureScheme("https");
        httpConfig.setSecurePort(config.getPort());
        HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
        httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        return this.buildServerConnector(server, config, (SslContextFactory)sslContextFactory, httpConfig, httpsConfig);
    }

    protected ServerConnector buildServerConnector(Server server, ProtocolConfig config, SslContextFactory sslContextFactory, HttpConfiguration httpConfig, HttpConfiguration httpsConfig) {
        SslConnectionFactory ssl = new SslConnectionFactory(sslContextFactory, "http/1.1");
        ServerConnector http2Connector = new ServerConnector(server, new ConnectionFactory[]{ssl, new HttpConnectionFactory(httpsConfig)});
        http2Connector.setHost(config.getIp());
        http2Connector.setPort(config.getPort());
        http2Connector.setAcceptQueueSize(config.getMaxConns());
        return http2Connector;
    }
}

