/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.asn1.der;

import com.teradata.tdgss.asn1.der.DERASN1Type;
import com.teradata.tdgss.asn1.der.DERException;
import com.teradata.tdgss.asn1.der.DERUniversalTagOctets;
import java.math.BigInteger;

class DERBIGInteger
extends DERASN1Type {
    private BigInteger value;

    DERBIGInteger(BigInteger bigInteger) {
        this.value = bigInteger;
        this.octets = this.calcOctets(this.value);
    }

    DERBIGInteger(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    DERBIGInteger(byte[] byArray, boolean bl) {
        this(byArray, 0, byArray.length, bl);
    }

    DERBIGInteger(byte[] byArray, int n, int n2) {
        this(byArray, n, n2, true);
    }

    DERBIGInteger(byte[] byArray, int n, int n2, boolean bl) {
        this.parse(byArray, n, n2, bl);
    }

    protected void parse(byte[] byArray, int n, int n2, boolean bl) {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new DERException("Illegal values are passed.");
        }
        if (bl) {
            this.octets = new byte[n2];
            System.arraycopy(byArray, n, this.octets, 0, n2);
        } else {
            super.parseExplicitOctets(byArray, n);
        }
        this.value = this.getValueOf(this.octets);
    }

    byte[] getUniveralTagOctets() {
        return DERUniversalTagOctets.INTEGER;
    }

    private final byte[] calcOctets(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        return byArray;
    }

    private final BigInteger getValueOf(byte[] byArray) {
        return new BigInteger(1, byArray);
    }

    protected final boolean isConstructed() {
        return false;
    }

    BigInteger getValue() {
        return this.value;
    }
}

