/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.PageBtree;
import org.h2.index.PageBtreeCursor;
import org.h2.index.PageBtreeLeaf;
import org.h2.index.PageBtreeNode;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.store.DataPage;
import org.h2.store.PageStore;
import org.h2.store.Record;
import org.h2.table.IndexColumn;
import org.h2.table.TableData;
import org.h2.value.Value;
import org.h2.value.ValueLob;

public class PageBtreeIndex
extends BaseIndex {
    private PageStore store;
    private TableData tableData;
    private int headPos;
    private long rowCount;
    private boolean needRebuild;

    public PageBtreeIndex(TableData tableData, int n, String string, IndexColumn[] indexColumnArray, IndexType indexType, int n2) throws SQLException {
        this.initBaseIndex(tableData, n, string, indexColumnArray, indexType);
        if (this.database.isMultiVersion()) {
            // empty if block
        }
        this.tableData = tableData;
        if (!this.database.isPersistent() || n < 0) {
            return;
        }
        this.store = this.database.getPageStore();
        if (n2 == -1) {
            this.needRebuild = true;
            this.headPos = n2 = this.store.allocatePage();
            PageBtreeLeaf pageBtreeLeaf = new PageBtreeLeaf(this, n2, 0, this.store.createDataPage());
            this.store.updateRecord(pageBtreeLeaf, true, pageBtreeLeaf.data);
            this.store.addMeta(this);
        } else {
            this.headPos = n2;
            PageBtree pageBtree = this.getPage(n2);
            this.rowCount = pageBtree.getRowCount();
            this.store.updateRecord(pageBtree, false, null);
        }
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("opened " + this.getName() + " rows:" + this.rowCount);
        }
    }

    public int getHeadPos() {
        return this.headPos;
    }

    public void add(Session session, Row row) throws SQLException {
        PageBtree pageBtree;
        int n;
        Object object;
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("add " + row.getPos());
        }
        if (this.tableData.getContainsLargeObject()) {
            for (int i = 0; i < row.getColumnCount(); ++i) {
                Value value = row.getValue(i);
                object = value.link(this.database, this.getId());
                if (((Value)object).isLinked()) {
                    session.unlinkAtCommitStop((Value)object);
                }
                if (value == object) continue;
                row.setValue(i, (Value)object);
            }
        }
        while ((n = (pageBtree = this.getPage(this.headPos)).addRow(row)) != 0) {
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("split " + n);
            }
            object = pageBtree.getRow(n - 1);
            PageBtree pageBtree2 = pageBtree;
            PageBtree pageBtree3 = pageBtree.split(n);
            int n2 = pageBtree.getPageId();
            int n3 = this.store.allocatePage();
            pageBtree2.setPageId(n3);
            pageBtree2.setParentPageId(this.headPos);
            pageBtree3.setParentPageId(this.headPos);
            PageBtreeNode pageBtreeNode = new PageBtreeNode(this, n2, 0, this.store.createDataPage());
            pageBtreeNode.init(pageBtree2, (SearchRow)object, pageBtree3);
            this.store.updateRecord(pageBtree2, true, pageBtree2.data);
            this.store.updateRecord(pageBtree3, true, pageBtree3.data);
            this.store.updateRecord(pageBtreeNode, true, null);
            pageBtree = pageBtreeNode;
        }
        ++this.rowCount;
    }

    PageBtree getPage(int n) throws SQLException {
        PageBtree pageBtree;
        Record record = this.store.getRecord(n);
        if (record != null) {
            return (PageBtree)record;
        }
        DataPage dataPage = this.store.readPage(n);
        dataPage.reset();
        int n2 = dataPage.readInt();
        int n3 = dataPage.readByte() & 0xFF;
        switch (n3 & 0xFFFFFFEF) {
            case 4: {
                pageBtree = new PageBtreeLeaf(this, n, n2, dataPage);
                break;
            }
            case 5: {
                pageBtree = new PageBtreeNode(this, n, n2, dataPage);
                break;
            }
            case 0: {
                PageBtreeLeaf pageBtreeLeaf = new PageBtreeLeaf(this, n, n2, dataPage);
                return pageBtreeLeaf;
            }
            default: {
                throw Message.getSQLException(90030, "page=" + n + " type=" + n3);
            }
        }
        pageBtree.read();
        return pageBtree;
    }

    public boolean canGetFirstOrLast() {
        return false;
    }

    public Cursor findNext(Session session, SearchRow searchRow, SearchRow searchRow2) throws SQLException {
        return this.find(session, searchRow, true, searchRow2);
    }

    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) throws SQLException {
        return this.find(session, searchRow, false, searchRow2);
    }

    private Cursor find(Session session, SearchRow searchRow, boolean bl, SearchRow searchRow2) throws SQLException {
        if (SysProperties.CHECK && this.store == null) {
            throw Message.getSQLException(90007);
        }
        PageBtree pageBtree = this.getPage(this.headPos);
        PageBtreeCursor pageBtreeCursor = new PageBtreeCursor(session, this, searchRow2);
        pageBtree.find(pageBtreeCursor, searchRow, bl);
        return pageBtreeCursor;
    }

    public Cursor findFirstOrLast(Session session, boolean bl) throws SQLException {
        throw Message.getUnsupportedException("PAGE");
    }

    public double getCost(Session session, int[] nArray) {
        return 10L * this.getCostRangeIndex(nArray, this.tableData.getRowCount(session));
    }

    public boolean needRebuild() {
        return this.needRebuild;
    }

    public void remove(Session session, Row row) throws SQLException {
        Object object;
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("remove " + row.getPos());
        }
        if (this.tableData.getContainsLargeObject()) {
            for (int i = 0; i < row.getColumnCount(); ++i) {
                object = row.getValue(i);
                if (!((Value)object).isLinked()) continue;
                session.unlinkAtCommit((ValueLob)object);
            }
        }
        if (this.rowCount == 1L) {
            this.removeAllRows();
        } else {
            object = this.getPage(this.headPos);
            ((PageBtree)object).remove(row);
            --this.rowCount;
        }
    }

    public void remove(Session session) throws SQLException {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("remove");
        }
        this.store.removeMeta(this);
    }

    public void truncate(Session session) throws SQLException {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("truncate");
        }
        this.removeAllRows();
        if (this.tableData.getContainsLargeObject()) {
            ValueLob.removeAllForTable(this.database, this.table.getId());
        }
        this.tableData.setRowCount(0L);
    }

    private void removeAllRows() throws SQLException {
        this.store.removeRecord(this.headPos);
        PageBtreeLeaf pageBtreeLeaf = new PageBtreeLeaf(this, this.headPos, 0, this.store.createDataPage());
        this.store.updateRecord(pageBtreeLeaf, true, null);
        this.rowCount = 0L;
    }

    public void checkRename() {
    }

    public Row getRow(Session session, int n) throws SQLException {
        return this.tableData.getRow(session, n);
    }

    PageStore getPageStore() {
        return this.store;
    }

    Row readRow(DataPage dataPage) throws SQLException {
        return this.tableData.readRow(dataPage);
    }

    public long getRowCountApproximation() {
        return this.rowCount;
    }

    public long getRowCount(Session session) {
        return this.rowCount;
    }

    public void close(Session session) throws SQLException {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("close");
        }
    }

    SearchRow readRow(DataPage dataPage, int n) throws SQLException {
        dataPage.setPos(n);
        SearchRow searchRow = this.table.getTemplateSimpleRow(this.columns.length == 1);
        searchRow.setPos(dataPage.readInt());
        for (int i = 0; i < this.columns.length; ++i) {
            int n2 = this.columns[i].getColumnId();
            searchRow.setValue(n2, dataPage.readValue());
        }
        return searchRow;
    }

    void writeRow(DataPage dataPage, int n, SearchRow searchRow) throws SQLException {
        dataPage.setPos(n);
        dataPage.writeInt(searchRow.getPos());
        for (int i = 0; i < this.columns.length; ++i) {
            int n2 = this.columns[i].getColumnId();
            dataPage.writeValue(searchRow.getValue(n2));
        }
    }

    int getRowSize(DataPage dataPage, SearchRow searchRow) throws SQLException {
        int n = 4;
        for (int i = 0; i < this.columns.length; ++i) {
            Value value = searchRow.getValue(this.columns[i].getColumnId());
            n += dataPage.getValueLen(value);
        }
        return n;
    }
}

