/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.command.dml.Query;
import org.h2.engine.Session;
import org.h2.expression.Parameter;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.ViewCursor;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.table.TableView;
import org.h2.util.IntArray;
import org.h2.util.ObjectArray;
import org.h2.util.SmallLRUCache;
import org.h2.value.Value;

public class ViewIndex
extends BaseIndex {
    private final TableView view;
    private final String querySQL;
    private final ObjectArray originalParameters;
    private final SmallLRUCache costCache = new SmallLRUCache(64);
    private boolean recursive;
    private int[] masks;
    private String planSQL;
    private Query query;
    private Session session;

    public ViewIndex(TableView tableView, String string, ObjectArray objectArray, boolean bl) {
        this.initBaseIndex(tableView, 0, null, null, IndexType.createNonUnique(false));
        this.view = tableView;
        this.querySQL = string;
        this.originalParameters = objectArray;
        this.recursive = bl;
        this.columns = new Column[0];
    }

    public ViewIndex(TableView tableView, ViewIndex viewIndex, Session session, int[] nArray) throws SQLException {
        this.initBaseIndex(tableView, 0, null, null, IndexType.createNonUnique(false));
        this.view = tableView;
        this.querySQL = viewIndex.querySQL;
        this.originalParameters = viewIndex.originalParameters;
        this.recursive = viewIndex.recursive;
        this.masks = nArray;
        this.session = session;
        this.columns = new Column[0];
        this.query = this.getQuery(session, nArray);
        this.planSQL = this.query.getPlanSQL();
    }

    public Session getSession() {
        return this.session;
    }

    public String getPlanSQL() {
        return this.planSQL;
    }

    public void close(Session session) {
    }

    public void add(Session session, Row row) throws SQLException {
        throw Message.getUnsupportedException("VIEW");
    }

    public void remove(Session session, Row row) throws SQLException {
        throw Message.getUnsupportedException("VIEW");
    }

    public double getCost(Session session, int[] nArray) throws SQLException {
        long l;
        IntArray intArray = new IntArray(nArray == null ? new int[]{} : nArray);
        CostElement costElement = (CostElement)this.costCache.get(intArray);
        if (costElement != null && (l = System.currentTimeMillis()) < costElement.evaluatedAt + 10000L) {
            return costElement.cost;
        }
        Query query = (Query)session.prepare(this.querySQL, true);
        if (nArray == null) {
            this.columns = new Column[0];
        } else {
            int n;
            int n2;
            IntArray intArray2 = new IntArray();
            for (n2 = 0; n2 < nArray.length; ++n2) {
                n = nArray[n2];
                if (n == 0) continue;
                intArray2.add(n2);
            }
            n2 = intArray2.size();
            this.columns = new Column[n2];
            for (n = 0; n < n2; ++n) {
                Parameter parameter;
                Column column;
                int n3 = intArray2.get(n);
                this.columns[n] = column = this.table.getColumn(n3);
                int n4 = nArray[n3];
                int n5 = query.getParameters().size() + this.view.getParameterOffset();
                if ((n4 & 1) != 0) {
                    parameter = new Parameter(n5);
                    query.addGlobalCondition(parameter, n3, 0);
                    continue;
                }
                if ((n4 & 2) != 0) {
                    parameter = new Parameter(n5);
                    query.addGlobalCondition(parameter, n3, 1);
                }
                if ((n4 & 4) == 0) continue;
                parameter = new Parameter(n5);
                query.addGlobalCondition(parameter, n3, 3);
            }
            if (this.recursive) {
                return 10.0;
            }
            String string = query.getPlanSQL();
            query = (Query)session.prepare(string, true);
        }
        double d = query.getCost();
        costElement = new CostElement();
        costElement.evaluatedAt = System.currentTimeMillis();
        costElement.cost = d;
        this.costCache.put(intArray, costElement);
        return d;
    }

    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) throws SQLException {
        Object object;
        Object object2;
        int n;
        int n2;
        ObjectArray objectArray = this.query.getParameters();
        for (n2 = 0; this.originalParameters != null && n2 < this.originalParameters.size(); ++n2) {
            Parameter parameter = (Parameter)this.originalParameters.get(n2);
            n = parameter.getIndex();
            if (n >= objectArray.size()) continue;
            object2 = (Parameter)objectArray.get(n);
            object = parameter.getValue(session);
            ((Parameter)object2).setValue((Value)object);
        }
        n2 = searchRow != null ? searchRow.getColumnCount() : (searchRow2 != null ? searchRow2.getColumnCount() : 0);
        int n3 = this.originalParameters == null ? 0 : this.originalParameters.size();
        n3 += this.view.getParameterOffset();
        for (n = 0; n < n2; ++n) {
            if (searchRow != null && (object2 = searchRow.getValue(n)) != null) {
                object = (Parameter)objectArray.get(n3++);
                ((Parameter)object).setValue((Value)object2);
            }
            if (searchRow2 == null || this.masks[n] == 1 || (object2 = searchRow2.getValue(n)) == null) continue;
            object = (Parameter)objectArray.get(n3++);
            ((Parameter)object).setValue((Value)object2);
        }
        LocalResult localResult = this.query.query(0);
        return new ViewCursor(this.table, localResult);
    }

    private Query getQuery(Session session, int[] nArray) throws SQLException {
        int n;
        int n2;
        Query query = (Query)session.prepare(this.querySQL, true);
        if (nArray == null) {
            return query;
        }
        int n3 = this.originalParameters == null ? 0 : this.originalParameters.size();
        n3 += this.view.getParameterOffset();
        IntArray intArray = new IntArray();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n = nArray[n2];
            if (n == 0) continue;
            intArray.add(n2);
            if ((n & 6) != 6) continue;
            intArray.add(n2);
        }
        n2 = intArray.size();
        this.columns = new Column[n2];
        n = 0;
        while (n < n2) {
            Parameter parameter;
            Column column;
            int n4 = intArray.get(n);
            this.columns[n] = column = this.table.getColumn(n4);
            int n5 = nArray[n4];
            if ((n5 & 1) == 1) {
                parameter = new Parameter(n3 + n);
                query.addGlobalCondition(parameter, n4, 0);
                ++n;
                continue;
            }
            if ((n5 & 2) == 2) {
                parameter = new Parameter(n3 + n);
                query.addGlobalCondition(parameter, n4, 1);
                ++n;
            }
            if ((n5 & 4) != 4) continue;
            parameter = new Parameter(n3 + n);
            query.addGlobalCondition(parameter, n4, 3);
            ++n;
        }
        String string = query.getPlanSQL();
        query = (Query)session.prepare(string, true);
        return query;
    }

    public void remove(Session session) throws SQLException {
        throw Message.getUnsupportedException("VIEW");
    }

    public void truncate(Session session) throws SQLException {
        throw Message.getUnsupportedException("VIEW");
    }

    public void checkRename() throws SQLException {
        throw Message.getUnsupportedException("VIEW");
    }

    public boolean needRebuild() {
        return false;
    }

    public boolean canGetFirstOrLast() {
        return false;
    }

    public Cursor findFirstOrLast(Session session, boolean bl) throws SQLException {
        throw Message.getUnsupportedException("VIEW");
    }

    public void setRecursive(boolean bl) {
        this.recursive = bl;
    }

    public long getRowCount(Session session) {
        return 0L;
    }

    public long getRowCountApproximation() {
        return 0L;
    }

    static class CostElement {
        long evaluatedAt;
        double cost;

        CostElement() {
        }
    }
}

