/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.paranamer.generator;

import com.thoughtworks.paranamer.generator.Enhancer;
import com.thoughtworks.paranamer.generator.ParanamerGenerator;
import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;

public class QdoxParanamerGenerator
implements ParanamerGenerator {
    private static final String SPACE = " ";
    private static final String NEWLINE = "\n";
    private static final String COMMA = ",";
    private static final String EMPTY = "";

    public void processSourcePath(String sourcePath, String outputPath) throws IOException {
        JavaClass[] classes = this.getClassesSortedByName(sourcePath);
        this.processClasses(classes, outputPath);
    }

    private JavaClass[] getClassesSortedByName(String sourcePath) {
        JavaDocBuilder builder = new JavaDocBuilder();
        builder.addSourceTree(new File(sourcePath));
        Object[] classes = builder.getClasses();
        Arrays.sort(classes);
        return classes;
    }

    private void processClasses(JavaClass[] classes, String outputPath) throws IOException {
        for (int i = 0; i < classes.length; ++i) {
            JavaClass javaClass = classes[i];
            String content = this.addMethods(javaClass.getMethods());
            Enhancer enhancer = new Enhancer();
            File classFile = new File(outputPath, javaClass.getFullyQualifiedName().replace('.', File.separatorChar) + ".class");
            enhancer.enhance(classFile, content);
        }
    }

    private String addMethods(JavaMethod[] methods) {
        Arrays.sort(methods);
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < methods.length; ++i) {
            JavaMethod javaMethod = methods[i];
            if (Arrays.asList(javaMethod.getModifiers()).contains("private") || javaMethod.getParameters().length <= 0) continue;
            buffer.append(this.addMethod(javaMethod));
        }
        return buffer.toString();
    }

    private String addMethod(JavaMethod method) {
        JavaParameter[] parameters = method.getParameters();
        return this.format(method, parameters);
    }

    private String format(JavaMethod method, JavaParameter[] parameters) {
        StringBuffer sb = new StringBuffer();
        String methodName = method.getName();
        if (method.isConstructor()) {
            methodName = "<init>";
        }
        String parameterTypes = this.getParameterTypes(parameters);
        sb.append(this.formatLine(methodName, parameterTypes, this.getParameterNames(parameters)));
        return sb.toString();
    }

    private String formatLine(String methodName, String paramTypes, String paramNames) {
        StringBuffer sb = new StringBuffer();
        sb.append(methodName).append(SPACE);
        if (paramTypes.length() > 0) {
            sb.append(paramTypes.trim()).append(SPACE);
            sb.append(paramNames.trim()).append(SPACE);
        }
        sb.append(NEWLINE);
        return sb.toString();
    }

    private String getParameterNames(JavaParameter[] parameters) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < parameters.length; ++i) {
            sb.append(parameters[i].getName());
            sb.append(this.comma(i, parameters.length));
        }
        return sb.toString();
    }

    private String getParameterTypes(JavaParameter[] parameters) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < parameters.length; ++i) {
            sb.append(parameters[i].getType());
            sb.append(this.comma(i, parameters.length));
        }
        return sb.toString();
    }

    private String comma(int index, int size) {
        return index + 1 < size ? COMMA : EMPTY;
    }
}

