/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.InstanceResource;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class IncomingPhoneNumber
extends InstanceResource {
    private static final String SID_PROPERTY = "sid";

    public IncomingPhoneNumber(TwilioRestClient client) {
        super(client);
    }

    public IncomingPhoneNumber(TwilioRestClient client, String sid) {
        super(client);
        if (sid == null) {
            throw new IllegalStateException("The Sid for an IncomingPhoneNumber can not be null");
        }
        this.setProperty(SID_PROPERTY, sid);
    }

    public IncomingPhoneNumber(TwilioRestClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    @Override
    protected String getResourceLocation() {
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/IncomingPhoneNumbers/" + this.getSid() + ".json";
    }

    public boolean delete() throws TwilioRestException {
        TwilioRestResponse response = this.getClient().safeRequest(this.getResourceLocation(), "DELETE", null);
        return !response.isError();
    }

    public String getSid() {
        return this.getProperty(SID_PROPERTY);
    }

    public Date getDateCreated() {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
        try {
            return format.parse(this.getProperty("date_created"));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public Date getDateUpdated() {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
        try {
            return format.parse(this.getProperty("date_updated"));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public String getFriendlyName() {
        return this.getProperty("friendly_name");
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public String getPhoneNumber() {
        return this.getProperty("phone_number");
    }

    public String getVoiceApplicationSid() {
        return this.getProperty("voice_application_sid");
    }

    public String getSmsApplicationSid() {
        return this.getProperty("sms_application_sid");
    }

    public String getApiVersion() {
        return this.getProperty("api_version");
    }

    public String getVoiceUrl() {
        return this.getProperty("voice_url");
    }

    public String getVoiceMethod() {
        return this.getProperty("voice_method");
    }

    public String getVoiceFallbackUrl() {
        return this.getProperty("voice_fallback_url");
    }

    public String getVoiceFallbackMethod() {
        return this.getProperty("voice_fallback_method");
    }

    public String getStatusCallback() {
        return this.getProperty("status_callback");
    }

    public String getStatusCallbackMethod() {
        return this.getProperty("status_callback_method");
    }

    public String getVoiceCallerIdLookup() {
        return this.getProperty("voice_caller_id_lookup");
    }

    public String getSmsUrl() {
        return this.getProperty("sms_url");
    }

    public String getSmsMethod() {
        return this.getProperty("sms_method");
    }

    public String getSmsFallbackUrl() {
        return this.getProperty("sms_fallback_url");
    }

    public String getSmsFallbackMethod() {
        return this.getProperty("sms_fallback_method");
    }

    public String getSmsStatusCallback() {
        return this.getProperty("sms_status_callback");
    }
}

