/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.resource.InstanceResource;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class Sms
extends InstanceResource {
    private static final String SID_PROPERTY = "sid";

    public Sms(TwilioRestClient client) {
        super(client);
    }

    public Sms(TwilioRestClient client, String sid) {
        super(client);
        if (sid == null) {
            throw new IllegalStateException("The Sid for an Sms can not be null");
        }
        this.setProperty(SID_PROPERTY, sid);
    }

    public Sms(TwilioRestClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    @Override
    protected String getResourceLocation() {
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/SMS/Messages/" + this.getSid() + ".json";
    }

    public String getSid() {
        return this.getProperty(SID_PROPERTY);
    }

    public Date getDateCreated() {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
        try {
            return format.parse(this.getProperty("date_created"));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public Date getDateUpdated() {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
        try {
            return format.parse(this.getProperty("date_updated"));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public Date getDateSent() {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
        try {
            return format.parse(this.getProperty("date_sent"));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public String getTo() {
        return this.getProperty("to");
    }

    public String getFrom() {
        return this.getProperty("from");
    }

    public String getBody() {
        return this.getProperty("body");
    }

    public String getStatus() {
        return this.getProperty("status");
    }

    public String getPrice() {
        return this.getProperty("price");
    }

    public String getDirection() {
        return this.getProperty("direction");
    }

    public String getApiVersion() {
        return this.getProperty("api_version");
    }
}

