/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.InstanceResource;
import com.twilio.sdk.resource.instance.Recurrence;
import com.twilio.sdk.resource.instance.Trigger;
import com.twilio.sdk.resource.instance.UsageCategory;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class UsageTrigger
extends InstanceResource {
    private static final String SID_PROPERTY = "Sid";

    public UsageTrigger(TwilioRestClient client) {
        super(client);
    }

    @Override
    protected String getResourceLocation() {
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/Usage/Triggers/" + this.getSid() + ".json";
    }

    public String getSid() {
        return this.getProperty(SID_PROPERTY);
    }

    public UsageTrigger(TwilioRestClient client, String sid) {
        super(client);
        if (sid == null) {
            throw new IllegalStateException("The Sid for a UsageRecord can not be null");
        }
        this.setProperty(SID_PROPERTY, sid);
    }

    public UsageTrigger(TwilioRestClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    public Date getDateCreated() {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
        try {
            return format.parse(this.getProperty("DateCreated"));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public Date getDateUpdated() {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
        try {
            return format.parse(this.getProperty("DateUpdated"));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public String getFriendlyName() {
        return this.getProperty("FriendlyName");
    }

    public Recurrence getRecurring() {
        return Recurrence.valueOf(this.getProperty("Recurring"));
    }

    public UsageCategory getUsageCategory() {
        return UsageCategory.valueOf(this.getProperty("UsageCategory"));
    }

    public Trigger getTriggerBy() {
        return Trigger.valueOf(this.getProperty("TriggerBy"));
    }

    public BigDecimal getTriggerValue() {
        return new BigDecimal(this.getProperty("TriggerValue"));
    }

    public BigDecimal getCurrentValue() {
        return new BigDecimal(this.getProperty("CurrentValue"));
    }

    public String getUsageRecordUri() {
        return this.getProperty("UsageRecordUri");
    }

    public String getCallbackUrl() {
        return this.getProperty("CallbackUrl");
    }

    public String getCallbackMethod() {
        return this.getProperty("CallbackMethod");
    }

    public Date getDateFired() {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
        try {
            String dateFired = this.getProperty("DateFired");
            if (dateFired == null) {
                return null;
            }
            return format.parse(dateFired);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public String getUri() {
        return this.getProperty("Uri");
    }

    public boolean delete() throws TwilioRestException {
        TwilioRestResponse response = this.getClient().safeRequest(this.getResourceLocation(), "DELETE", null);
        return !response.isError();
    }
}

