/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.collections;

import com.google.common.base.Preconditions;

public final class Bits {
    private static final int LSB = 0;
    private static final int INT_MSB = 31;
    private static final int LONG_MSB = 63;

    private Bits() {
    }

    public static boolean isBitSet(int n, int n2) {
        Preconditions.checkState((n2 >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((n2 <= 31 ? 1 : 0) != 0);
        int n3 = 1 << n2;
        return (n & n3) != 0;
    }

    public static boolean isBitSet(long l, int n) {
        Preconditions.checkState((n >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((n <= 63 ? 1 : 0) != 0);
        long l2 = 1L << n;
        return (l & l2) != 0L;
    }

    public static int setBit(int n, int n2) {
        Preconditions.checkState((n2 >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((n2 <= 31 ? 1 : 0) != 0);
        int n3 = 1 << n2;
        return n | n3;
    }

    public static long setBit(long l, int n) {
        Preconditions.checkState((n >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((n <= 63 ? 1 : 0) != 0);
        long l2 = 1L << n;
        return l | l2;
    }

    public static int clearBit(int n, int n2) {
        Preconditions.checkState((n2 >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((n2 <= 31 ? 1 : 0) != 0);
        int n3 = ~Bits.setBit(0, n2);
        return n & n3;
    }

    public static long clearBit(long l, int n) {
        Preconditions.checkState((n >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((n <= 63 ? 1 : 0) != 0);
        long l2 = Bits.setBit(0L, n) ^ 0xFFFFFFFFFFFFFFFFL;
        return l & l2;
    }
}

