/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.zookeeper;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.twitter.common.base.Command;
import com.twitter.common.base.MorePreconditions;
import com.twitter.common.net.InetSocketAddressHelper;
import com.twitter.common.quantity.Amount;
import com.twitter.common.quantity.Time;
import com.twitter.common.quantity.Unit;
import com.twitter.common.zookeeper.ZooKeeperUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.common.PathUtils;

public class ZooKeeperClient {
    private static final Logger LOG = Logger.getLogger(ZooKeeperClient.class.getName());
    private static final Amount<Long, Time> WAIT_FOREVER = Amount.of((long)0L, (Unit)Time.MILLISECONDS);
    private final int sessionTimeoutMs;
    private final Credentials credentials;
    private final String zooKeeperServers;
    private final String connectString;
    private volatile ZooKeeper zooKeeper;
    private SessionState sessionState;
    private final Set<Watcher> watchers = new CopyOnWriteArraySet<Watcher>();
    private final BlockingQueue<WatchedEvent> eventQueue = new LinkedBlockingQueue<WatchedEvent>();

    public static Credentials digestCredentials(String string, String string2) {
        MorePreconditions.checkNotBlank((String)string);
        Preconditions.checkNotNull((Object)string2);
        return ZooKeeperClient.credentials("digest", (string + ":" + string2).getBytes());
    }

    public static Credentials credentials(final String string, final byte[] byArray) {
        MorePreconditions.checkNotBlank((String)string);
        Preconditions.checkNotNull((Object)byArray);
        return new Credentials(){

            @Override
            public void authenticate(ZooKeeper zooKeeper) {
                zooKeeper.addAuthInfo(string, byArray);
            }

            @Override
            public String scheme() {
                return string;
            }

            @Override
            public byte[] authToken() {
                return byArray;
            }

            public boolean equals(Object object) {
                if (!(object instanceof Credentials)) {
                    return false;
                }
                Credentials credentials = (Credentials)object;
                return new EqualsBuilder().append((Object)string, (Object)credentials.scheme()).append(byArray, credentials.authToken()).isEquals();
            }

            public int hashCode() {
                return Objects.hashCode((Object[])new Object[]{string, byArray});
            }
        };
    }

    private static Iterable<InetSocketAddress> combine(InetSocketAddress inetSocketAddress, InetSocketAddress ... inetSocketAddressArray) {
        return ImmutableSet.builder().add((Object)inetSocketAddress).add((Object[])inetSocketAddressArray).build();
    }

    public ZooKeeperClient(Amount<Integer, Time> amount, InetSocketAddress inetSocketAddress, InetSocketAddress ... inetSocketAddressArray) {
        this(amount, ZooKeeperClient.combine(inetSocketAddress, inetSocketAddressArray));
    }

    public ZooKeeperClient(Amount<Integer, Time> amount, Iterable<InetSocketAddress> iterable) {
        this(amount, Credentials.NONE, (Optional<String>)Optional.absent(), iterable);
    }

    public ZooKeeperClient(Amount<Integer, Time> amount, Credentials credentials, InetSocketAddress inetSocketAddress, InetSocketAddress ... inetSocketAddressArray) {
        this(amount, credentials, (Optional<String>)Optional.absent(), ZooKeeperClient.combine(inetSocketAddress, inetSocketAddressArray));
    }

    public ZooKeeperClient(Amount<Integer, Time> amount, Credentials credentials, Iterable<InetSocketAddress> iterable) {
        this(amount, credentials, (Optional<String>)Optional.absent(), iterable);
    }

    public ZooKeeperClient(Amount<Integer, Time> amount, Credentials credentials, Optional<String> optional, Iterable<InetSocketAddress> iterable) {
        this.sessionTimeoutMs = (Integer)((Amount)Preconditions.checkNotNull(amount)).as((Unit)Time.MILLISECONDS);
        this.credentials = (Credentials)Preconditions.checkNotNull((Object)credentials);
        if (optional.isPresent()) {
            PathUtils.validatePath((String)((String)optional.get()));
        }
        Preconditions.checkNotNull(iterable);
        Preconditions.checkArgument((!Iterables.isEmpty(iterable) ? 1 : 0) != 0, (Object)"Must present at least 1 ZK server");
        Thread thread = new Thread("ZookeeperClient-watcherProcessor"){

            @Override
            public void run() {
                while (true) {
                    try {
                        block3: while (true) {
                            WatchedEvent watchedEvent = (WatchedEvent)ZooKeeperClient.this.eventQueue.take();
                            Iterator iterator = ZooKeeperClient.this.watchers.iterator();
                            while (true) {
                                if (!iterator.hasNext()) continue block3;
                                Watcher watcher = (Watcher)iterator.next();
                                watcher.process(watchedEvent);
                            }
                            break;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
        Iterable iterable2 = Iterables.transform((Iterable)ImmutableSet.copyOf(iterable), (Function)InetSocketAddressHelper.INET_TO_STR);
        this.zooKeeperServers = Joiner.on((char)',').join(iterable2);
        this.connectString = this.zooKeeperServers.concat((String)optional.or((Object)""));
    }

    public boolean hasCredentials() {
        return !Strings.isNullOrEmpty((String)this.credentials.scheme()) && this.credentials.authToken() != null;
    }

    public synchronized ZooKeeper get() throws ZooKeeperConnectionException, InterruptedException {
        try {
            return this.get(WAIT_FOREVER);
        }
        catch (TimeoutException timeoutException) {
            InterruptedException interruptedException = new InterruptedException("Got an unexpected TimeoutException for 0 wait");
            interruptedException.initCause(timeoutException);
            throw interruptedException;
        }
    }

    public synchronized ZooKeeper get(Amount<Long, Time> amount) throws ZooKeeperConnectionException, InterruptedException, TimeoutException {
        if (this.zooKeeper == null) {
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            Watcher watcher = new Watcher(){

                public void process(WatchedEvent watchedEvent) {
                    block0 : switch (watchedEvent.getType()) {
                        case None: {
                            switch (watchedEvent.getState()) {
                                case Expired: {
                                    LOG.info("Zookeeper session expired. Event: " + watchedEvent);
                                    ZooKeeperClient.this.close();
                                    break block0;
                                }
                                case SyncConnected: {
                                    countDownLatch.countDown();
                                }
                            }
                        }
                    }
                    ZooKeeperClient.this.eventQueue.offer(watchedEvent);
                }
            };
            try {
                this.zooKeeper = this.sessionState != null ? new ZooKeeper(this.connectString, this.sessionTimeoutMs, watcher, this.sessionState.sessionId, this.sessionState.sessionPasswd) : new ZooKeeper(this.connectString, this.sessionTimeoutMs, watcher);
            }
            catch (IOException iOException) {
                throw new ZooKeeperConnectionException("Problem connecting to servers: " + this.zooKeeperServers, iOException);
            }
            if ((Long)amount.getValue() > 0L) {
                if (!countDownLatch.await((Long)amount.as((Unit)Time.MILLISECONDS), TimeUnit.MILLISECONDS)) {
                    this.close();
                    throw new TimeoutException("Timed out waiting for a ZK connection after " + amount);
                }
            } else {
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    LOG.info("Interrupted while waiting to connect to zooKeeper");
                    this.close();
                    throw interruptedException;
                }
            }
            this.credentials.authenticate(this.zooKeeper);
            this.sessionState = new SessionState(this.zooKeeper.getSessionId(), this.zooKeeper.getSessionPasswd());
        }
        return this.zooKeeper;
    }

    public Watcher registerExpirationHandler(final Command command) {
        Watcher watcher = new Watcher(){

            public void process(WatchedEvent watchedEvent) {
                if (watchedEvent.getType() == Watcher.Event.EventType.None && watchedEvent.getState() == Watcher.Event.KeeperState.Expired) {
                    command.execute();
                }
            }
        };
        this.register(watcher);
        return watcher;
    }

    public void register(Watcher watcher) {
        this.watchers.add(watcher);
    }

    public boolean unregister(Watcher watcher) {
        return this.watchers.remove(watcher);
    }

    public boolean shouldRetry(KeeperException keeperException) {
        if (keeperException instanceof KeeperException.SessionExpiredException) {
            this.close();
        }
        return ZooKeeperUtils.isRetryable(keeperException);
    }

    public String getZooKeeperServers() {
        return this.zooKeeperServers;
    }

    public String getConnectString() {
        return this.connectString;
    }

    public synchronized void close() {
        if (this.zooKeeper != null) {
            try {
                this.zooKeeper.close();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                LOG.warning("Interrupted trying to close zooKeeper");
            }
            finally {
                this.zooKeeper = null;
                this.sessionState = null;
            }
        }
    }

    @VisibleForTesting
    synchronized boolean isClosed() {
        return this.zooKeeper == null;
    }

    @VisibleForTesting
    ZooKeeper getZooKeeperClientForTests() {
        return this.zooKeeper;
    }

    private final class SessionState {
        private final long sessionId;
        private final byte[] sessionPasswd;

        private SessionState(long l, byte[] byArray) {
            this.sessionId = l;
            this.sessionPasswd = byArray;
        }
    }

    public static interface Credentials {
        public static final Credentials NONE = new Credentials(){

            @Override
            public void authenticate(ZooKeeper zooKeeper) {
            }

            @Override
            public String scheme() {
                return null;
            }

            @Override
            public byte[] authToken() {
                return null;
            }
        };

        public void authenticate(ZooKeeper var1);

        @Nullable
        public String scheme();

        @Nullable
        public byte[] authToken();
    }

    public class ZooKeeperConnectionException
    extends Exception {
        public ZooKeeperConnectionException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

