/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.zookeeper;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.twitter.common.quantity.Amount;
import com.twitter.common.quantity.Time;
import com.twitter.common.quantity.Unit;
import com.twitter.common.zookeeper.ZooKeeperClient;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.common.PathUtils;
import org.apache.zookeeper.data.ACL;

public final class ZooKeeperUtils {
    private static final Logger LOG = Logger.getLogger(ZooKeeperUtils.class.getName());
    public static final Amount<Integer, Time> DEFAULT_ZK_SESSION_TIMEOUT = Amount.of((int)4, (Unit)Time.SECONDS);
    public static final int ANY_VERSION = -1;
    public static final ImmutableList<ACL> OPEN_ACL_UNSAFE = ImmutableList.copyOf((Collection)ZooDefs.Ids.OPEN_ACL_UNSAFE);
    public static final ImmutableList<ACL> EVERYONE_READ_CREATOR_ALL = ImmutableList.builder().addAll((Iterable)ZooDefs.Ids.CREATOR_ALL_ACL).addAll((Iterable)ZooDefs.Ids.READ_ACL_UNSAFE).build();

    public static boolean isRetryable(KeeperException keeperException) {
        Preconditions.checkNotNull((Object)keeperException);
        switch (keeperException.code()) {
            case CONNECTIONLOSS: 
            case SESSIONEXPIRED: 
            case SESSIONMOVED: 
            case OPERATIONTIMEOUT: {
                return true;
            }
        }
        return false;
    }

    public static void ensurePath(ZooKeeperClient zooKeeperClient, List<ACL> list, String string) throws ZooKeeperClient.ZooKeeperConnectionException, InterruptedException, KeeperException {
        Preconditions.checkNotNull((Object)zooKeeperClient);
        Preconditions.checkNotNull((Object)string);
        Preconditions.checkArgument((boolean)string.startsWith("/"));
        ZooKeeperUtils.ensurePathInternal(zooKeeperClient, list, string);
    }

    private static void ensurePathInternal(ZooKeeperClient zooKeeperClient, List<ACL> list, String string) throws ZooKeeperClient.ZooKeeperConnectionException, InterruptedException, KeeperException {
        if (zooKeeperClient.get().exists(string, false) == null) {
            int n = string.lastIndexOf(47);
            if (n > 0) {
                ZooKeeperUtils.ensurePathInternal(zooKeeperClient, list, string.substring(0, n));
            }
            try {
                zooKeeperClient.get().create(string, null, list, CreateMode.PERSISTENT);
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                LOG.info("Node existed when trying to ensure path " + string + ", somebody beat us to it?");
            }
        }
    }

    public static String normalizePath(String string) {
        String string2 = string.replaceAll("//+", "/").replaceFirst("(.+)/$", "$1");
        PathUtils.validatePath((String)string2);
        return string2;
    }

    private ZooKeeperUtils() {
    }
}

