/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.api;

import com.twitter.heron.api.Config;
import com.twitter.heron.api.HeronTopology;
import com.twitter.heron.api.exception.AlreadyAliveException;
import com.twitter.heron.api.exception.InvalidTopologyException;
import com.twitter.heron.api.generated.TopologyAPI;
import com.twitter.heron.api.utils.TopologyUtils;
import com.twitter.heron.api.utils.Utils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class HeronSubmitter {
    private static final Logger LOG = Logger.getLogger(HeronSubmitter.class.getName());

    private HeronSubmitter() {
    }

    public static void submitTopology(String name, Config heronConfig, HeronTopology topology) throws AlreadyAliveException, InvalidTopologyException {
        Map<String, String> heronCmdOptions = Utils.readCommandLineOpts();
        TopologyAPI.TopologyState initialState = heronCmdOptions.get("cmdline.topology.initial.state") != null ? TopologyAPI.TopologyState.valueOf(heronCmdOptions.get("cmdline.topology.initial.state")) : TopologyAPI.TopologyState.RUNNING;
        LOG.log(Level.FINE, "To deploy a topology in initial state {0}", initialState);
        TopologyAPI.Topology fTopology = topology.setConfig(heronConfig).setName(name).setState(initialState).getTopology();
        TopologyUtils.validateTopology(fTopology);
        assert (fTopology.isInitialized());
        if (heronCmdOptions.get("cmdline.topologydefn.tmpdirectory") == null) {
            throw new RuntimeException("topology definition temp directory not specified");
        }
        HeronSubmitter.submitTopologyToFile(fTopology, heronCmdOptions);
    }

    private static void submitTopologyToFile(TopologyAPI.Topology fTopology, Map<String, String> heronCmdOptions) {
        String dirName = heronCmdOptions.get("cmdline.topologydefn.tmpdirectory");
        if (dirName == null || dirName.isEmpty()) {
            throw new RuntimeException("Improper specification of directory");
        }
        String fileName = dirName + "/" + fTopology.getName() + ".defn";
        BufferedOutputStream bos = null;
        try {
            FileOutputStream fos = new FileOutputStream(new File(fileName));
            bos = new BufferedOutputStream(fos);
            byte[] topEncoding = fTopology.toByteArray();
            bos.write(topEncoding);
            bos.flush();
            bos.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing topology defn to temp directory " + dirName);
        }
    }

    public static String submitJar(Config config, String localJar) {
        throw new UnsupportedOperationException("submitJar unsupported");
    }
}

