/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.api;

import com.twitter.heron.api.Config;
import com.twitter.heron.api.generated.TopologyAPI;
import com.twitter.heron.api.utils.Utils;
import java.util.Map;
import java.util.UUID;

public class HeronTopology {
    private TopologyAPI.Topology.Builder topologyBuilder;
    private String name;
    private TopologyAPI.TopologyState state;
    private Config heronConfig;

    public HeronTopology(TopologyAPI.Topology.Builder topologyBuilder) {
        this.topologyBuilder = topologyBuilder;
    }

    private static void addDefaultTopologyConfig(Map<String, Object> userConfig) {
        if (!userConfig.containsKey("topology.debug")) {
            userConfig.put("topology.debug", "false");
        }
        if (!userConfig.containsKey("topology.stmgrs")) {
            userConfig.put("topology.stmgrs", "1");
        }
        if (!userConfig.containsKey("topology.message.timeout.secs")) {
            userConfig.put("topology.message.timeout.secs", "30");
        }
        if (!userConfig.containsKey("topology.component.parallelism")) {
            userConfig.put("topology.component.parallelism", "1");
        }
        if (!userConfig.containsKey("topology.max.spout.pending")) {
            userConfig.put("topology.max.spout.pending", "100");
        }
        if (!userConfig.containsKey("topology.reliability.mode")) {
            userConfig.put("topology.reliability.mode", String.valueOf((Object)Config.TopologyReliabilityMode.ATMOST_ONCE));
        }
        if (!userConfig.containsKey("topology.enable.message.timeouts")) {
            userConfig.put("topology.enable.message.timeouts", "true");
        }
    }

    public TopologyAPI.Topology getTopology() {
        if (this.name == null || this.state == null || this.heronConfig == null) {
            throw new IllegalArgumentException("Failed to build topology; missing necessary info.");
        }
        String topologyId = this.name + UUID.randomUUID().toString();
        this.topologyBuilder.setId(topologyId);
        this.topologyBuilder.setName(this.name);
        this.topologyBuilder.setState(this.state);
        HeronTopology.addDefaultTopologyConfig(this.heronConfig);
        this.heronConfig.put("topology.name", this.name);
        this.topologyBuilder.setTopologyConfig(Utils.getConfigBuilder(this.heronConfig));
        return this.topologyBuilder.build();
    }

    public HeronTopology setName(String topologyName) {
        this.name = topologyName;
        return this;
    }

    public HeronTopology setState(TopologyAPI.TopologyState topologyState) {
        this.state = topologyState;
        return this;
    }

    public HeronTopology setConfig(Config hConfig) {
        this.heronConfig = hConfig;
        return this;
    }
}

